/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.mixin;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.github.cao.awa.sepals.transform.mixin.config.SepalsMixinConfig;
import com.github.cao.awa.sepals.transform.mixin.handler.SepalsMixinHandler;
import com.github.cao.awa.sinuatum.manipulate.Manipulate;
import com.github.cao.awa.sinuatum.manipulate.SupplyManipulate;
import com.github.cao.awa.sinuatum.util.io.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.service.IMixinService;
import org.spongepowered.asm.service.MixinService;

public class SepalsMixinPlugin
implements IMixinConfigPlugin {
    private static final Logger LOGGER = LogManager.getLogger((String)"SepalsMixinPlugin");
    private static SepalsMixinConfig config;

    public void onLoad(String mixinPackage) {
        LOGGER.info("Sepals plugin for version '{}' is loading", (Object)"1.0.13");
        if (config == null) {
            SepalsMixinHandler.registerDefaultHandlers();
            config = (SepalsMixinConfig)((SupplyManipulate)Manipulate.supplyLater(() -> {
                IMixinService service = MixinService.getService();
                InputStream resource = service.getResourceAsStream("sepals.mixin-handlers.json");
                if (resource == null) {
                    throw new IllegalArgumentException("The specified resource 'sepals.mixin-handlers.json' was invalid or could not be read");
                }
                try {
                    return SepalsMixinConfig.create(JSONObject.parse(IOUtil.read(new InputStreamReader(resource)), new JSONReader.Feature[0]));
                }
                catch (IOException e) {
                    LOGGER.warn((Object)e);
                    return null;
                }
            }).catching(Exception.class, Throwable::printStackTrace)).get();
        }
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        mixinClassName = mixinClassName.replace("/", ".");
        return config.ifHasHandlerConfig(mixinClassName, handlerConfig -> {
            SepalsMixinHandler.appendPostProcesses(() -> handlerConfig.handler().postProcess(handlerConfig.group(), handlerConfig.name(), handlerConfig.className()));
            LOGGER.info("Handling: {} in group {} / {}", (Object)handlerConfig.group(), (Object)handlerConfig.name(), (Object)handlerConfig.className());
            return handlerConfig.handler().canApply(handlerConfig.group(), handlerConfig.name(), handlerConfig.className());
        }, () -> true);
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

