/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.mixin.entity.ai.brain;

import com.github.cao.awa.catheter.Catheter;
import com.github.cao.awa.sepals.entity.ai.brain.TaskDelegate;
import com.github.cao.awa.sepals.entity.ai.task.composite.SepalsTaskStatus;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4168;
import net.minecraft.class_4831;
import net.minecraft.class_7893;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_4095.class})
public abstract class BrainMixin<E extends class_1309>
implements TaskDelegate<E> {
    @Shadow
    @Final
    private Map<Integer, Map<class_4168, Set<class_7893<? super E>>>> field_18324;
    @Shadow
    @Final
    private Map<class_4140<?>, Optional<? extends class_4831<?>>> field_18322;
    @Unique
    private Catheter<class_7893<? super E>> taskCatheter;
    @Unique
    private Catheter<class_7893<? super E>> runningTasks;
    @Unique
    private Catheter<Map.Entry<class_4140<?>, Optional<? extends class_4831<?>>>> memoriesCatheter;

    @Shadow
    public abstract <U> void method_18875(class_4140<U> var1);

    @Shadow
    public abstract boolean method_18906(class_4168 var1);

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void initBrain(Collection<? extends class_4140<?>> memories, Collection<? extends class_4149<? extends class_4148<? super E>>> sensors, ImmutableList<?> memoryEntries, Supplier<Codec<class_4095<E>>> codecSupplier, CallbackInfo ci) {
        this.constructTasks();
        this.constructMemories();
    }

    @Unique
    private void constructTasks() {
        this.taskCatheter = Catheter.of(this.field_18324.values()).collectionFlatTo(Map::entrySet).filter(this::method_18906, Map.Entry::getKey).collectionFlatTo(Map.Entry::getValue);
    }

    @Unique
    private Catheter<class_7893<? super E>> getTasks() {
        if (this.taskCatheter == null) {
            this.constructTasks();
        }
        return this.taskCatheter;
    }

    @Unique
    private Catheter<class_7893<? super E>> getRunningTasks() {
        if (this.runningTasks == null) {
            this.constructRunningTasks();
        }
        return this.runningTasks;
    }

    @Unique
    private void constructRunningTasks() {
        this.runningTasks = this.getTasks().filterTo(SepalsTaskStatus::isRunning, class_7893::method_18921);
    }

    @Unique
    private Catheter<Map.Entry<class_4140<?>, Optional<? extends class_4831<?>>>> getMemories() {
        if (this.memoriesCatheter == null) {
            this.constructMemories();
        }
        return this.memoriesCatheter;
    }

    @Unique
    private void constructMemories() {
        this.memoriesCatheter = Catheter.of(this.field_18322.entrySet());
    }

    @Inject(method={"setMemory"}, at={@At(value="INVOKE", target="Ljava/util/Map;put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;")})
    private <U> void setMemory(class_4140<U> type, Optional<? extends class_4831<?>> memory, CallbackInfo ci) {
        this.constructMemories();
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/ai/brain/Brain;tickMemories()V"))
    private void tickMemories(class_4095<E> instance) {
        this.getMemories().each(entry -> {
            Optional memOp = (Optional)entry.getValue();
            if (memOp.isPresent()) {
                class_4831 memory = (class_4831)memOp.get();
                if (memory.method_24634()) {
                    this.method_18875((class_4140)entry.getKey());
                }
                memory.method_24913();
            }
        });
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/ai/brain/Brain;startTasks(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/entity/LivingEntity;)V"))
    private void startTasks(class_4095<E> instance, class_3218 world, E entity) {
        long time = entity.method_37908().method_8510();
        Catheter<class_7893> running = this.getTasks().filterTo(task -> {
            if (SepalsTaskStatus.isStopped(task.method_18921())) {
                return task.method_18922(world, entity, time);
            }
            return true;
        });
        if (this.runningTasks != null) {
            this.runningTasks.merge(running);
        } else {
            this.runningTasks = running;
        }
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/ai/brain/Brain;updateTasks(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/entity/LivingEntity;)V"))
    private void updateTasks(class_4095<E> instance, class_3218 world, E entity) {
        long time = entity.method_37908().method_8510();
        this.getRunningTasks().filter(task -> {
            boolean running = SepalsTaskStatus.isRunning(task.method_18921());
            if (running) {
                task.method_18923(world, entity, time);
            }
            return running;
        });
    }

    @Inject(method={"stopAllTasks"}, at={@At(value="HEAD")}, cancellable=true)
    private void stopAllTasks(class_3218 world, E entity, CallbackInfo ci) {
        long time = entity.method_37908().method_8510();
        this.getRunningTasks().each(task -> task.method_18925(world, entity, time));
        this.runningTasks = null;
        ci.cancel();
    }

    @Inject(method={"setTaskList(Lnet/minecraft/entity/ai/brain/Activity;Lcom/google/common/collect/ImmutableList;Ljava/util/Set;Ljava/util/Set;)V"}, at={@At(value="RETURN")})
    private void updateTasks(class_4168 activity, ImmutableList<? extends Pair<Integer, ? extends class_7893<?>>> indexedTasks, Set<Pair<class_4140<?>, class_4141>> requiredMemories, Set<class_4140<?>> forgettingMemories, CallbackInfo ci) {
        this.constructTasks();
    }

    @Inject(method={"clear()V"}, at={@At(value="RETURN")})
    private void clearTasks(CallbackInfo ci) {
        this.taskCatheter = null;
        this.runningTasks = null;
    }

    @Override
    public Catheter<class_7893<? super E>> sepals$tasks() {
        return this.taskCatheter.dump();
    }

    @Inject(method={"resetPossibleActivities(Lnet/minecraft/entity/ai/brain/Activity;)V"}, at={@At(value="INVOKE", target="Ljava/util/Set;add(Ljava/lang/Object;)Z", shift=At.Shift.AFTER)})
    private void resetPossibleActivities(class_4168 except, CallbackInfo ci) {
        this.constructTasks();
    }
}

