/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.mixin.entity.item;

import com.github.cao.awa.sepals.Sepals;
import com.github.cao.awa.sepals.item.BoxedItemEntities;
import com.github.cao.awa.sepals.mixin.entity.item.ItemEntityAccessor;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_5575;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1542.class})
public abstract class ItemEntityMixin
extends class_1297 {
    @Unique
    private boolean isFireImmuneCached = false;
    @Unique
    private boolean fireImmune = false;

    public ItemEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Shadow
    protected abstract boolean method_20397();

    @Shadow
    protected abstract void method_6972(class_1542 var1);

    @Inject(method={"tryMerge()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void tryMerge(CallbackInfo ci) {
        if (Sepals.CONFIG.isEnableSepalsItemMerge()) {
            if (this.method_20397()) {
                this.getBoxedEntities(this.method_37908(), this.method_5829().method_1009(0.5, 0.0, 0.5), itemEntity -> {
                    this.method_6972((class_1542)itemEntity);
                    return this.method_31481();
                });
            }
            ci.cancel();
        }
    }

    @Unique
    public void getBoxedEntities(class_1937 world, class_238 box, Predicate<class_1542> invalidate) {
        if (world instanceof BoxedItemEntities) {
            BoxedItemEntities entities = (BoxedItemEntities)world;
            entities.setEntities(world.method_18023(class_5575.method_31795(class_1542.class), box, entity -> entity != this && ((ItemEntityAccessor)entity).invokeCanMerge()));
            for (class_1542 entity2 : entities.entities()) {
                if (entity2 == this) continue;
                if (!((ItemEntityAccessor)entity2).invokeCanMerge()) {
                    entities.invalidate(entity2);
                    continue;
                }
                if (!entity2.method_5829().method_994(box)) continue;
                entities.invalidate((class_1542)this);
                if (!invalidate.test(entity2)) continue;
                break;
            }
        }
    }

    @Inject(method={"isFireImmune"}, at={@At(value="HEAD")}, cancellable=true)
    private void fireImmune(CallbackInfoReturnable<Boolean> cir) {
        if (this.isFireImmuneCached) {
            cir.setReturnValue((Object)this.fireImmune);
        }
    }

    @Inject(method={"isFireImmune"}, at={@At(value="RETURN")})
    private void cacheFireImmune(CallbackInfoReturnable<Boolean> cir) {
        this.isFireImmuneCached = true;
        this.fireImmune = (Boolean)cir.getReturnValue();
    }
}

