/*
 * Decompiled with CFR 0.152.
 */
package artifacts.ability;

import artifacts.ArtifactsClient;
import artifacts.client.ToggleKeyHandler;
import artifacts.registry.ModAbilities;
import artifacts.util.AbilityHelper;
import artifacts.util.ModCodecs;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public interface ArtifactAbility {
    public static final Codec<ArtifactAbility> CODEC = ModCodecs.lazyCodec(() -> ModAbilities.getRegistry().method_39673().dispatch("type", ArtifactAbility::getType, Type::codec));
    public static final class_9139<class_9129, ArtifactAbility> STREAM_CODEC = ModCodecs.lazyStreamCodec(() -> class_9135.method_56365((class_5321)ModAbilities.REGISTRY.key()).method_56440(ArtifactAbility::getType, Type::streamCodec));

    public Type<?> getType();

    public boolean isNonCosmetic();

    default public boolean isEnabled() {
        return this.isNonCosmetic();
    }

    default public boolean isActive(class_1309 entity) {
        return this.isEnabled() && AbilityHelper.isToggledOn(this.getType(), entity);
    }

    default public void addTooltipIfNonCosmetic(List<class_5250> tooltip) {
        if (this.isNonCosmetic()) {
            this.addAbilityTooltip(tooltip);
            this.addToggleKeyTooltip(tooltip);
        }
    }

    default public void addAbilityTooltip(List<class_5250> tooltip) {
        class_2960 id = ModAbilities.REGISTRY.getId(this.getType());
        tooltip.add(class_2561.method_43471((String)"%s.tooltip.ability.%s".formatted(id.method_12836(), id.method_12832())));
    }

    default public void addToggleKeyTooltip(List<class_5250> tooltip) {
        class_304 key = ToggleKeyHandler.getToggleKey(this.getType());
        class_1657 player = null;
        if (class_310.method_1551() != null) {
            player = ArtifactsClient.getLocalPlayer();
        }
        if (!(key == null || player == null || key.method_1415() && AbilityHelper.isToggledOn(this.getType(), (class_1309)player))) {
            tooltip.add(class_2561.method_43469((String)"%s.tooltip.toggle_keymapping".formatted("artifacts"), (Object[])new Object[]{key.method_16007()}));
        }
    }

    default public class_5250 tooltipLine(String abilityName, Object ... args) {
        class_2960 id = ModAbilities.REGISTRY.getId(this.getType());
        return class_2561.method_43469((String)"%s.tooltip.ability.%s.%s".formatted(id.method_12836(), id.method_12832(), abilityName), (Object[])args);
    }

    default public void wornTick(class_1309 entity, boolean isOnCooldown, boolean isActive) {
    }

    default public void onUnequip(class_1309 entity, boolean wasActive) {
    }

    public record Type<T extends ArtifactAbility>(MapCodec<T> codec, class_9139<? super class_9129, T> streamCodec) {
    }
}

