/*
 * Decompiled with CFR 0.152.
 */
package net.scirave.nox.util;

import java.util.HashSet;
import net.minecraft.class_1266;
import net.minecraft.class_1280;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1427;
import net.minecraft.class_1510;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1670;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9285;
import net.scirave.nox.config.NoxConfig;
import org.jetbrains.annotations.Nullable;

public class NoxUtil {
    public static final class_6862<class_2248> NOX_ALWAYS_MINE = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60654((String)"nox:always_mine"));
    public static final class_6862<class_2248> NOX_CANT_MINE = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60654((String)"nox:cant_mine"));
    public static final class_6862<class_1792> FIREPROOF = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60654((String)"nox:fireproof"));
    public static final class_6862<class_1792> ARMOR = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60654((String)"nox:mob_armor"));
    public static final class_6862<class_1792> TOOLS = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60654((String)"nox:mob_tools"));
    private static final class_1799 WOOD_PICKAXE = class_1802.field_8647.method_7854();
    private static final class_1799 WOOD_AXE = class_1802.field_8406.method_7854();
    private static final class_1799 WOOD_SHOVEL = class_1802.field_8876.method_7854();

    public static boolean isAtWoodLevel(class_2680 state) {
        return !state.method_29291() || WOOD_PICKAXE.method_7951(state) || WOOD_AXE.method_7951(state) || WOOD_SHOVEL.method_7951(state);
    }

    public static boolean isAnAlly(class_1308 attacker, class_1308 victim) {
        boolean validTypes = attacker instanceof class_1569 && victim instanceof class_1569 || attacker instanceof class_1427 && victim instanceof class_1427;
        class_1309 attackerTarget = attacker.method_5968();
        class_1309 victimTarget = victim.method_5968();
        return NoxConfig.noFriendlyFire && validTypes && attackerTarget != attacker && victimTarget != victim && victimTarget != null && attackerTarget == victimTarget;
    }

    public static void EnderDragonShootFireball(class_1510 dragon, class_1309 target) {
        class_243 i = dragon.method_5828(1.0f);
        double k = dragon.field_7017.method_23317() - i.field_1352;
        double l = dragon.field_7017.method_23323(0.5) + 0.5;
        double m = dragon.field_7017.method_23321() - i.field_1350;
        double n = target.method_23317() - k;
        double o = target.method_23323(0.5) - l;
        double p = target.method_23321() - m;
        if (!dragon.method_5701()) {
            dragon.method_37908().method_8444(null, 1017, dragon.method_24515(), 0);
        }
        class_1670 dragonFireballEntity = new class_1670(dragon.method_37908(), (class_1309)dragon, new class_243(n, o, p));
        dragonFireballEntity.method_5808(k, l, m, 0.0f, 0.0f);
        dragonFireballEntity.field_51893 *= 5.0;
        dragon.method_37908().method_8649((class_1297)dragonFireballEntity);
    }

    public static class_1792 randomWeapon(class_5819 random) {
        return class_7923.field_41178.method_40260(TOOLS).method_40243(random).map(class_6880::comp_349).orElse(class_1802.field_8162);
    }

    public static class_1792 randomArmor(class_5819 random) {
        return class_7923.field_41178.method_40260(ARMOR).method_40243(random).map(class_6880::comp_349).orElse(class_1802.field_8162);
    }

    public static double getLeewayAmount(class_1309 armorWearer, double damage, double total, int armor, double toughness, double modifier, class_1282 source) {
        double diff = damage * modifier - (double)class_1280.method_5496((class_1309)armorWearer, (float)((float)total), (class_1282)source, (float)armor, (float)((float)toughness));
        double ratio = 0.0;
        if (diff != 0.0) {
            ratio = diff / damage;
        }
        return ratio;
    }

    public static boolean resistanceWithinLeeway(class_1309 armorWearer, double damage, double total, int armor, double toughness, double lowerLeeway, double higherLeeway, double modifier, class_1282 source) {
        double ratio = NoxUtil.getLeewayAmount(armorWearer, damage, total, armor, toughness, modifier, source);
        return ratio >= -higherLeeway && ratio <= lowerLeeway;
    }

    public static double getItemQuality(class_1792 item, class_1304 slot, class_6880<class_1320> type, @Nullable Double base) {
        if (base == null) {
            base = 0.0;
        }
        class_9285 map = item.method_7844();
        double multiple = 0.0;
        double multiply = 1.0;
        double add = 0.0;
        for (class_9285.class_9287 entry : map.comp_2393()) {
            class_6880 attribute = entry.comp_2395();
            class_1322 modifier = entry.comp_2396();
            if (attribute != type || !entry.comp_2397().method_57286(slot)) continue;
            switch (modifier.comp_2450()) {
                case field_6330: {
                    multiple += modifier.comp_2449();
                    break;
                }
                case field_6328: {
                    add += modifier.comp_2449();
                    break;
                }
                case field_6331: {
                    multiply *= 1.0 + modifier.comp_2449();
                }
            }
        }
        return (base + add + (base + add) * multiple) * multiply;
    }

    public static double getItemDamage(class_1792 item, class_1304 slot, double baseDamage) {
        return NoxUtil.getItemQuality(item, slot, (class_6880<class_1320>)class_5134.field_23721, baseDamage);
    }

    public static class_3545<Integer, Float> getItemProtection(class_1792 item, class_1304 slot, double baseDamage) {
        int armor = (int)Math.floor(NoxUtil.getItemQuality(item, slot, (class_6880<class_1320>)class_5134.field_23724, 0.0));
        float toughness = (float)NoxUtil.getItemQuality(item, slot, (class_6880<class_1320>)class_5134.field_23725, 0.0);
        return new class_3545((Object)armor, (Object)Float.valueOf(toughness));
    }

    public static double getItemDPS(class_1792 item, class_1304 slot, double baseDamage, double attackSpeed) {
        return NoxUtil.getItemQuality(item, slot, (class_6880<class_1320>)class_5134.field_23721, baseDamage) * NoxUtil.getItemQuality(item, slot, (class_6880<class_1320>)class_5134.field_23723, attackSpeed);
    }

    public static double getBestPlayerDPS(class_1657 player) {
        double potential;
        double defaultAttackSpeed = player.method_45325(class_5134.field_23723);
        double damage = 0.0;
        class_1661 inventory = player.method_31548();
        for (int i = 0; i < 8; ++i) {
            double potential2;
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960() || !((potential2 = NoxUtil.getItemDPS(stack.method_7909(), class_1304.field_6173, 1.0, defaultAttackSpeed)) > damage)) continue;
            damage = potential2;
        }
        class_1799 stack = inventory.method_5438(40);
        if (!stack.method_7960() && (potential = NoxUtil.getItemDPS(stack.method_7909(), class_1304.field_6173, 1.0, defaultAttackSpeed)) > damage) {
            damage = potential;
        }
        return damage;
    }

    public static void weaponRoulette(class_3218 world, class_1308 mob, class_5819 random, class_1266 difficulty) {
        class_1657 player = world.method_18459(mob.method_23317(), mob.method_23318(), mob.method_23321(), 128.0, true);
        if (player != null) {
            double damage;
            boolean noWeapon;
            int luck = class_3532.method_15395((class_5819)random, (int)1, (int)4);
            boolean freeFirstPass = luck == 1;
            boolean bl = noWeapon = luck == 4;
            if (noWeapon) {
                return;
            }
            int armor = player.method_6096();
            float toughness = (float)mob.method_45325(class_5134.field_23725);
            double total = damage = mob.method_45325(class_5134.field_23721);
            double mod = player.method_6063() / Math.max(mob.method_6063(), 20.0f);
            float clamped = difficulty.method_5458();
            double lowerLeeway = 0.5;
            lowerLeeway -= lowerLeeway * 0.5 * (double)clamped;
            double higherLeeway = 0.25;
            higherLeeway += higherLeeway * 4.0 * (double)clamped;
            class_1792 item = null;
            for (int iterated = 0; freeFirstPass || !NoxUtil.resistanceWithinLeeway((class_1309)mob, damage, total, armor, toughness, lowerLeeway, higherLeeway, mod, world.method_48963().method_48830()) && iterated < 20; ++iterated) {
                freeFirstPass = false;
                for (int i = 0; i < 5 && !NoxUtil.resistanceWithinLeeway((class_1309)mob, damage, total = NoxUtil.getItemDamage(item = NoxUtil.randomWeapon(random), class_1304.field_6173, damage), armor, toughness, lowerLeeway, higherLeeway, mod, world.method_48963().method_48830()); ++i) {
                }
                lowerLeeway += 0.1;
                higherLeeway += 0.1;
            }
            if (item != null) {
                class_1799 stack = item.method_7854();
                mob.method_5673(class_1304.field_6173, stack);
            }
        }
    }

    public static void armorRoulette(class_3218 world, class_1308 mob, class_5819 random, class_1266 difficulty) {
        class_1657 player = world.method_18459(mob.method_23317(), mob.method_23318(), mob.method_23321(), 64.0, true);
        if (player != null) {
            boolean noArmor;
            int luck = class_3532.method_15395((class_5819)random, (int)1, (int)4);
            boolean freeFirstPass = luck == 1;
            boolean bl = noArmor = luck == 4;
            if (noArmor) {
                return;
            }
            double modifier = Math.max(mob.method_6063(), 20.0f) / player.method_6063();
            double damage = 8.0;
            double total = Math.max(NoxUtil.getBestPlayerDPS(player) / 3.0 * 2.0, damage);
            int armor = 0;
            float toughness = 0.0f;
            float clamped = difficulty.method_5458();
            double lowerLeeway = 0.25;
            lowerLeeway += lowerLeeway * 4.0 * (double)clamped;
            double higherLeeway = 0.5;
            higherLeeway -= higherLeeway * 0.5 * (double)clamped;
            HashSet<class_1738> armorItems = new HashSet<class_1738>();
            for (int iterated = 0; freeFirstPass || !NoxUtil.resistanceWithinLeeway((class_1309)mob, damage, total, armor, toughness, lowerLeeway, higherLeeway, modifier, world.method_48963().method_48830()) && iterated < 20; ++iterated) {
                freeFirstPass = false;
                for (int i = 0; i < 5; ++i) {
                    double lastLeeway = NoxUtil.getLeewayAmount((class_1309)mob, damage, total, armor, toughness, modifier, world.method_48963().method_48830());
                    class_1792 item = NoxUtil.randomArmor(random);
                    if (item instanceof class_1738) {
                        double newLeeway;
                        class_1738 armorItem = (class_1738)item;
                        class_1304 slot = armorItem.method_7685();
                        class_1738 toRemove = null;
                        for (class_1738 potential : armorItems) {
                            if (potential.method_7685() != slot) continue;
                            toRemove = potential;
                            break;
                        }
                        if (toRemove != null) {
                            armor -= toRemove.method_7687();
                            toughness -= toRemove.method_26353();
                        }
                        if ((newLeeway = NoxUtil.getLeewayAmount((class_1309)mob, damage, total, armor += armorItem.method_7687(), toughness += armorItem.method_26353(), modifier, world.method_48963().method_48830())) <= 0.0 && newLeeway - lastLeeway >= 0.0 || NoxUtil.resistanceWithinLeeway((class_1309)mob, damage, total, armor, toughness, lowerLeeway, higherLeeway, modifier, world.method_48963().method_48830())) {
                            if (toRemove != null) {
                                armorItems.remove(toRemove);
                            }
                            armorItems.add(armorItem);
                        } else {
                            armor -= armorItem.method_7687();
                            toughness -= armorItem.method_26353();
                            if (toRemove != null) {
                                armor += toRemove.method_7687();
                                toughness += toRemove.method_26353();
                            }
                        }
                    }
                    if (NoxUtil.resistanceWithinLeeway((class_1309)mob, damage, total, armor, toughness, lowerLeeway, higherLeeway, modifier, world.method_48963().method_48830())) break;
                }
                lowerLeeway += 0.1;
                higherLeeway += 0.1;
            }
            if (!armorItems.isEmpty()) {
                for (class_1738 item : armorItems) {
                    mob.method_5673(item.method_7685(), item.method_7854());
                }
            }
        }
    }
}

