/*
 * Decompiled with CFR 0.152.
 */
package dev.mrturtle.analog;

import dev.mrturtle.analog.ModBlockEntities;
import dev.mrturtle.analog.ModBlocks;
import dev.mrturtle.analog.ModDataComponents;
import dev.mrturtle.analog.ModItems;
import dev.mrturtle.analog.ModSounds;
import dev.mrturtle.analog.audio.assets.MusicAssetManager;
import dev.mrturtle.analog.config.ConfigManager;
import dev.mrturtle.analog.util.RadioUtil;
import dev.mrturtle.analog.world.GlobalRadioState;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Analog
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"analog");

    public void onInitialize() {
        ConfigManager.loadConfig();
        PolymerResourcePackUtils.addModAssets((String)"analog");
        PolymerResourcePackUtils.markAsRequired();
        ModDataComponents.initialize();
        ModItems.initialize();
        ModBlocks.initialize();
        ModBlockEntities.initialize();
        ModSounds.initialize();
        ServerTickEvents.START_WORLD_TICK.register(world -> {
            GlobalRadioState globalRadioState = RadioUtil.getGlobalRadioState(world);
            globalRadioState.audioManager.tick(world);
        });
        ServerLifecycleEvents.SERVER_STARTED.register(MusicAssetManager::serverStarted);
    }
}

