/*
 * Decompiled with CFR 0.152.
 */
package dev.mrturtle.analog;

import de.maxhenkel.voicechat.api.VoicechatConnection;
import de.maxhenkel.voicechat.api.VoicechatPlugin;
import de.maxhenkel.voicechat.api.VoicechatServerApi;
import de.maxhenkel.voicechat.api.VolumeCategory;
import de.maxhenkel.voicechat.api.events.EventRegistration;
import de.maxhenkel.voicechat.api.events.MicrophonePacketEvent;
import de.maxhenkel.voicechat.api.events.VoicechatServerStartedEvent;
import de.maxhenkel.voicechat.api.packets.MicrophonePacket;
import dev.mrturtle.analog.ModDataComponents;
import dev.mrturtle.analog.config.ConfigManager;
import dev.mrturtle.analog.item.component.RadioComponent;
import dev.mrturtle.analog.util.RadioUtil;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3222;

public class AnalogPlugin
implements VoicechatPlugin {
    public static VoicechatServerApi API;
    public static String RADIO_CATEGORY;

    public void registerEvents(EventRegistration registration) {
        registration.registerEvent(VoicechatServerStartedEvent.class, this::onServerStarted);
        registration.registerEvent(MicrophonePacketEvent.class, this::onMicrophonePacket);
    }

    private void onServerStarted(VoicechatServerStartedEvent event) {
        API = event.getVoicechat();
        VolumeCategory radios = API.volumeCategoryBuilder().setId(RADIO_CATEGORY).setName("Radios").setDescription("The volume of all radios").build();
        API.registerVolumeCategory(radios);
    }

    private void onMicrophonePacket(MicrophonePacketEvent event) {
        VoicechatConnection connection = event.getSenderConnection();
        VoicechatServerApi serverApi = event.getVoicechat();
        if (connection == null) {
            return;
        }
        if (((MicrophonePacket)event.getPacket()).getOpusEncodedData().length == 0) {
            return;
        }
        class_3222 sourcePlayer = (class_3222)connection.getPlayer().getPlayer();
        if (sourcePlayer.method_7325() && !serverApi.getServerConfig().getBoolean("spectator_interaction", false)) {
            return;
        }
        sourcePlayer.method_5682().execute(() -> {
            int listeningDistance = ConfigManager.config.radioListeningDistance * 2;
            List playersInRange = sourcePlayer.method_51469().method_8390(class_3222.class, class_238.method_30048((class_243)sourcePlayer.method_19538(), (double)listeningDistance, (double)listeningDistance, (double)listeningDistance), entity -> true);
            for (class_3222 player : playersInRange) {
                List<class_1799> radios = RadioUtil.getRadios((class_1657)player);
                for (class_1799 stack : radios) {
                    RadioComponent component = (RadioComponent)stack.method_57825(ModDataComponents.RADIO, (Object)RadioComponent.DEFAULT);
                    if (!component.enabled() || !component.transmit()) continue;
                    int channel = component.channel();
                    RadioUtil.transmitOnChannel(serverApi, (MicrophonePacket)event.getPacket(), player, channel);
                }
            }
            RadioUtil.transmitOnNearbyTransmitters(serverApi, (MicrophonePacket)event.getPacket(), sourcePlayer);
        });
    }

    public String getPluginId() {
        return "analog";
    }

    static {
        RADIO_CATEGORY = "radios";
    }
}

