/*
 * Decompiled with CFR 0.152.
 */
package dev.mrturtle.analog.audio;

import java.util.Arrays;
import java.util.function.Supplier;

public class RadioAudioInstance
extends Thread {
    private static final long CHUNK_SIZE_NS = 20000000L;
    private final short[] audioData;
    private int currentIndex = 0;
    public int channel;
    public final Supplier<short[]> audioSupplier;
    private Runnable onStopped;
    public boolean isDone = false;

    public RadioAudioInstance(int channel, short[] audioData) {
        this.channel = channel;
        this.audioData = audioData;
        this.audioSupplier = () -> {
            if (this.currentIndex > audioData.length) {
                return null;
            }
            return Arrays.copyOfRange(audioData, this.currentIndex, this.currentIndex + 960);
        };
        this.start();
    }

    public RadioAudioInstance(int channel, short[] audioData, Runnable onStopped) {
        this(channel, audioData);
        this.onStopped = onStopped;
    }

    @Override
    public void run() {
        while (this.currentIndex <= this.audioData.length) {
            this.currentIndex += 960;
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException ignored) {
                // empty catch block
                break;
            }
        }
        if (this.onStopped != null) {
            this.onStopped.run();
        }
        this.isDone = true;
    }

    public void setCurrentIndex(int newIndex) {
        this.currentIndex = newIndex;
    }
}

