/*
 * Decompiled with CFR 0.152.
 */
package dev.mrturtle.analog.gui;

import dev.mrturtle.analog.ModDataComponents;
import dev.mrturtle.analog.ModItems;
import dev.mrturtle.analog.config.ConfigManager;
import dev.mrturtle.analog.gui.RadioSelectChannelGui;
import dev.mrturtle.analog.item.component.RadioComponent;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_5250;

public class RadioItemGui
extends SimpleGui {
    private final class_1799 radioStack;

    public RadioItemGui(class_3222 player, class_1799 radioStack) {
        super(class_3917.field_17328, player, false);
        this.radioStack = radioStack;
        this.createEnableButton();
        this.createTransmitButton();
        this.createReceiveButton();
        this.createChannelText();
        this.setSlot(0, (GuiElementInterface)((GuiElementBuilder)new GuiElementBuilder(ModItems.RADIO_CHANNEL_DOWN_BUTTON).setName((class_2561)class_2561.method_43471((String)"gui.analog.radio.channel_down")).setCallback(() -> {
            RadioComponent component = (RadioComponent)radioStack.method_57825(ModDataComponents.RADIO, (Object)RadioComponent.DEFAULT);
            radioStack.method_57379(ModDataComponents.RADIO, (Object)component.withChannel(Math.max(0, component.channel() - 1)));
            this.createChannelText();
        })).build());
        this.setSlot(1, (GuiElementInterface)((GuiElementBuilder)new GuiElementBuilder(ModItems.RADIO_SET_CHANNEL_BUTTON).setName((class_2561)class_2561.method_43471((String)"gui.analog.radio.set_channel")).setCallback(() -> {
            RadioComponent component = (RadioComponent)radioStack.method_57825(ModDataComponents.RADIO, (Object)RadioComponent.DEFAULT);
            RadioSelectChannelGui gui = new RadioSelectChannelGui(player, component.channel(), channel -> {
                radioStack.method_57379(ModDataComponents.RADIO, (Object)component.withChannel((int)channel));
                RadioItemGui radioGui = new RadioItemGui(player, radioStack);
                radioGui.open();
            });
            gui.open();
        })).build());
        this.setSlot(2, (GuiElementInterface)((GuiElementBuilder)new GuiElementBuilder(ModItems.RADIO_CHANNEL_UP_BUTTON).setName((class_2561)class_2561.method_43471((String)"gui.analog.radio.channel_up")).setCallback(() -> {
            int maxRadioChannel = ConfigManager.config.maxRadioChannels - 1;
            RadioComponent component = (RadioComponent)radioStack.method_57825(ModDataComponents.RADIO, (Object)RadioComponent.DEFAULT);
            radioStack.method_57379(ModDataComponents.RADIO, (Object)component.withChannel(Math.min(maxRadioChannel, component.channel() + 1)));
            this.createChannelText();
        })).build());
    }

    private void createChannelText() {
        RadioComponent component = (RadioComponent)this.radioStack.method_57825(ModDataComponents.RADIO, (Object)RadioComponent.DEFAULT);
        Object channelText = String.valueOf(component.channel());
        if (((String)channelText).length() == 1) {
            channelText = "0" + (String)channelText;
        }
        String offsetString = "z".repeat(((String)channelText).length() - 2);
        this.setTitle((class_2561)class_2561.method_43470((String)offsetString).method_10862(this.getTitleStyle()).method_10852((class_2561)this.getDefaultTitle().method_10852((class_2561)class_2561.method_43470((String)channelText))));
    }

    private void createEnableButton() {
        RadioComponent component = (RadioComponent)this.radioStack.method_57825(ModDataComponents.RADIO, (Object)RadioComponent.DEFAULT);
        boolean isEnabled = component.enabled();
        this.setSlot(4, (GuiElementInterface)((GuiElementBuilder)new GuiElementBuilder(isEnabled ? ModItems.RADIO_DISABLE_BUTTON : ModItems.RADIO_ENABLE_BUTTON).setName((class_2561)class_2561.method_43471((String)(isEnabled ? "gui.analog.radio.turn_off" : "gui.analog.radio.turn_on"))).setCallback(() -> {
            this.radioStack.method_57379(ModDataComponents.RADIO, (Object)component.withEnabled(!isEnabled));
            this.createEnableButton();
        })).build());
    }

    private void createTransmitButton() {
        RadioComponent component = (RadioComponent)this.radioStack.method_57825(ModDataComponents.RADIO, (Object)RadioComponent.DEFAULT);
        boolean isTransmitting = component.transmit();
        this.setSlot(5, (GuiElementInterface)((GuiElementBuilder)new GuiElementBuilder(isTransmitting ? ModItems.RADIO_STOP_TRANSMIT_BUTTON : ModItems.RADIO_START_TRANSMIT_BUTTON).setName((class_2561)class_2561.method_43471((String)(isTransmitting ? "gui.analog.radio.stop_transmitting" : "gui.analog.radio.start_transmitting"))).setCallback(() -> {
            this.radioStack.method_57379(ModDataComponents.RADIO, (Object)component.withTransmit(!isTransmitting));
            this.createTransmitButton();
        })).build());
    }

    private void createReceiveButton() {
        RadioComponent component = (RadioComponent)this.radioStack.method_57825(ModDataComponents.RADIO, (Object)RadioComponent.DEFAULT);
        boolean isReceiving = component.receive();
        this.setSlot(3, (GuiElementInterface)((GuiElementBuilder)new GuiElementBuilder(isReceiving ? ModItems.RADIO_STOP_RECEIVE_BUTTON : ModItems.RADIO_START_RECEIVE_BUTTON).setName((class_2561)class_2561.method_43471((String)(isReceiving ? "gui.analog.radio.stop_receiving" : "gui.analog.radio.start_receiving"))).setCallback(() -> {
            this.radioStack.method_57379(ModDataComponents.RADIO, (Object)component.withReceive(!isReceiving));
            this.createReceiveButton();
        })).build());
    }

    public class_5250 getDefaultTitle() {
        return class_2561.method_43470((String)"abc").method_10862(this.getTitleStyle());
    }

    public class_2583 getTitleStyle() {
        return class_2583.field_24360.method_10977(class_124.field_1068).method_27704(class_2960.method_60655((String)"analog", (String)"radio_gui"));
    }
}

