/*
 * Decompiled with CFR 0.152.
 */
package dev.mrturtle.analog.gui;

import dev.mrturtle.analog.ModItems;
import dev.mrturtle.analog.config.ConfigManager;
import eu.pb4.sgui.api.gui.AnvilInputGui;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_9334;

public class RadioSelectChannelGui
extends AnvilInputGui {
    private final Consumer<Integer> finishedConsumer;
    private final int originalChannel;

    public RadioSelectChannelGui(class_3222 player, int currentChannel, Consumer<Integer> finishedConsumer) {
        super(player, false);
        this.finishedConsumer = finishedConsumer;
        this.setDefaultInputValue(String.valueOf(currentChannel));
        this.originalChannel = currentChannel;
        this.setTitle((class_2561)this.getDefaultTitle());
    }

    public void onInput(String input) {
        if (input.isEmpty()) {
            return;
        }
        try {
            int channel = Integer.parseInt(input);
            if (channel >= ConfigManager.config.maxRadioChannels) {
                this.setDefaultInputValue(String.valueOf(ConfigManager.config.maxRadioChannels - 1));
                this.sendGui();
            }
        }
        catch (NumberFormatException ignored) {
            this.setDefaultInputValue(input.replaceAll("\\D", ""));
            this.sendGui();
        }
    }

    public void onClose() {
        try {
            int channel = Integer.parseInt(this.getInput());
            this.finishedConsumer.accept(channel);
        }
        catch (NumberFormatException ignored) {
            this.finishedConsumer.accept(this.originalChannel);
        }
    }

    public void setDefaultInputValue(String input) {
        super.setDefaultInputValue(input);
        class_1799 itemStack = ModItems.RADIO_SET_CHANNEL_BUTTON.method_7854();
        itemStack.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)input));
        this.setSlot(0, itemStack, (index, type1, action, gui) -> {
            this.reOpen = true;
            this.sendGui();
        });
    }

    public class_5250 getDefaultTitle() {
        class_5250 guiTextureText = class_2561.method_43470((String)"gfh").method_10862(class_2583.field_24360.method_10977(class_124.field_1068).method_27704(class_2960.method_60655((String)"analog", (String)"radio_gui")));
        class_5250 titleText = class_2561.method_43471((String)"gui.analog.radio.set_channel.title").method_10862(class_2583.field_24360.method_27704(class_2583.field_24359).method_36139(0x3F3F3F));
        return guiTextureText.method_10852((class_2561)titleText);
    }
}

