/*
 * Decompiled with CFR 0.152.
 */
package dev.mrturtle.analog.gui;

import dev.mrturtle.analog.ModItems;
import dev.mrturtle.analog.block.TransmitterBlockEntity;
import dev.mrturtle.analog.config.ConfigManager;
import dev.mrturtle.analog.gui.RadioSelectChannelGui;
import dev.mrturtle.analog.util.RadioUtil;
import dev.mrturtle.analog.world.GlobalRadioState;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_5250;

public class TransmitterBlockGui
extends SimpleGui {
    private final TransmitterBlockEntity transmitter;

    public TransmitterBlockGui(class_3222 player, TransmitterBlockEntity transmitter) {
        super(class_3917.field_17328, player, false);
        this.transmitter = transmitter;
        this.createEnableButton();
        this.createChannelText();
        this.setSlot(0, (GuiElementInterface)((GuiElementBuilder)new GuiElementBuilder(ModItems.RADIO_CHANNEL_DOWN_BUTTON).setName((class_2561)class_2561.method_43471((String)"gui.analog.radio.channel_down")).setCallback(() -> {
            int currentChannel = transmitter.channel;
            transmitter.channel = Math.max(0, currentChannel - 1);
            class_3218 world = player.method_51469();
            GlobalRadioState globalRadioState = RadioUtil.getGlobalRadioState(world);
            globalRadioState.audioManager.changeTransmitterChannel(transmitter.method_11016(), transmitter.channel);
            transmitter.method_5431();
            this.createChannelText();
        })).build());
        this.setSlot(1, (GuiElementInterface)((GuiElementBuilder)new GuiElementBuilder(ModItems.RADIO_SET_CHANNEL_BUTTON).setName((class_2561)class_2561.method_43471((String)"gui.analog.radio.set_channel")).setCallback(() -> {
            RadioSelectChannelGui gui = new RadioSelectChannelGui(player, transmitter.channel, channel -> {
                transmitter.channel = channel;
                class_3218 world = player.method_51469();
                GlobalRadioState globalRadioState = RadioUtil.getGlobalRadioState(world);
                globalRadioState.audioManager.changeTransmitterChannel(transmitter.method_11016(), transmitter.channel);
                transmitter.method_5431();
                TransmitterBlockGui radioGui = new TransmitterBlockGui(player, transmitter);
                radioGui.open();
            });
            gui.open();
        })).build());
        this.setSlot(2, (GuiElementInterface)((GuiElementBuilder)new GuiElementBuilder(ModItems.RADIO_CHANNEL_UP_BUTTON).setName((class_2561)class_2561.method_43471((String)"gui.analog.radio.channel_up")).setCallback(() -> {
            int maxRadioChannel = ConfigManager.config.maxRadioChannels - 1;
            int currentChannel = transmitter.channel;
            transmitter.channel = Math.min(maxRadioChannel, currentChannel + 1);
            class_3218 world = player.method_51469();
            GlobalRadioState globalRadioState = RadioUtil.getGlobalRadioState(world);
            globalRadioState.audioManager.changeTransmitterChannel(transmitter.method_11016(), transmitter.channel);
            transmitter.method_5431();
            this.createChannelText();
        })).build());
    }

    private void createChannelText() {
        int currentChannel = this.transmitter.channel;
        Object channelText = String.valueOf(currentChannel);
        if (((String)channelText).length() == 1) {
            channelText = "0" + (String)channelText;
        }
        this.setTitle((class_2561)this.getDefaultTitle().method_10852((class_2561)class_2561.method_43470((String)channelText)));
    }

    private void createEnableButton() {
        boolean isEnabled = this.transmitter.enabled;
        this.setSlot(4, (GuiElementInterface)((GuiElementBuilder)new GuiElementBuilder(isEnabled ? ModItems.RADIO_DISABLE_BUTTON : ModItems.RADIO_ENABLE_BUTTON).setName((class_2561)class_2561.method_43471((String)(isEnabled ? "gui.analog.radio.turn_off" : "gui.analog.radio.turn_on"))).setCallback(() -> {
            boolean bl = this.transmitter.enabled = !isEnabled;
            if (!this.transmitter.enabled) {
                class_3218 world = this.player.method_51469();
                GlobalRadioState globalRadioState = RadioUtil.getGlobalRadioState(world);
                globalRadioState.audioManager.stopTransmitter(this.transmitter.method_11016());
            }
            this.transmitter.method_5431();
            this.createEnableButton();
        })).build());
    }

    public class_5250 getDefaultTitle() {
        return class_2561.method_43470((String)"adc").method_10862(class_2583.field_24360.method_10977(class_124.field_1068).method_27704(class_2960.method_60655((String)"analog", (String)"radio_gui")));
    }
}

