/*
 * Decompiled with CFR 0.152.
 */
package dev.mrturtle.analog.mixin;

import dev.mrturtle.analog.Analog;
import dev.mrturtle.analog.access.JukeboxManagerAccessor;
import dev.mrturtle.analog.util.RadioAudioUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2619;
import net.minecraft.class_2680;
import net.minecraft.class_5218;
import net.minecraft.class_7225;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import net.minecraft.class_9793;
import net.minecraft.class_9794;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_2619.class})
public abstract class JukeboxBlockEntityMixin
extends class_2586 {
    @Shadow
    @Final
    private class_9794 field_52066;

    public JukeboxBlockEntityMixin(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Inject(method={"setStack"}, at={@At(value="TAIL")})
    public void setStack(class_1799 stack, CallbackInfo ci) {
        if (this.field_11863.field_9236) {
            return;
        }
        boolean isAudioPlayerDisc = false;
        class_9279 nbt = (class_9279)stack.method_57824(class_9334.field_49628);
        if (nbt != null && nbt.method_57461().method_25928("CustomSound")) {
            isAudioPlayerDisc = true;
        }
        Optional optionalSongEntry = class_9793.method_60753((class_7225.class_7874)this.field_11863.method_30349(), (class_1799)stack);
        if (isAudioPlayerDisc) {
            String songExtension;
            String songName = "%s".formatted(nbt.method_57461().method_25926("CustomSound"));
            Path basePath = this.field_11863.method_8503().method_27050(class_5218.field_24188).resolve("audio_player_data");
            if (!Files.exists(basePath.resolve(songName + (songExtension = ".wav")), new LinkOption[0])) {
                songExtension = ".mp3";
            }
            try {
                ((JukeboxManagerAccessor)this.field_52066).analog$setCachedAudio(RadioAudioUtil.getAudioData(basePath.resolve(songName + songExtension)));
                ((JukeboxManagerAccessor)this.field_52066).analog$makeNearbyTransmittersPlay((class_1936)this.field_11863, true);
            }
            catch (Exception e) {
                Analog.LOGGER.error("Failed to load a custom Audio Player music disc for playback from path %s".formatted(songName + songExtension));
                e.printStackTrace();
            }
        } else if (optionalSongEntry.isEmpty()) {
            ((JukeboxManagerAccessor)this.field_52066).analog$makeNearbyTransmittersStop((class_1936)this.field_11863);
        }
    }
}

