/*
 * Decompiled with CFR 0.152.
 */
package dev.mrturtle.analog.mixin;

import dev.mrturtle.analog.Analog;
import dev.mrturtle.analog.AnalogPlugin;
import dev.mrturtle.analog.access.JukeboxManagerAccessor;
import dev.mrturtle.analog.audio.RadioAudioInstance;
import dev.mrturtle.analog.audio.assets.MusicAssetManager;
import dev.mrturtle.analog.block.TransmitterBlockEntity;
import dev.mrturtle.analog.config.ConfigManager;
import dev.mrturtle.analog.util.RadioAudioUtil;
import dev.mrturtle.analog.util.RadioUtil;
import dev.mrturtle.analog.world.GlobalRadioState;
import java.util.HashMap;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1301;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_6880;
import net.minecraft.class_9793;
import net.minecraft.class_9794;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_9794.class})
public abstract class JukeboxManagerMixin
implements JukeboxManagerAccessor {
    @Shadow
    @Final
    private class_2338 field_52035;
    @Shadow
    private long field_52033;
    @Unique
    private short[] cachedAudio = null;

    @Shadow
    public abstract boolean method_60754();

    @Inject(method={"startPlaying"}, at={@At(value="TAIL")})
    public void startPlaying(class_1936 world, class_6880<class_9793> song, CallbackInfo ci) {
        if (world.method_8608()) {
            return;
        }
        if (!MusicAssetManager.recordsLoaded) {
            class_1657 closestPlayer = world.method_8604((double)this.field_52035.method_10263(), (double)this.field_52035.method_10264(), (double)this.field_52035.method_10260(), 8.0, class_1301.field_6155);
            if (closestPlayer != null) {
                closestPlayer.method_7353((class_2561)class_2561.method_43471((String)"gui.analog.jukebox.asset_failure"), true);
            }
            return;
        }
        class_2960 songId = ((class_3414)((class_9793)song.comp_349()).comp_2835().comp_349()).method_14833();
        if (!songId.method_12836().equals("minecraft")) {
            return;
        }
        this.cachedAudio = null;
        String songPath = "analog/records/%s.ogg".formatted(songId.method_12832().replace("music_disc.", ""));
        try {
            this.cachedAudio = RadioAudioUtil.getAudioData(FabricLoader.getInstance().getConfigDir().resolve(songPath));
        }
        catch (Exception e) {
            Analog.LOGGER.error("Failed to load music disc for playback from path %s".formatted(songPath));
            e.printStackTrace();
        }
        this.analog$makeNearbyTransmittersPlay(world, true);
    }

    @Inject(method={"stopPlaying"}, at={@At(value="TAIL")})
    public void stopPlaying(class_1936 world, class_2680 state, CallbackInfo ci) {
        if (world.method_8608()) {
            return;
        }
        this.analog$makeNearbyTransmittersStop(world);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void tick(class_1936 world, class_2680 state, CallbackInfo ci) {
        if (!this.method_60754()) {
            return;
        }
        this.analog$makeNearbyTransmittersPlay(world, false);
    }

    @Override
    @Unique
    public void analog$makeNearbyTransmittersStop(class_1936 world) {
        GlobalRadioState globalRadioState = RadioUtil.getGlobalRadioState((class_3218)world);
        class_243 center = this.field_52035.method_46558();
        for (class_2338 transmitterPos : globalRadioState.getTransmitters()) {
            TransmitterBlockEntity transmitter;
            if (center.method_1022(transmitterPos.method_46558()) > (double)ConfigManager.config.radioListeningDistance || (transmitter = (TransmitterBlockEntity)world.method_8321(transmitterPos)) == null || !transmitter.enabled) continue;
            globalRadioState.audioManager.stopTransmitter(transmitterPos, this.field_52035.method_10062());
        }
    }

    @Override
    @Unique
    public void analog$makeNearbyTransmittersPlay(class_1936 world, boolean overrideExisting) {
        if (this.cachedAudio == null) {
            return;
        }
        GlobalRadioState globalRadioState = RadioUtil.getGlobalRadioState((class_3218)world);
        class_243 center = this.field_52035.method_46558();
        for (class_2338 transmitterPos : globalRadioState.getTransmitters()) {
            HashMap audioInstances;
            TransmitterBlockEntity transmitter;
            if (center.method_1022(transmitterPos.method_46558()) > (double)ConfigManager.config.radioListeningDistance || (transmitter = (TransmitterBlockEntity)world.method_8321(transmitterPos)) == null || !transmitter.enabled || (audioInstances = globalRadioState.audioManager.transmitterAudioInstances.computeIfAbsent(transmitterPos, playerEntity -> new HashMap())).containsKey(this.field_52035.method_10062()) && !overrideExisting) continue;
            if (audioInstances.containsKey(this.field_52035.method_10062())) {
                globalRadioState.audioManager.stopTransmitter(transmitterPos, this.field_52035);
            }
            int startIndex = (int)(2400L * this.field_52033);
            RadioAudioInstance audioInstance = RadioUtil.transmitDataOnChannel(AnalogPlugin.API, (class_3218)world, this.cachedAudio, transmitter.channel);
            audioInstance.setCurrentIndex(startIndex);
            audioInstances.put(this.field_52035.method_10062(), audioInstance);
        }
    }

    @Override
    @Unique
    public void analog$setCachedAudio(short[] audioData) {
        this.cachedAudio = audioData;
    }
}

