/*
 * Decompiled with CFR 0.152.
 */
package dev.mrturtle.analog.world;

import dev.mrturtle.analog.audio.RadioAudioManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_18;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_7225;

public class GlobalRadioState
extends class_18 {
    private final ArrayList<class_2338> transmitterList;
    private final ArrayList<class_2338> receiverList;
    public final RadioAudioManager audioManager = new RadioAudioManager();

    public GlobalRadioState() {
        this.transmitterList = new ArrayList();
        this.receiverList = new ArrayList();
    }

    public void createTransmitter(class_2338 pos) {
        this.transmitterList.add(pos);
        this.method_80();
    }

    public void removeTransmitter(class_2338 pos) {
        this.transmitterList.remove(pos);
        this.audioManager.stopTransmitter(pos);
        this.method_80();
    }

    public void createReceiver(class_2338 pos) {
        this.receiverList.add(pos);
        this.method_80();
    }

    public void removeReceiver(class_2338 pos) {
        this.receiverList.remove(pos);
        this.audioManager.receiverTurnedOff(pos);
        this.method_80();
    }

    public List<class_2338> getTransmitters() {
        return this.transmitterList;
    }

    public List<class_2338> getReceivers() {
        return this.receiverList;
    }

    public static GlobalRadioState fromNbt(class_2487 tag) {
        GlobalRadioState state = new GlobalRadioState();
        class_2499 transmitterList = tag.method_10554("globalTransmitters", 10);
        for (class_2520 element : transmitterList) {
            class_2487 compound = (class_2487)element;
            Optional pos = class_2512.method_10691((class_2487)compound, (String)"pos");
            if (!pos.isPresent()) continue;
            state.transmitterList.add((class_2338)pos.get());
        }
        class_2499 receiverList = tag.method_10554("globalReceivers", 10);
        for (class_2520 element : receiverList) {
            class_2487 compound = (class_2487)element;
            Optional pos = class_2512.method_10691((class_2487)compound, (String)"pos");
            if (!pos.isPresent()) continue;
            state.receiverList.add((class_2338)pos.get());
        }
        return state;
    }

    public class_2487 method_75(class_2487 tag, class_7225.class_7874 registryLookup) {
        class_2499 transmitterList = new class_2499();
        for (class_2338 pos : this.transmitterList) {
            class_2487 compound = new class_2487();
            compound.method_10566("pos", class_2512.method_10692((class_2338)pos));
            transmitterList.add((Object)compound);
        }
        tag.method_10566("globalTransmitters", (class_2520)transmitterList);
        class_2499 receiverList = new class_2499();
        for (class_2338 pos : this.receiverList) {
            class_2487 compound = new class_2487();
            compound.method_10566("pos", class_2512.method_10692((class_2338)pos));
            receiverList.add((Object)compound);
        }
        tag.method_10566("globalReceivers", (class_2520)receiverList);
        return tag;
    }
}

