/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.common.api.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.darkhax.bookshelf.common.api.PhysicalSide;
import net.darkhax.bookshelf.common.api.annotation.OnlyFor;
import net.darkhax.bookshelf.common.api.service.Services;
import net.darkhax.bookshelf.common.api.text.unit.Units;
import net.darkhax.bookshelf.common.mixin.access.client.AccessorFontManager;
import net.darkhax.bookshelf.common.mixin.access.client.AccessorMinecraft;
import net.darkhax.bookshelf.common.mixin.access.entity.AccessorEntity;
import net.minecraft.class_1074;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3544;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_6862;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class TextHelper {
    public static class_5250 fromResourceLocation(@Nullable String prefix, @Nullable String suffix, class_2960 location, Object ... args) {
        StringBuilder builder = new StringBuilder();
        if (prefix != null) {
            builder.append(prefix).append(".");
        }
        builder.append(location.method_12836()).append(".").append(location.method_12832());
        if (suffix != null) {
            builder.append(".").append(suffix);
        }
        return class_2561.method_43469((String)builder.toString(), (Object[])args);
    }

    public static class_5250 formatDuration(int ticks) {
        return TextHelper.formatDuration(ticks, true, 1.0f);
    }

    public static class_5250 formatDuration(int ticks, class_1937 level) {
        return TextHelper.formatDuration(ticks, true, level);
    }

    public static class_5250 formatDuration(int ticks, boolean includeHover, class_1937 level) {
        return TextHelper.formatDuration(ticks, includeHover, level.method_54719().method_54748());
    }

    public static class_5250 formatDuration(int ticks, boolean showTicksOnHover, float tickRate) {
        class_5250 timeText = class_2561.method_43470((String)class_3544.method_15439((int)ticks, (float)tickRate));
        if (showTicksOnHover) {
            timeText = Units.TICK.format(ticks);
        }
        return timeText;
    }

    public static class_5250 withHover(class_2561 base, class_2561 hover) {
        return TextHelper.withHover(base, new class_2568(class_2568.class_5247.field_24342, (Object)hover));
    }

    public static class_5250 withHover(class_2561 base, class_1297 hover) {
        return TextHelper.withHover(base, TextHelper.hoverEvent(hover));
    }

    public static class_5250 withHover(class_2561 base, class_1799 hover) {
        return TextHelper.withHover(base, new class_2568(class_2568.class_5247.field_24343, (Object)new class_2568.class_5249(hover)));
    }

    public static class_5250 withHover(class_2561 base, class_2568 hover) {
        return TextHelper.mutable(base).method_27694(style -> style.method_10949(hover));
    }

    public static class_2568 hoverEvent(class_1297 entity) {
        if (entity instanceof AccessorEntity) {
            AccessorEntity access = (AccessorEntity)entity;
            return access.bookshelf$createHoverEvent();
        }
        return new class_2568(class_2568.class_5247.field_24344, (Object)new class_2568.class_5248(entity.method_5864(), entity.method_5667(), entity.method_5477()));
    }

    public static class_5250 mutable(class_2561 component) {
        class_5250 mutable;
        return component instanceof class_5250 ? (mutable = (class_5250)component) : component.method_27661();
    }

    public static class_2561 applyFont(class_2561 text, class_2960 font) {
        if (text == class_5244.field_39003) {
            return text;
        }
        class_5250 modified = TextHelper.mutable(text);
        modified.method_27694(style -> style.method_27704(font));
        modified.method_10855().forEach(sib -> TextHelper.applyFont(sib, font));
        return modified;
    }

    @Nullable
    @OnlyFor(value=PhysicalSide.CLIENT)
    public static class_5250 lookupTranslationWithAlias(class_2960 id, String ... keys) {
        for (String key : keys) {
            class_5250 lookupResult = TextHelper.lookupTranslation(key.formatted(id.method_12836(), id.method_12832()), new Object[0]);
            if (lookupResult == null) continue;
            return lookupResult;
        }
        return null;
    }

    @Nullable
    @OnlyFor(value=PhysicalSide.CLIENT)
    public static class_5250 lookupTranslationWithAlias(String[] keys, Object ... params) {
        for (String key : keys) {
            class_5250 lookupResult = TextHelper.lookupTranslation(key, params);
            if (lookupResult == null) continue;
            return lookupResult;
        }
        return null;
    }

    @Nullable
    @OnlyFor(value=PhysicalSide.CLIENT)
    public static class_5250 lookupTranslation(String key, Object ... args) {
        return TextHelper.lookupTranslation(key, (String s, Object[] o) -> null, args);
    }

    @Nullable
    @OnlyFor(value=PhysicalSide.CLIENT)
    public static class_5250 lookupTranslation(String key, class_5250 fallback, Object ... args) {
        return TextHelper.lookupTranslation(key, (String s, Object[] o) -> fallback, args);
    }

    @Nullable
    @OnlyFor(value=PhysicalSide.CLIENT)
    public static class_5250 lookupTranslation(String key, @Nullable BiFunction<String, Object[], class_5250> fallback, Object ... args) {
        if (!Services.PLATFORM.isPhysicalClient()) {
            throw new IllegalStateException("Text can not be translated on the server.");
        }
        return class_1074.method_4663((String)key) ? class_2561.method_43469((String)key, (Object[])args) : (fallback != null ? fallback.apply(key, args) : null);
    }

    public static class_5250 copyText(String text) {
        return TextHelper.setCopyText(class_2561.method_43470((String)text), text);
    }

    public static class_5250 setCopyText(class_5250 component, String copy) {
        return component.method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_21462, copy)));
    }

    public static class_5250 join(class_2561 separator, class_2561 ... toJoin) {
        return TextHelper.join(separator, Arrays.stream(toJoin).iterator());
    }

    public static class_5250 join(class_2561 separator, Collection<class_2561> toJoin) {
        return TextHelper.join(separator, toJoin.iterator());
    }

    public static class_5250 join(class_2561 separator, Iterator<class_2561> toJoin) {
        class_5250 joined = class_2561.method_43470((String)"");
        while (toJoin.hasNext()) {
            joined.method_10852(toJoin.next());
            if (!toJoin.hasNext()) continue;
            joined.method_10852(separator);
        }
        return joined;
    }

    public static Set<String> getPossibleMatches(String input, Iterable<String> candidates) {
        return TextHelper.getPossibleMatches(input, candidates, Integer.MAX_VALUE);
    }

    public static Set<String> getPossibleMatches(String input, Iterable<String> candidates, int threshold) {
        HashSet<String> bestMatches = new HashSet<String>();
        int distance = threshold;
        for (String candidate : candidates) {
            int currentDistance = StringUtils.getLevenshteinDistance((CharSequence)input, (CharSequence)candidate);
            if (currentDistance < distance) {
                distance = currentDistance;
                bestMatches.clear();
                bestMatches.add(candidate);
                continue;
            }
            if (currentDistance != distance) continue;
            bestMatches.add(candidate);
        }
        return bestMatches;
    }

    public static <T> String formatCollection(Collection<T> collection) {
        return TextHelper.formatCollection(collection, entry -> "\"" + entry.toString() + "\"", ", ");
    }

    public static <T> String formatCollection(Collection<T> collection, Function<T, String> formatter, String delimiter) {
        return collection.size() == 1 ? formatter.apply(collection.stream().findFirst().get()) : collection.stream().map(formatter).collect(Collectors.joining(delimiter));
    }

    @OnlyFor(value=PhysicalSide.CLIENT)
    public static Set<class_2960> getRegisteredFonts() {
        if (!Services.PLATFORM.isPhysicalClient()) {
            return Collections.emptySet();
        }
        return ((AccessorFontManager)((AccessorMinecraft)class_310.method_1551()).bookshelf$getFontManager()).bookshelf$getFonts().keySet();
    }

    public static String getTagName(class_6862<?> tag) {
        StringBuilder builder = new StringBuilder();
        builder.append("tag.");
        class_2960 regId = tag.comp_326().method_29177();
        class_2960 tagId = tag.comp_327();
        if (!regId.method_12836().equals("minecraft")) {
            builder.append(regId.method_12836()).append(".");
        }
        builder.append(regId.method_12832().replace("/", ".")).append(".").append(tagId.method_12836()).append(".").append(tagId.method_12832().replace("/", ".").replace(":", "."));
        return builder.toString();
    }
}

