/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.common.impl.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Locale;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicBoolean;
import net.darkhax.bookshelf.common.api.commands.IEnumCommand;
import net.darkhax.bookshelf.common.api.commands.PermissionLevel;
import net.darkhax.bookshelf.common.api.util.CommandHelper;
import net.darkhax.bookshelf.common.api.util.TextHelper;
import net.darkhax.bookshelf.common.impl.Constants;
import net.minecraft.class_1074;
import net.minecraft.class_2168;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7157;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public enum DebugCommands implements IEnumCommand
{
    MISSING_TAG_NAMES(DebugCommands::findMissingTagNames),
    MISSING_BLOCK_DROPS(DebugCommands::findMissingBlockDrops);

    private final DebugTask debugTask;

    private static void findMissingTagNames(MinecraftServer server, StringJoiner out) {
        server.method_30611().method_40311().forEach(entry -> {
            AtomicBoolean hasLogged = new AtomicBoolean(false);
            entry.comp_351().method_40273().forEach(tag -> {
                if (!tag.comp_327().method_12836().equals("minecraft") && !class_1074.method_4663((String)TextHelper.getTagName(tag))) {
                    if (!hasLogged.get()) {
                        hasLogged.set(true);
                        out.add("## " + String.valueOf(entry.comp_350().method_29177()));
                    }
                    out.add("\"" + TextHelper.getTagName(tag) + "\": \"\",");
                }
            });
            if (hasLogged.get()) {
                out.add("");
            }
        });
    }

    private static void findMissingBlockDrops(MinecraftServer server, StringJoiner out) {
        class_7871 lootTables = (class_7871)server.method_58576().method_58294().method_46750(class_7924.field_50079).orElseThrow();
        for (class_2248 block : class_7923.field_41175) {
            Optional result = lootTables.method_46746(block.method_26162());
            if (!result.isEmpty()) continue;
            class_2960 id = block.method_26162().method_29177();
            out.add(String.valueOf(class_7923.field_41175.method_10221((Object)block)) + " - " + String.valueOf(id) + " - data/" + id.method_12836() + "/loot_table/" + id.method_12832());
        }
    }

    public static LiteralArgumentBuilder<class_2168> build(class_7157 context) {
        return CommandHelper.buildFromEnum("debug", DebugCommands.class);
    }

    private DebugCommands(DebugTask task) {
        this.debugTask = task;
    }

    @Override
    public String getCommandName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public int run(CommandContext<class_2168> context) throws CommandSyntaxException {
        StringJoiner joiner = new StringJoiner(System.lineSeparator());
        this.debugTask.getDebugOutput(((class_2168)context.getSource()).method_9211(), joiner);
        Constants.LOG.warn(joiner.toString());
        if (joiner.toString().isBlank()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"commands.bookshelf.debug.no_info"));
            return 0;
        }
        ((class_2168)context.getSource()).method_9226(() -> TextHelper.setCopyText(class_2561.method_43471((String)"commands.bookshelf.debug.yes_info"), joiner.toString()), false);
        return 1;
    }

    @Override
    public PermissionLevel requiredPermissionLevel() {
        return PermissionLevel.OWNER;
    }

    @FunctionalInterface
    public static interface DebugTask {
        public void getDebugOutput(MinecraftServer var1, StringJoiner var2);
    }
}

