/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.book.component;

import cn.leolezury.eternalstarlight.common.client.book.BookAccess;
import cn.leolezury.eternalstarlight.common.client.book.component.BookComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

@Environment(value=EnvType.CLIENT)
public class TextBookComponent
extends BookComponent {
    private final class_2561 text;
    private final boolean mustEndAtEvenPage;
    private final List<class_5481> cachedComponents = new ArrayList<class_5481>();

    public TextBookComponent(class_2561 text, int width, int height) {
        this(text, true, width, height);
    }

    public TextBookComponent(class_2561 text, boolean mustEndAtEvenPage, int width, int height) {
        super(width, height);
        this.text = text;
        this.mustEndAtEvenPage = mustEndAtEvenPage;
    }

    @Override
    public int getPageCount(int pagesBefore, class_327 font) {
        int pageCount;
        if (this.cachedComponents.isEmpty()) {
            this.cachedComponents.addAll(font.method_1728((class_5348)this.text, this.width));
        }
        Objects.requireNonNull(font);
        int linesPerPage = this.height / 9;
        int n = pageCount = this.cachedComponents.size() % linesPerPage == 0 ? this.cachedComponents.size() / linesPerPage : this.cachedComponents.size() / linesPerPage + 1;
        return this.mustEndAtEvenPage ? (pageCount % 2 == 0 ? pageCount + pagesBefore % 2 : pageCount + (1 - pagesBefore % 2)) : pageCount;
    }

    @Override
    public void render(BookAccess access, class_332 graphics, class_327 font, int x, int y, int mouseX, int mouseY) {
        Objects.requireNonNull(font);
        int linesPerPage = this.height / 9;
        for (int i = access.getRelativePage() * linesPerPage; i < Math.min((access.getRelativePage() + 1) * linesPerPage, this.cachedComponents.size()); ++i) {
            int n = i - access.getRelativePage() * linesPerPage;
            Objects.requireNonNull(font);
            int textY = n * 9;
            graphics.method_51430(font, this.cachedComponents.get(i), x, y + textY, 0, false);
        }
    }

    @Override
    public void tick(BookAccess access, class_327 font, int x, int y, int mouseX, int mouseY) {
    }

    @Override
    public void singleTick(BookAccess access, class_327 font, int x, int y, int mouseX, int mouseY) {
    }

    @Override
    public void onClick(BookAccess access, class_327 font, int x, int y, int mouseX, int mouseY) {
    }
}

