/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.helper;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.ClientWeatherState;
import cn.leolezury.eternalstarlight.common.client.book.Book;
import cn.leolezury.eternalstarlight.common.client.book.component.BookComponentDefinition;
import cn.leolezury.eternalstarlight.common.client.book.component.DisplayBookComponent;
import cn.leolezury.eternalstarlight.common.client.book.component.IndexBookComponent;
import cn.leolezury.eternalstarlight.common.client.book.component.TextBookComponent;
import cn.leolezury.eternalstarlight.common.client.gui.screen.BookScreen;
import cn.leolezury.eternalstarlight.common.client.gui.screen.CrestSelectionScreen;
import cn.leolezury.eternalstarlight.common.client.handler.ClientHandlers;
import cn.leolezury.eternalstarlight.common.client.helper.ClientHelper;
import cn.leolezury.eternalstarlight.common.client.particle.advanced.AdvancedParticleOptions;
import cn.leolezury.eternalstarlight.common.entity.projectile.SoulitSpectator;
import cn.leolezury.eternalstarlight.common.network.ClientDismountPacket;
import cn.leolezury.eternalstarlight.common.network.ClientMountPacket;
import cn.leolezury.eternalstarlight.common.network.NoParametersPacket;
import cn.leolezury.eternalstarlight.common.network.OpenCrestGuiPacket;
import cn.leolezury.eternalstarlight.common.network.OpenStarlightStoryPacket;
import cn.leolezury.eternalstarlight.common.network.ParticlePacket;
import cn.leolezury.eternalstarlight.common.network.UpdateCameraPacket;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.registry.ESParticles;
import cn.leolezury.eternalstarlight.common.spell.ManaType;
import cn.leolezury.eternalstarlight.common.util.Color;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import cn.leolezury.eternalstarlight.common.util.Easing;
import cn.leolezury.eternalstarlight.common.util.SmoothSegmentedValue;
import com.google.common.collect.Lists;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_2396;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_638;
import net.minecraft.class_7923;
import org.joml.Quaternionf;

@Environment(value=EnvType.CLIENT)
public class ClientSideHelper
implements ClientHelper {
    @Override
    public void handleS2cNoParam(NoParametersPacket packet) {
        switch (packet.id()) {
            case "cancel_weather": {
                ClientWeatherState.weather = null;
            }
        }
    }

    @Override
    public void handleParticlePacket(ParticlePacket packet) {
        class_638 clientLevel = class_310.method_1551().field_1687;
        if (clientLevel != null) {
            clientLevel.method_8466(packet.particle(), true, packet.x(), packet.y(), packet.z(), packet.dx(), packet.dy(), packet.dz());
        }
    }

    @Override
    public void handleOpenCrestGui(OpenCrestGuiPacket packet) {
        if (packet.ownedCrests().crests().isEmpty()) {
            if (class_310.method_1551().field_1724 != null) {
                class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43471((String)"message.eternal_starlight.no_crest"), true);
            }
        } else {
            class_310.method_1551().method_1507((class_437)new CrestSelectionScreen(packet.crests().crests(), packet.ownedCrests().crests()));
        }
    }

    @Override
    public void handleUpdateCamera(UpdateCameraPacket packet) {
        class_1297 camera;
        if (packet.cameraId() == -1) {
            ClientHandlers.resetCameraIn = 0;
        } else if (class_310.method_1551().field_1687 != null && !(class_310.method_1551().method_1560() instanceof SoulitSpectator) && (camera = class_310.method_1551().field_1687.method_8469(packet.cameraId())) != null) {
            ClientHandlers.resetCameraIn = 260;
            class_310.method_1551().field_1690.field_1842 = true;
            class_310.method_1551().method_1504(camera);
        }
    }

    @Override
    public void handleClientMount(ClientMountPacket packet) {
        if (class_310.method_1551().field_1687 != null) {
            class_1297 rider = class_310.method_1551().field_1687.method_8469(packet.riderId());
            class_1297 vehicle = class_310.method_1551().field_1687.method_8469(packet.vehicleId());
            if (rider != null && vehicle != null) {
                rider.method_5873(vehicle, true);
            }
        }
    }

    @Override
    public void handleClientDismount(ClientDismountPacket packet) {
        class_1297 rider;
        if (class_310.method_1551().field_1687 != null && (rider = class_310.method_1551().field_1687.method_8469(packet.riderId())) != null) {
            rider.method_5848();
        }
    }

    private class_2561 translatedBookText(String id) {
        return class_2561.method_43471((String)("book.eternal_starlight." + id));
    }

    @Override
    public void handleOpenStarlightStory(OpenStarlightStoryPacket packet) {
        DisplayBookComponent title = new DisplayBookComponent(105, 130).imageDisplay(EternalStarlight.id("textures/gui/screen/book/separator.png"), 4, 92, 96, 11).textDisplay((class_2561)class_2561.method_43471((String)ESItems.BOOK.get().method_7876()), 52, 115, 1.2f);
        TextBookComponent preface = new TextBookComponent(this.translatedBookText("preface"), false, 105, 130);
        IndexBookComponent index = new IndexBookComponent(this.translatedBookText("index"), List.of(new IndexBookComponent.IndexItem((class_2561)class_2561.method_43470((String)"\u2022").method_10852(this.translatedBookText("main_story_title")), EternalStarlight.id("main_story"), packet.unlocked().contains(EternalStarlight.id("enter_starlight"))), new IndexBookComponent.IndexItem((class_2561)class_2561.method_43470((String)"\u2022").method_10852((class_2561)class_2561.method_43471((String)ESEntities.STARLIGHT_GOLEM.get().method_5882())), EternalStarlight.id("starlight_golem_display"), packet.unlocked().contains(EternalStarlight.id("enter_starlight"))), new IndexBookComponent.IndexItem((class_2561)class_2561.method_43470((String)"\u2022").method_10852((class_2561)class_2561.method_43471((String)ESEntities.LUNAR_MONSTROSITY.get().method_5882())), EternalStarlight.id("lunar_monstrosity_display"), packet.unlocked().contains(EternalStarlight.id("enter_starlight"))), new IndexBookComponent.IndexItem((class_2561)class_2561.method_43470((String)"\u2022").method_10852((class_2561)class_2561.method_43471((String)ESEntities.TWILIGHT_GAZE.get().method_5882())), EternalStarlight.id("twilight_gaze_display"), packet.unlocked().contains(EternalStarlight.id("twilight_gaze"))), new IndexBookComponent.IndexItem((class_2561)class_2561.method_43470((String)"\u2022").method_10852((class_2561)class_2561.method_43471((String)ESEntities.SHIMMER_LACEWING.get().method_5882())), EternalStarlight.id("shimmer_lacewing_display"), packet.unlocked().contains(EternalStarlight.id("shimmer_lacewing")))), 105, 130);
        TextBookComponent mainStory = new TextBookComponent(this.translatedBookText("main_story"), 105, 130);
        DisplayBookComponent golemDisplay = new DisplayBookComponent(105, 130).entityDisplay(ESEntities.STARLIGHT_GOLEM.get(), 52, 75, -25.0f, 210.0f, 20.0f, new Quaternionf().rotationXYZ(0.43633232f, 0.0f, (float)Math.PI)).imageDisplay(EternalStarlight.id("textures/gui/screen/book/frame.png"), 18, 20, 68, 68).imageDisplay(EternalStarlight.id("textures/gui/screen/book/separator.png"), 4, 92, 96, 11).textDisplay((class_2561)class_2561.method_43471((String)ESEntities.STARLIGHT_GOLEM.get().method_5882()), 52, 115, 1.2f);
        DisplayBookComponent golemLocator = new DisplayBookComponent(105, 130).textDisplay(this.translatedBookText("locators"), 52, 28, 1.0f).imageDisplay(EternalStarlight.id("textures/gui/screen/book/separator.png"), 4, 45, 96, 11).imageDisplay(EternalStarlight.id("textures/gui/screen/book/slot.png"), 36, 74, 32, 32).itemTagDisplay(ESTags.Items.GOLEM_FORGE_LOCATORS, 44, 82);
        TextBookComponent golem = new TextBookComponent(this.translatedBookText("starlight_golem"), 105, 130);
        TextBookComponent golemSeen = new TextBookComponent(this.translatedBookText("starlight_golem_seen"), 105, 130);
        DisplayBookComponent lunarMonstrosityDisplay = new DisplayBookComponent(105, 130).entityDisplay(ESEntities.LUNAR_MONSTROSITY.get(), 52, 80, -25.0f, 210.0f, 16.0f, new Quaternionf().rotationXYZ(0.43633232f, 0.0f, (float)Math.PI)).imageDisplay(EternalStarlight.id("textures/gui/screen/book/frame.png"), 18, 20, 68, 68).imageDisplay(EternalStarlight.id("textures/gui/screen/book/separator.png"), 4, 92, 96, 11).textDisplay((class_2561)class_2561.method_43471((String)ESEntities.LUNAR_MONSTROSITY.get().method_5882()), 52, 115, 1.1f);
        DisplayBookComponent lunarMonstrosityLocator = new DisplayBookComponent(105, 130).textDisplay(this.translatedBookText("locators"), 52, 28, 1.0f).imageDisplay(EternalStarlight.id("textures/gui/screen/book/separator.png"), 4, 45, 96, 11).imageDisplay(EternalStarlight.id("textures/gui/screen/book/slot.png"), 36, 74, 32, 32).itemTagDisplay(ESTags.Items.CURSED_GARDEN_LOCATORS, 44, 82);
        TextBookComponent lunarMonstrosity = new TextBookComponent(this.translatedBookText("lunar_monstrosity"), 105, 130);
        TextBookComponent lunarMonstrositySeen = new TextBookComponent(this.translatedBookText("lunar_monstrosity_seen"), 105, 130);
        DisplayBookComponent twilightGazeDisplay = new DisplayBookComponent(105, 130).entityDisplay(ESEntities.TWILIGHT_GAZE.get(), 52, 60, 0.0f, 210.0f, 25.0f, new Quaternionf().rotationXYZ(0.43633232f, 0.0f, (float)Math.PI)).imageDisplay(EternalStarlight.id("textures/gui/screen/book/frame.png"), 18, 20, 68, 68).imageDisplay(EternalStarlight.id("textures/gui/screen/book/separator.png"), 4, 92, 96, 11).textDisplay((class_2561)class_2561.method_43471((String)ESEntities.TWILIGHT_GAZE.get().method_5882()), 52, 115, 1.2f);
        TextBookComponent twilightGaze = new TextBookComponent(this.translatedBookText("twilight_gaze"), 105, 130);
        DisplayBookComponent shimmerLacewingDisplay = new DisplayBookComponent(105, 130).entityDisplay(ESEntities.SHIMMER_LACEWING.get(), 52, 65, 0.0f, 210.0f, 25.0f, new Quaternionf().rotationXYZ(0.43633232f, 0.0f, (float)Math.PI)).imageDisplay(EternalStarlight.id("textures/gui/screen/book/frame.png"), 18, 20, 68, 68).imageDisplay(EternalStarlight.id("textures/gui/screen/book/separator.png"), 4, 92, 96, 11).textDisplay((class_2561)class_2561.method_43471((String)ESEntities.SHIMMER_LACEWING.get().method_5882()), 52, 115, 1.2f);
        TextBookComponent shimmerLacewing = new TextBookComponent(this.translatedBookText("shimmer_lacewing"), 105, 130);
        Book book = new Book(Lists.newArrayList((Object[])new BookComponentDefinition[]{new BookComponentDefinition(title, EternalStarlight.id("title"), 11, 6, 5, 6), new BookComponentDefinition(preface, EternalStarlight.id("preface"), 11, 6, 5, 6), new BookComponentDefinition(index, EternalStarlight.id("index"), 11, 6, 5, 6), new BookComponentDefinition(mainStory, EternalStarlight.id("main_story"), 11, 6, 5, 6, packet.unlocked().contains(EternalStarlight.id("enter_starlight"))), new BookComponentDefinition(golemDisplay, EternalStarlight.id("starlight_golem_display"), 11, 6, 5, 6, packet.unlocked().contains(EternalStarlight.id("enter_starlight"))), new BookComponentDefinition(golemLocator, EternalStarlight.id("starlight_golem_locator"), 11, 6, 5, 6, packet.unlocked().contains(EternalStarlight.id("enter_starlight"))), new BookComponentDefinition(golem, EternalStarlight.id("starlight_golem"), 11, 6, 5, 6, packet.unlocked().contains(EternalStarlight.id("enter_starlight"))), new BookComponentDefinition(golemSeen, EternalStarlight.id("starlight_golem_seen"), 11, 6, 5, 6, packet.unlocked().contains(EternalStarlight.id("enter_starlight")) && packet.unlocked().contains(EternalStarlight.id("starlight_golem_seen"))), new BookComponentDefinition(lunarMonstrosityDisplay, EternalStarlight.id("lunar_monstrosity_display"), 11, 6, 5, 6, packet.unlocked().contains(EternalStarlight.id("enter_starlight"))), new BookComponentDefinition(lunarMonstrosityLocator, EternalStarlight.id("lunar_monstrosity_locator"), 11, 6, 5, 6, packet.unlocked().contains(EternalStarlight.id("enter_starlight"))), new BookComponentDefinition(lunarMonstrosity, EternalStarlight.id("lunar_monstrosity"), 11, 6, 5, 6, packet.unlocked().contains(EternalStarlight.id("enter_starlight"))), new BookComponentDefinition(lunarMonstrositySeen, EternalStarlight.id("lunar_monstrosity_seen"), 11, 6, 5, 6, packet.unlocked().contains(EternalStarlight.id("enter_starlight")) && packet.unlocked().contains(EternalStarlight.id("lunar_monstrosity_seen"))), new BookComponentDefinition(twilightGazeDisplay, EternalStarlight.id("twilight_gaze_display"), 11, 6, 5, 6, packet.unlocked().contains(EternalStarlight.id("twilight_gaze"))), new BookComponentDefinition(twilightGaze, EternalStarlight.id("twilight_gaze"), 11, 6, 5, 6, packet.unlocked().contains(EternalStarlight.id("twilight_gaze"))), new BookComponentDefinition(shimmerLacewingDisplay, EternalStarlight.id("shimmer_lacewing_display"), 11, 6, 5, 6, packet.unlocked().contains(EternalStarlight.id("shimmer_lacewing"))), new BookComponentDefinition(shimmerLacewing, EternalStarlight.id("shimmer_lacewing"), 11, 6, 5, 6, packet.unlocked().contains(EternalStarlight.id("shimmer_lacewing")))}), 240, 165, 18, 7, 12, 27, EternalStarlight.id("textures/gui/screen/book/book.png"), EternalStarlight.id("textures/gui/screen/book/book_cover.png"), EternalStarlight.id("textures/gui/screen/book/book_back_cover.png"), EternalStarlight.id("textures/gui/screen/book/book_flip_left.png"), EternalStarlight.id("textures/gui/screen/book/book_flip_right.png"));
        class_310.method_1551().method_1507((class_437)new BookScreen(book));
    }

    @Override
    public void spawnStellarRackParticles(class_243 center) {
        int i;
        if ((double)AdvancedParticleOptions.RANDOM.method_43057() < 0.3) {
            if (AdvancedParticleOptions.RANDOM.method_43056()) {
                float size = (float)(1.0 + ((double)AdvancedParticleOptions.RANDOM.method_43057() - 0.5) * 0.4);
                new AdvancedParticleOptions().speed(SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.1f, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.1f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_BACK, 0.1f, 0.3f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.1f, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.1f, 1.0f)).spinSpeed(SmoothSegmentedValue.of(Easing.IN_OUT_QUAD, (float)((12.0 + ((double)AdvancedParticleOptions.RANDOM.method_43057() - 0.5) * 10.0) * 0.01745329238474369), (float)((18.0 + ((double)AdvancedParticleOptions.RANDOM.method_43057() - 0.5) * 10.0) * 0.01745329238474369), 1.0f)).quadSize(SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.0f, size, 0.4f).add(Easing.IN_OUT_BOUNCE, size, 0.0f, 0.6f)).lifetime((int)(40.0 + ((double)AdvancedParticleOptions.RANDOM.method_43057() - 0.5) * 20.0)).color(SmoothSegmentedValue.of(Easing.IN_OUT_QUART, 0.11764707f, 0.17764707f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.2682353f, 0.3f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.29882354f, 0.29411766f, 1.0f), SmoothSegmentedValue.of(Easing.OUT_QUINT, 0.0f, 1.0f, 0.7f).add(Easing.IN_OUT_QUAD, 1.0f, 0.0f, 0.3f)).defaultOperators().spawn(class_7923.field_41180.method_10221((Object)((class_2396)ESParticles.SHINE.get())), (float)center.field_1352, (float)center.field_1351, (float)center.field_1350);
            }
            for (i = 0; i < 4; ++i) {
                new AdvancedParticleOptions().speed(SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.1f, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.1f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_BACK, 0.1f, 0.3f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.1f, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.1f, 1.0f)).spinSpeed(SmoothSegmentedValue.of(Easing.IN_OUT_QUAD, 0.31415927f, 0.62831855f, 1.0f)).quadSize(SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.0f, 0.2f, 0.6f).add(Easing.IN_OUT_BOUNCE, 0.2f, 0.0f, 0.4f)).lifetime((int)(40.0 + ((double)AdvancedParticleOptions.RANDOM.method_43057() - 0.5) * 20.0)).color(SmoothSegmentedValue.of(Easing.IN_OUT_QUART, 0.29529414f, 0.23294118f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.14705883f, 0.14588235f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.0023529413f, 0.21176472f, 1.0f), SmoothSegmentedValue.of(Easing.OUT_QUINT, 0.0f, 1.0f, 0.7f).add(Easing.IN_OUT_QUAD, 1.0f, 0.0f, 0.3f)).defaultOperators().spawn(class_7923.field_41180.method_10221((Object)((class_2396)ESParticles.ADVANCED_GLOW.get())), (float)center.field_1352, (float)center.field_1351, (float)center.field_1350);
            }
        }
        for (i = 0; i < 5; ++i) {
            new AdvancedParticleOptions().speed(SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.03f, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.03f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.03f, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.03f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.03f, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.03f, 1.0f)).spinSpeed(SmoothSegmentedValue.of(Easing.IN_OUT_QUAD, 0.31415927f, 0.62831855f, 1.0f)).quadSize(SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.0f, 0.15f, 0.5f).add(Easing.IN_OUT_BOUNCE, 0.15f, 0.0f, 0.5f)).lifetime(12).color(SmoothSegmentedValue.of(Easing.IN_OUT_QUART, 0.29529414f, 0.23294118f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.14705883f, 0.14588235f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.0023529413f, 0.21176472f, 1.0f), SmoothSegmentedValue.of(Easing.OUT_QUINT, 0.0f, 1.0f, 0.7f).add(Easing.IN_OUT_QUAD, 1.0f, 0.0f, 0.3f)).defaultOperators().spawn(class_7923.field_41180.method_10221((Object)((class_2396)ESParticles.ADVANCED_GLOW.get())), (float)center.field_1352, (float)center.field_1351 + 0.45f, (float)center.field_1350);
        }
    }

    @Override
    public void spawnStellarRackItemParticles(class_243 center) {
        for (int i = 0; i < 5; ++i) {
            new AdvancedParticleOptions().speed(SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.03f, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.03f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.03f, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.03f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.03f, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.03f, 1.0f)).spinSpeed(SmoothSegmentedValue.of(Easing.IN_OUT_QUAD, 0.31415927f, 0.62831855f, 1.0f)).quadSize(SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.0f, 0.15f, 0.5f).add(Easing.IN_OUT_BOUNCE, 0.15f, 0.0f, 0.5f)).lifetime(12).color(SmoothSegmentedValue.of(Easing.IN_OUT_QUART, 0.29529414f, 0.23294118f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.14705883f, 0.14588235f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.0023529413f, 0.21176472f, 1.0f), SmoothSegmentedValue.of(Easing.OUT_QUINT, 0.0f, 1.0f, 0.7f).add(Easing.IN_OUT_QUAD, 1.0f, 0.0f, 0.3f)).defaultOperators().spawn(class_7923.field_41180.method_10221((Object)((class_2396)ESParticles.ADVANCED_GLOW.get())), (float)center.field_1352, (float)center.field_1351, (float)center.field_1350);
        }
    }

    @Override
    public void spawnManaCrystalItemParticles(ManaType type, class_243 center) {
        for (int i = 0; i < 5; ++i) {
            class_243 pos = center.method_49272(AdvancedParticleOptions.RANDOM, 0.5f);
            Color color = Color.rgb(type.getColor());
            new AdvancedParticleOptions().speed(SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.03f, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.03f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.03f, AdvancedParticleOptions.RANDOM.method_43057() * 0.015f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.03f, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.03f, 1.0f)).spinSpeed(SmoothSegmentedValue.of(Easing.IN_OUT_QUAD, 0.31415927f, 0.62831855f, 1.0f)).quadSize(SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.0f, 0.25f, 0.6f).add(Easing.IN_OUT_BOUNCE, 0.25f, 0.0f, 0.4f)).lifetime(12).color(SmoothSegmentedValue.of(Easing.IN_OUT_QUART, (float)color.r() * 0.4f / 255.0f, 0.3f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (float)color.g() * 0.4f / 255.0f, 0.3f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (float)color.b() * 0.4f / 255.0f, 0.3f, 1.0f), SmoothSegmentedValue.of(Easing.OUT_QUINT, 0.0f, 1.0f, 0.7f).add(Easing.IN_OUT_QUAD, 1.0f, 0.0f, 0.3f)).defaultOperators().spawn(class_7923.field_41180.method_10221((Object)((class_2396)ESParticles.ADVANCED_GLOW.get())), (float)pos.field_1352, (float)pos.field_1351, (float)pos.field_1350);
        }
    }
}

