/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.particle.advanced;

import cn.leolezury.eternalstarlight.common.client.ESRenderType;
import cn.leolezury.eternalstarlight.common.client.particle.advanced.AdvancedParticle;
import cn.leolezury.eternalstarlight.common.client.particle.advanced.ParticleOperator;
import cn.leolezury.eternalstarlight.common.client.particle.advanced.ParticleSpawner;
import cn.leolezury.eternalstarlight.common.util.Easing;
import cn.leolezury.eternalstarlight.common.util.SmoothSegmentedValue;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4002;
import net.minecraft.class_4066;
import net.minecraft.class_4184;
import net.minecraft.class_5819;
import net.minecraft.class_703;
import org.joml.Vector4f;

@Environment(value=EnvType.CLIENT)
public class AdvancedParticleOptions {
    public static final class_5819 RANDOM = class_5819.method_43047();
    private class_1921 renderType = ESRenderType.GLOW_PARTICLE;
    private SmoothSegmentedValue xSpeed = SmoothSegmentedValue.constant(0.0f);
    private SmoothSegmentedValue ySpeed = SmoothSegmentedValue.constant(0.0f);
    private SmoothSegmentedValue zSpeed = SmoothSegmentedValue.constant(0.0f);
    private SmoothSegmentedValue spinSpeed = SmoothSegmentedValue.constant(0.31415927f);
    private SmoothSegmentedValue quadSize = SmoothSegmentedValue.constant(1.0f);
    private int lifetime = 50;
    private SmoothSegmentedValue red = SmoothSegmentedValue.constant(1.0f);
    private SmoothSegmentedValue green = SmoothSegmentedValue.constant(1.0f);
    private SmoothSegmentedValue blue = SmoothSegmentedValue.constant(1.0f);
    private SmoothSegmentedValue alpha = SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.0f, 1.0f, 0.5f).add(Easing.IN_OUT_SINE, 1.0f, 0.0f, 0.5f);
    private final List<Consumer<ParticleOperator>> spawnOperators = new ArrayList<Consumer<ParticleOperator>>();
    private final List<Consumer<ParticleOperator>> tickOperators = new ArrayList<Consumer<ParticleOperator>>();
    private final List<Consumer<ParticleOperator>> renderOperators = new ArrayList<Consumer<ParticleOperator>>();
    private final List<Consumer<ParticleOperator>> removeOperators = new ArrayList<Consumer<ParticleOperator>>();

    public AdvancedParticleOptions renderType(class_1921 type) {
        this.renderType = type;
        return this;
    }

    public class_1921 getRenderType() {
        return this.renderType;
    }

    public AdvancedParticleOptions speed(SmoothSegmentedValue x, SmoothSegmentedValue y, SmoothSegmentedValue z) {
        this.xSpeed = x;
        this.ySpeed = y;
        this.zSpeed = z;
        return this;
    }

    public class_243 getSpeed(float progress) {
        return new class_243((double)this.xSpeed.calculate(progress), (double)this.ySpeed.calculate(progress), (double)this.zSpeed.calculate(progress));
    }

    public AdvancedParticleOptions spinSpeed(SmoothSegmentedValue spinSpeed) {
        this.spinSpeed = spinSpeed;
        return this;
    }

    public float getSpinSpeed(float progress) {
        return this.spinSpeed.calculate(progress);
    }

    public AdvancedParticleOptions quadSize(SmoothSegmentedValue quadSize) {
        this.quadSize = quadSize;
        return this;
    }

    public float getQuadSize(float progress) {
        return this.quadSize.calculate(progress);
    }

    public AdvancedParticleOptions lifetime(int lifetime) {
        this.lifetime = lifetime;
        return this;
    }

    public AdvancedParticleOptions color(SmoothSegmentedValue r, SmoothSegmentedValue g, SmoothSegmentedValue b) {
        this.red = r;
        this.green = g;
        this.blue = b;
        return this;
    }

    public AdvancedParticleOptions alpha(SmoothSegmentedValue alpha) {
        this.alpha = alpha;
        return this;
    }

    public AdvancedParticleOptions color(SmoothSegmentedValue r, SmoothSegmentedValue g, SmoothSegmentedValue b, SmoothSegmentedValue a) {
        this.color(r, g, b);
        this.alpha(a);
        return this;
    }

    public Vector4f getColor(float progress) {
        return new Vector4f(this.red.calculate(progress), this.green.calculate(progress), this.blue.calculate(progress), this.alpha.calculate(progress));
    }

    public AdvancedParticleOptions spawnOperator(Consumer<ParticleOperator> operator) {
        this.spawnOperators.add(operator);
        return this;
    }

    public AdvancedParticleOptions tickOperator(Consumer<ParticleOperator> operator) {
        this.tickOperators.add(operator);
        return this;
    }

    public AdvancedParticleOptions renderOperator(Consumer<ParticleOperator> operator) {
        this.renderOperators.add(operator);
        return this;
    }

    public AdvancedParticleOptions removeOperator(Consumer<ParticleOperator> operator) {
        this.removeOperators.add(operator);
        return this;
    }

    public AdvancedParticleOptions defaultOperators() {
        this.spawnOperator(o -> o.setSpeed(this.getSpeed(0.0f)));
        this.spawnOperator(o -> o.setQuadSize(this.getQuadSize(0.0f)));
        this.spawnOperator(o -> o.setColor(this.getColor(0.0f)));
        this.spawnOperator(o -> o.method_3077(this.lifetime));
        this.tickOperator(o -> o.setSpeed(this.getSpeed(o.getAge() / (float)o.method_3082())));
        this.tickOperator(o -> {
            o.setOldRoll(o.getRoll());
            o.setRoll(o.getRoll() + this.getSpinSpeed(o.getAge() / (float)o.method_3082()));
        });
        this.renderOperator(o -> o.setQuadSize(this.getQuadSize(o.getAge() / (float)o.method_3082())));
        this.renderOperator(o -> o.setColor(this.getColor(o.getAge() / (float)o.method_3082())));
        return this;
    }

    public void spawn(class_2960 location, float x, float y, float z) {
        this.spawn(AdvancedParticle::new, location, x, y, z);
    }

    public void spawn(ParticleSpawner spawner, class_2960 location, float x, float y, float z) {
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        class_4066 particleStatus = (class_4066)class_310.method_1551().field_1690.method_42475().method_41753();
        if (particleStatus == class_4066.field_18198 && RANDOM.method_43048(3) == 0) {
            particleStatus = class_4066.field_18199;
        }
        if (camera.method_19326().method_1028((double)x, (double)y, (double)z) <= 1024.0 && particleStatus != class_4066.field_18199) {
            class_703 particle = spawner.spawn(class_310.method_1551().field_1687, x, y, z, (class_4002)class_310.method_1551().field_1713.field_18300.get(location), this);
            class_310.method_1551().field_1713.method_3058(particle);
        }
    }

    public void operateSpawn(ParticleOperator operator) {
        for (Consumer<ParticleOperator> consumer : this.spawnOperators) {
            consumer.accept(operator);
        }
    }

    public void operateTick(ParticleOperator operator) {
        for (Consumer<ParticleOperator> consumer : this.tickOperators) {
            consumer.accept(operator);
        }
    }

    public void operateRender(ParticleOperator operator) {
        for (Consumer<ParticleOperator> consumer : this.renderOperators) {
            consumer.accept(operator);
        }
    }

    public void operateRemove(ParticleOperator operator) {
        for (Consumer<ParticleOperator> consumer : this.removeOperators) {
            consumer.accept(operator);
        }
    }
}

