/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.renderer.entity;

import cn.leolezury.eternalstarlight.common.client.ESRenderType;
import cn.leolezury.eternalstarlight.common.client.handler.ClientHandlers;
import cn.leolezury.eternalstarlight.common.entity.attack.ray.RayAttack;
import cn.leolezury.eternalstarlight.common.entity.interfaces.RayAttackUser;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_897;
import org.joml.Quaternionf;

@Environment(value=EnvType.CLIENT)
public abstract class LaserBeamRenderer<T extends RayAttack>
extends class_897<T> {
    private boolean playerCast = false;

    public LaserBeamRenderer(class_5617.class_5618 context) {
        super(context);
    }

    public float getTextureWidth() {
        return 32.0f;
    }

    public float getBeamRadius() {
        return 1.0f;
    }

    public void render(T laserBeam, float entityYaw, float partialTicks, class_4587 stack, class_4597 bufferSource, int packedLight) {
        RayAttackUser user;
        class_1297 class_12972;
        if (((RayAttack)((Object)laserBeam)).field_6012 < 5) {
            return;
        }
        double entityX = class_3532.method_16436((double)partialTicks, (double)((RayAttack)((Object)laserBeam)).field_6014, (double)laserBeam.method_23317());
        double entityY = class_3532.method_16436((double)partialTicks, (double)((RayAttack)((Object)laserBeam)).field_6036, (double)laserBeam.method_23318());
        double entityZ = class_3532.method_16436((double)partialTicks, (double)((RayAttack)((Object)laserBeam)).field_5969, (double)laserBeam.method_23321());
        stack.method_22903();
        if (((RayAttack)((Object)laserBeam)).getCaster().isPresent()) {
            class_1297 caster = ((RayAttack)((Object)laserBeam)).getCaster().get();
            double posX = class_3532.method_16436((double)partialTicks, (double)caster.field_6014, (double)caster.method_23317());
            double posY = class_3532.method_16436((double)partialTicks, (double)caster.field_6036, (double)caster.method_23318());
            double posZ = class_3532.method_16436((double)partialTicks, (double)caster.field_5969, (double)caster.method_23321());
            class_243 pos = ((RayAttack)((Object)laserBeam)).getPositionForCaster(caster, new class_243(posX, posY, posZ));
            posX = pos.field_1352;
            posY = pos.field_1351;
            posZ = pos.field_1350;
            stack.method_22904(posX - entityX, posY - entityY, posZ - entityZ);
        }
        boolean bl = this.playerCast = class_310.method_1551().field_1690.method_31044().method_31034() && ((RayAttack)((Object)laserBeam)).getCaster().isPresent() && class_310.method_1551().field_1724 != null && ((RayAttack)((Object)laserBeam)).getCaster().get().method_5667().equals(class_310.method_1551().field_1724.method_5667());
        if (this.playerCast && class_310.method_1551().method_1560() != null) {
            class_243 offset = ESMathUtil.rotationToPosition(0.5f, -class_310.method_1551().method_1560().method_36455() - 90.0f, class_310.method_1551().method_1560().method_5791() + 90.0f);
            stack.method_22904(offset.field_1352, offset.field_1351, offset.field_1350);
        }
        float yaw = class_3532.method_16439((float)partialTicks, (float)((RayAttack)((Object)laserBeam)).prevYaw, (float)((RayAttack)((Object)laserBeam)).getYaw()) * ((float)Math.PI / 180);
        float pitch = class_3532.method_16439((float)partialTicks, (float)((RayAttack)((Object)laserBeam)).prevPitch, (float)((RayAttack)((Object)laserBeam)).getPitch()) * ((float)Math.PI / 180);
        if (((RayAttack)((Object)laserBeam)).getCaster().isPresent() && ((class_12972 = ((RayAttack)((Object)laserBeam)).getCaster().get()) instanceof RayAttackUser && (user = (RayAttackUser)class_12972).isRayFollowingHeadRotation() || !(((RayAttack)((Object)laserBeam)).getCaster().get() instanceof RayAttackUser)) && (class_12972 = ((RayAttack)((Object)laserBeam)).getCaster().get()) instanceof class_1309) {
            class_1309 living = (class_1309)class_12972;
            yaw = (living.method_5705(partialTicks) + 90.0f) * ((float)Math.PI / 180);
            pitch = -living.method_5695(partialTicks) * ((float)Math.PI / 180);
        }
        float length = ((RayAttack)((Object)laserBeam)).getLength();
        class_4588 consumer = ClientHandlers.DELAYED_BUFFER_SOURCE.getBuffer(ESRenderType.entityGlow(this.method_3931((class_1297)laserBeam)));
        this.renderBeam(length, yaw, pitch, (float)((RayAttack)((Object)laserBeam)).field_6012 + partialTicks, stack, consumer, packedLight);
        stack.method_22909();
    }

    private void renderBeamPart(float length, float tickCount, class_4587 stack, class_4588 consumer, int packedLight) {
        class_4587.class_4665 pose = stack.method_23760();
        float factor = (float)Math.sin(tickCount);
        float xOffset = tickCount * 0.2f % this.getTextureWidth();
        this.vertex(pose, consumer, -this.getBeamRadius() * 0.8f - factor * this.getBeamRadius() * 0.2f, 0.0f, 0.0f, -xOffset, 0.0f, 1.0f, packedLight);
        this.vertex(pose, consumer, -this.getBeamRadius() * 0.8f - factor * this.getBeamRadius() * 0.2f, length, 0.0f, 1.0f - xOffset, 0.0f, 1.0f, packedLight);
        this.vertex(pose, consumer, this.getBeamRadius() * 0.8f + factor * this.getBeamRadius() * 0.2f, length, 0.0f, 1.0f - xOffset, 1.0f, 1.0f, packedLight);
        this.vertex(pose, consumer, this.getBeamRadius() * 0.8f + factor * this.getBeamRadius() * 0.2f, 0.0f, 0.0f, -xOffset, 1.0f, 1.0f, packedLight);
    }

    private void renderBeam(float length, float yaw, float pitch, float tickCount, class_4587 poseStack, class_4588 vertexConsumer, int packedLight) {
        poseStack.method_22903();
        poseStack.method_22907(new Quaternionf().rotationX(1.5707964f));
        poseStack.method_22907(new Quaternionf().rotationZ(yaw - 1.5707964f));
        poseStack.method_22907(new Quaternionf().rotationX(-pitch));
        poseStack.method_22903();
        if (!this.playerCast) {
            poseStack.method_22907(new Quaternionf().rotationY(tickCount * ((float)Math.PI / 180)));
        }
        this.renderBeamPart(length, tickCount, poseStack, vertexConsumer, packedLight);
        poseStack.method_22909();
        if (!this.playerCast) {
            for (int i = 1; i < 3; ++i) {
                poseStack.method_22903();
                poseStack.method_22907(new Quaternionf().rotationY((float)(i * 30) * ((float)Math.PI / 180)));
                this.renderBeamPart(length, tickCount, poseStack, vertexConsumer, packedLight);
                poseStack.method_22909();
            }
        }
        poseStack.method_22909();
    }

    public void vertex(class_4587.class_4665 pose, class_4588 consumer, float offsetX, float offsetY, float offsetZ, float textureX, float textureY, float alpha, int packedLight) {
        consumer.method_56824(pose, offsetX, offsetY, offsetZ).method_22915(1.0f, 1.0f, 1.0f, 1.0f * alpha).method_22913(textureX, textureY).method_22922(class_4608.field_21444).method_60803(packedLight).method_60831(pose, 0.0f, 1.0f, 0.0f);
    }
}

