/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.boss;

import cn.leolezury.eternalstarlight.common.client.handler.ClientHandlers;
import cn.leolezury.eternalstarlight.common.entity.living.phase.MultiBehaviorUser;
import cn.leolezury.eternalstarlight.common.item.component.ResourceKeyComponent;
import cn.leolezury.eternalstarlight.common.registry.ESDataComponents;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.registry.ESSoundEvents;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1542;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8103;
import net.minecraft.class_9326;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class ESBoss
extends class_1588
implements MultiBehaviorUser {
    private static final String TAG_INITIAL_X = "initial_x";
    private static final String TAG_INITIAL_Y = "initial_y";
    private static final String TAG_INITIAL_Z = "initial_z";
    private static final String TAG_SPAWNED = "spawned";
    private static final String TAG_PHASE = "phase";
    private static final String TAG_ACTIVATED = "activated";
    protected final List<String> fightParticipants = new ArrayList<String>();
    protected static final class_2940<Integer> PHASE = class_2945.method_12791(ESBoss.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Integer> BEHAVIOR_STATE = class_2945.method_12791(ESBoss.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Integer> BEHAVIOR_TICKS = class_2945.method_12791(ESBoss.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Boolean> ACTIVATED = class_2945.method_12791(ESBoss.class, (class_2941)class_2943.field_13323);
    private class_243 initialPos = class_243.field_1353;
    private boolean spawned = false;

    protected ESBoss(class_1299<? extends ESBoss> type, class_1937 level) {
        super(type, level);
        if (level.field_9236) {
            ClientHandlers.BOSSES.add((class_1308)this);
        }
    }

    public int getPhase() {
        return (Integer)this.method_5841().method_12789(PHASE);
    }

    public void setPhase(int phase) {
        this.method_5841().method_12778(PHASE, (Object)phase);
    }

    @Override
    public int getBehaviorState() {
        return (Integer)this.method_5841().method_12789(BEHAVIOR_STATE);
    }

    @Override
    public void setBehaviorState(int behaviourState) {
        this.method_5841().method_12778(BEHAVIOR_STATE, (Object)behaviourState);
    }

    @Override
    public int getBehaviorTicks() {
        return (Integer)this.method_5841().method_12789(BEHAVIOR_TICKS);
    }

    @Override
    public void setBehaviorTicks(int behaviourTicks) {
        this.method_5841().method_12778(BEHAVIOR_TICKS, (Object)behaviourTicks);
    }

    public boolean isActivated() {
        return (Boolean)this.method_5841().method_12789(ACTIVATED);
    }

    public void setActivated(boolean activated) {
        this.method_5841().method_12778(ACTIVATED, (Object)activated);
        if (activated) {
            this.setBehaviorState(0);
            this.setBehaviorTicks(0);
        }
    }

    public class_243 getInitialPos() {
        return this.initialPos;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(BEHAVIOR_STATE, (Object)0).method_56912(BEHAVIOR_TICKS, (Object)0).method_56912(PHASE, (Object)0).method_56912(ACTIVATED, (Object)true);
    }

    public void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        this.initialPos = new class_243(compoundTag.method_10574(TAG_INITIAL_X), compoundTag.method_10574(TAG_INITIAL_Y), compoundTag.method_10574(TAG_INITIAL_Z));
        this.spawned = compoundTag.method_10577(TAG_SPAWNED);
        this.setPhase(compoundTag.method_10550(TAG_PHASE));
        if (compoundTag.method_10573(TAG_ACTIVATED, 3)) {
            this.setActivated(compoundTag.method_10577(TAG_ACTIVATED));
        }
    }

    public void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        compoundTag.method_10549(TAG_INITIAL_X, this.initialPos.field_1352);
        compoundTag.method_10549(TAG_INITIAL_Y, this.initialPos.field_1351);
        compoundTag.method_10549(TAG_INITIAL_Z, this.initialPos.field_1350);
        compoundTag.method_10556(TAG_SPAWNED, this.spawned);
        compoundTag.method_10569(TAG_PHASE, this.getPhase());
        compoundTag.method_10556(TAG_ACTIVATED, this.isActivated());
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_3222 player;
        if (source.method_48789(class_8103.field_42242)) {
            return super.method_5643(source, amount);
        }
        if (source.equals(this.method_37908().method_48963().method_48827())) {
            return false;
        }
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_3222 && !this.fightParticipants.contains((player = (class_3222)class_12972).method_5477().getString())) {
            this.fightParticipants.add(player.method_5477().getString());
        }
        return super.method_5643(source, Math.min(amount, 20.0f));
    }

    public void method_6078(class_1282 source) {
        Object object;
        if (!this.method_37908().field_9236 && (object = this.method_37908().method_8503()) instanceof MinecraftServer) {
            MinecraftServer server = object;
            for (class_3222 player : server.method_3760().method_14571()) {
                for (String name : this.fightParticipants) {
                    if (!player.method_5477().getString().equals(name) || !player.method_5805() || player.method_37908().method_27983() != this.method_37908().method_27983()) continue;
                    class_174.field_1192.method_8990(player, (class_1297)this, source);
                }
            }
        }
        super.method_6078(source);
    }

    public boolean method_5974(double dist) {
        return false;
    }

    public boolean method_61113(class_1937 level, class_1937 level1) {
        return false;
    }

    public boolean method_37222(class_1293 effectInstance, @Nullable class_1297 entity) {
        if (!((class_1291)effectInstance.method_5579().comp_349()).method_5573()) {
            return false;
        }
        return super.method_37222(effectInstance, entity);
    }

    public boolean method_5873(class_1297 entity, boolean bl) {
        return false;
    }

    public boolean canBossMove() {
        return true;
    }

    public void initializeBoss() {
        this.initialPos = this.method_19538();
    }

    public boolean shouldPlayBossMusic() {
        return this.method_5805();
    }

    public class_3414 getBossMusic() {
        return ESSoundEvents.MUSIC_BOSS.get();
    }

    public class_5321<class_52> getBossLootTable() {
        class_2960 resourcelocation = class_7923.field_41177.method_10221((Object)this.method_5864());
        class_2960 lootTable = resourcelocation.method_45138("bosses/");
        return class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)lootTable);
    }

    protected void method_6099(class_3218 serverLevel, class_1282 damageSource, boolean bl) {
        super.method_6099(serverLevel, damageSource, bl);
        if (!this.method_37908().field_9236) {
            for (class_1657 player : this.method_37908().method_18456()) {
                if (!(player instanceof class_3222)) continue;
                class_3222 serverPlayer = (class_3222)player;
                if (!this.fightParticipants.stream().anyMatch(s -> s.equals(player.method_5477().getString())) || !player.method_5805()) continue;
                class_1799 lootBag = new class_1799((class_1935)ESItems.LOOT_BAG.get());
                lootBag.method_59692(class_9326.method_57841().method_57854(ESDataComponents.LOOT_TABLE.get(), new ResourceKeyComponent<class_52>(this.getBossLootTable())).method_57852());
                class_1542 item = player.method_5775(lootBag);
                if (item != null) {
                    item.method_5834(true);
                    item.method_6976();
                }
                this.dropExtraLoot(serverPlayer);
            }
        }
    }

    public void dropExtraLoot(class_3222 player) {
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236) {
            if (!this.spawned) {
                this.initializeBoss();
                this.spawned = true;
            }
            if (!this.canBossMove()) {
                this.method_5814(this.initialPos.field_1352, this.method_19538().field_1351, this.initialPos.field_1350);
            }
        }
    }
}

