/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.npc.boarwarf;

import cn.leolezury.eternalstarlight.common.config.ESConfig;
import cn.leolezury.eternalstarlight.common.data.ESRegistries;
import cn.leolezury.eternalstarlight.common.entity.living.goal.BoarwarfAvoidGoal;
import cn.leolezury.eternalstarlight.common.entity.living.goal.BoarwarfChatGoal;
import cn.leolezury.eternalstarlight.common.entity.living.goal.BoarwarfDoSleepGoal;
import cn.leolezury.eternalstarlight.common.entity.living.goal.BoarwarfLookAtCustomerGoal;
import cn.leolezury.eternalstarlight.common.entity.living.goal.BoarwarfMoveToBedGoal;
import cn.leolezury.eternalstarlight.common.entity.living.goal.BoarwarfRandomStrollNearHomeGoal;
import cn.leolezury.eternalstarlight.common.entity.living.goal.BoarwarfTradeWithPlayerGoal;
import cn.leolezury.eternalstarlight.common.entity.living.goal.BoarwarfWakeUpGoal;
import cn.leolezury.eternalstarlight.common.entity.living.npc.boarwarf.AbstractBoarwarfProfession;
import cn.leolezury.eternalstarlight.common.entity.living.npc.boarwarf.BoarwarfType;
import cn.leolezury.eternalstarlight.common.entity.living.npc.boarwarf.golem.AstralGolem;
import cn.leolezury.eternalstarlight.common.registry.ESBoarwarfProfessions;
import cn.leolezury.eternalstarlight.common.registry.ESSoundEvents;
import cn.leolezury.eternalstarlight.common.util.ESEntityUtil;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1655;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import net.minecraft.class_1915;
import net.minecraft.class_1916;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3853;
import net.minecraft.class_4051;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7094;
import net.minecraft.class_8152;
import org.apache.commons.compress.utils.Sets;
import org.jetbrains.annotations.Nullable;

public class Boarwarf
extends class_1314
implements class_1655,
class_1915 {
    private static final String TAG_TYPE = "type";
    private static final String TAG_PROFESSION = "profession";
    private static final String TAG_RESTOCK_COOLDOWN = "restock_cooldown";
    private static final String TAG_CHAT_COOLDOWN = "chat_cooldown";
    private static final String TAG_CHAT_TICKS = "chat_ticks";
    private static final String TAG_AWAKE_TICKS = "awake_ticks";
    private static final String TAG_SLEEP_TICKS = "sleep_ticks";
    private static final String TAG_HOME_X = "home_x";
    private static final String TAG_HOME_Y = "home_y";
    private static final String TAG_HOME_Z = "home_z";
    private static final String TAG_BOARWARF_CREDIT = "boarwarf_credit";
    @Nullable
    private class_1657 customer;
    @Nullable
    protected class_1916 offers;
    private int restockCooldown = 0;
    private int chatCooldown = 0;
    public int chatTicks = 0;
    private int awakeTicks = 0;
    private int sleepTicks = 0;
    public class_2338 homePos = class_2338.field_10980;
    public Boarwarf chatTarget = null;
    public final class_7094 idleAnimationState = new class_7094();
    protected static final class_2940<String> TYPE = class_2945.method_12791(Boarwarf.class, (class_2941)class_2943.field_13326);
    protected static final class_2940<String> PROFESSION = class_2945.method_12791(Boarwarf.class, (class_2941)class_2943.field_13326);

    public Boarwarf(class_1299<? extends Boarwarf> type, class_1937 level) {
        super(type, level);
    }

    public class_2960 getTypeId() {
        return class_2960.method_60654((String)((String)this.method_5841().method_12789(TYPE)));
    }

    public BoarwarfType getBoarwarfType() {
        return (BoarwarfType)this.method_37908().method_30349().method_30530(ESRegistries.BOARWARF_TYPE).method_10223(this.getTypeId());
    }

    public void setTypeId(class_2960 typeId) {
        this.method_5841().method_12778(TYPE, (Object)typeId.toString());
    }

    public void setBoarwarfType(BoarwarfType type) {
        class_2960 key = this.method_37908().method_30349().method_30530(ESRegistries.BOARWARF_TYPE).method_10221((Object)type);
        if (key != null) {
            this.setTypeId(key);
        }
    }

    public class_2960 getProfessionId() {
        return class_2960.method_60654((String)((String)this.method_5841().method_12789(PROFESSION)));
    }

    public AbstractBoarwarfProfession getProfession() {
        return (AbstractBoarwarfProfession)ESBoarwarfProfessions.PROFESSIONS.registry().method_10223(this.getProfessionId());
    }

    public void setProfessionId(class_2960 professionId) {
        this.method_5841().method_12778(PROFESSION, (Object)professionId.toString());
    }

    public void setProfession(AbstractBoarwarfProfession profession) {
        class_2960 key = ESBoarwarfProfessions.PROFESSIONS.registry().method_10221((Object)profession);
        if (key != null) {
            this.setProfessionId(key);
        }
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(TYPE, (Object)"null").method_56912(PROFESSION, (Object)"null");
    }

    public void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        this.setTypeId((class_2960)class_2960.method_29186((String)compoundTag.method_10558(TAG_TYPE)).getOrThrow());
        this.setProfessionId((class_2960)class_2960.method_29186((String)compoundTag.method_10558(TAG_PROFESSION)).getOrThrow());
        this.restockCooldown = compoundTag.method_10550(TAG_RESTOCK_COOLDOWN);
        this.chatCooldown = compoundTag.method_10550(TAG_CHAT_COOLDOWN);
        this.chatTicks = compoundTag.method_10550(TAG_CHAT_TICKS);
        this.awakeTicks = compoundTag.method_10550(TAG_AWAKE_TICKS);
        this.sleepTicks = compoundTag.method_10550(TAG_SLEEP_TICKS);
        this.homePos = new class_2338(compoundTag.method_10550(TAG_HOME_X), compoundTag.method_10550(TAG_HOME_Y), compoundTag.method_10550(TAG_HOME_Z));
        if (this.offers == null) {
            this.offers = new class_1916();
            this.addTrades();
        }
    }

    public void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        compoundTag.method_10582(TAG_TYPE, this.getTypeId().toString());
        compoundTag.method_10582(TAG_PROFESSION, this.getProfessionId().toString());
        compoundTag.method_10569(TAG_RESTOCK_COOLDOWN, this.restockCooldown);
        compoundTag.method_10569(TAG_CHAT_COOLDOWN, this.chatCooldown);
        compoundTag.method_10569(TAG_CHAT_TICKS, this.chatTicks);
        compoundTag.method_10569(TAG_AWAKE_TICKS, this.awakeTicks);
        compoundTag.method_10569(TAG_SLEEP_TICKS, this.sleepTicks);
        compoundTag.method_10569(TAG_HOME_X, this.homePos.method_10263());
        compoundTag.method_10569(TAG_HOME_Y, this.homePos.method_10264());
        compoundTag.method_10569(TAG_HOME_Z, this.homePos.method_10260());
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new BoarwarfDoSleepGoal(this));
        this.field_6201.method_6277(0, (class_1352)new BoarwarfWakeUpGoal(this));
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new BoarwarfAvoidGoal(this));
        this.field_6201.method_6277(3, (class_1352)new BoarwarfTradeWithPlayerGoal(this));
        this.field_6201.method_6277(3, (class_1352)new BoarwarfLookAtCustomerGoal(this));
        this.field_6201.method_6277(4, (class_1352)new BoarwarfMoveToBedGoal(this, 0.5, 10));
        this.field_6201.method_6277(5, (class_1352)new BoarwarfChatGoal(this, 0.3, true));
        this.field_6201.method_6277(6, (class_1352)new BoarwarfRandomStrollNearHomeGoal(this));
        this.field_6201.method_6277(7, (class_1352)new class_1361((class_1308)this, class_1309.class, 32.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, ESConfig.INSTANCE.mobsConfig.boarwarf.maxHealth()).method_26868(class_5134.field_23724, ESConfig.INSTANCE.mobsConfig.boarwarf.armor()).method_26868(class_5134.field_23719, 0.5);
    }

    @Nullable
    public class_1315 method_5943(class_5425 level, class_1266 instance, class_3730 spawnType, @Nullable class_1315 data) {
        this.homePos = this.method_24515();
        this.method_37908().method_30349().method_30530(ESRegistries.BOARWARF_TYPE).forEach(type -> {
            if (type.biome().comp_349() == level.method_23753(this.method_24515()).comp_349()) {
                this.setBoarwarfType((BoarwarfType)type);
            }
        });
        return super.method_5943(level, instance, spawnType, data);
    }

    protected class_3414 method_5994() {
        if (this.method_6113()) {
            return null;
        }
        return this.hasCustomer() ? ESSoundEvents.BOARWARF_TRADE.get() : ESSoundEvents.BOARWARF_AMBIENT.get();
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return ESSoundEvents.BOARWARF_HURT.get();
    }

    protected class_3414 method_6002() {
        return ESSoundEvents.BOARWARF_DEATH.get();
    }

    protected class_3414 getYesOrNoSound(boolean yesSound) {
        return yesSound ? ESSoundEvents.BOARWARF_YES.get() : ESSoundEvents.BOARWARF_NO.get();
    }

    public class_1269 method_5992(class_1657 player, class_1268 playerHand) {
        if (this.method_5805() && !this.hasCustomer()) {
            if (!this.method_8264().isEmpty() && !this.method_37908().field_9236 && Boarwarf.getBoarwarfCredit(player) >= -30) {
                int credit = Boarwarf.getBoarwarfCredit(player);
                if (credit > 0) {
                    credit /= 10;
                }
                for (class_1914 merchantoffer : this.method_8264()) {
                    merchantoffer.method_19273(-class_3532.method_15375((float)((float)credit / 2.0f)));
                }
                this.method_8259(player);
                this.method_17449(player, this.method_5476(), 1);
            }
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        return super.method_5992(player, playerHand);
    }

    public boolean wantsToSleep() {
        return this.awakeTicks > 12000;
    }

    public boolean wantsToWake() {
        return this.sleepTicks > 12000;
    }

    public void angerNearbyAstralGolems(class_1309 target, boolean replaceCurrentTarget) {
        for (AstralGolem golem : this.method_37908().method_18467(AstralGolem.class, this.method_5829().method_1014(30.0))) {
            class_1657 player;
            if (!replaceCurrentTarget && golem.method_5968() != null || target instanceof class_1657 && (player = (class_1657)target).method_56992()) continue;
            golem.method_5980(target);
        }
    }

    public class_1309 getEntityToAvoid(float maxDist) {
        class_1309 toAvoid = null;
        float currentDist = maxDist;
        List entities = this.method_37908().method_18467(class_1309.class, this.method_5829().method_1014((double)maxDist));
        for (class_1309 entity : entities) {
            class_1657 player;
            class_8152 targeting;
            if (entity instanceof class_8152 && (targeting = (class_8152)entity).method_5968() != null && targeting.method_5968().method_5667().equals(this.method_5667())) {
                this.angerNearbyAstralGolems(entity, false);
                if (currentDist > this.method_5739((class_1297)entity)) {
                    toAvoid = entity;
                    currentDist = this.method_5739((class_1297)entity);
                }
            }
            if (!(entity instanceof class_1657) || Boarwarf.getBoarwarfCredit(player = (class_1657)entity) > -30) continue;
            this.angerNearbyAstralGolems((class_1309)player, false);
            if (!(currentDist > this.method_5739((class_1297)entity))) continue;
            toAvoid = entity;
            currentDist = this.method_5739((class_1297)entity);
        }
        return toAvoid;
    }

    public static int getBoarwarfCredit(class_1657 player) {
        return ESEntityUtil.getPersistentData((class_1297)player).method_10550(TAG_BOARWARF_CREDIT);
    }

    public static void setBoarwarfCredit(class_1657 player, int credit) {
        ESEntityUtil.getPersistentData((class_1297)player).method_10569(TAG_BOARWARF_CREDIT, credit);
    }

    public boolean method_5643(class_1282 source, float amount) {
        int credit;
        class_1657 player;
        class_1297 class_12972;
        if (this.chatCooldown < 12000) {
            this.chatCooldown += 12000;
        }
        if (this.chatTicks > 0) {
            this.chatTicks = 0;
        }
        if ((class_12972 = source.method_5529()) instanceof class_1309) {
            class_1309 livingEntity = (class_1309)class_12972;
            this.angerNearbyAstralGolems(livingEntity, true);
        }
        if ((class_12972 = source.method_5529()) instanceof class_1657 && !(player = (class_1657)class_12972).method_56992() && (credit = (int)((float)Boarwarf.getBoarwarfCredit(player) - amount)) > -10000) {
            Boarwarf.setBoarwarfCredit(player, credit);
        }
        return super.method_5643(source, amount);
    }

    public void method_6078(class_1282 source) {
        int credit;
        class_1657 player;
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1657 && !(player = (class_1657)class_12972).method_56992() && (credit = Boarwarf.getBoarwarfCredit(player) - 20) > -10000) {
            Boarwarf.setBoarwarfCredit(player, credit);
        }
        super.method_6078(source);
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236) {
            if (this.method_37908().method_8510() % 40L == 0L) {
                this.method_6025(1.0f);
            }
            if (this.method_6113()) {
                ++this.sleepTicks;
                this.awakeTicks = 0;
            } else {
                ++this.awakeTicks;
                this.sleepTicks = 0;
            }
            if (this.restockCooldown > 0) {
                --this.restockCooldown;
            } else {
                this.restockCooldown = 12000;
                this.restockAll();
            }
            if (this.chatCooldown > 0) {
                --this.chatCooldown;
            } else {
                this.chatCooldown = 10000;
                this.chatTicks = 4000;
            }
            if (this.chatTicks > 0) {
                --this.chatTicks;
                if (this.chatTarget == null) {
                    List availableChatTargets = this.method_37908().method_18466(Boarwarf.class, class_4051.field_18092, (class_1309)this, this.method_5829().method_1014(15.0));
                    for (Boarwarf boarwarf : availableChatTargets) {
                        if (boarwarf.chatTarget != null) continue;
                        boarwarf.chatTarget = this;
                        this.chatTarget = boarwarf;
                    }
                } else if (this.chatTarget.chatTicks <= 0 || this.chatTarget.chatTarget == null || !this.chatTarget.chatTarget.method_5667().equals(this.method_5667())) {
                    this.chatTarget = null;
                }
            }
        } else {
            this.idleAnimationState.method_41324(this.field_6012);
        }
    }

    public void method_8259(@Nullable class_1657 player) {
        this.customer = player;
    }

    @Nullable
    public class_1657 method_8257() {
        return this.customer;
    }

    public boolean hasCustomer() {
        return this.customer != null;
    }

    public class_1916 method_8264() {
        if (this.offers == null) {
            this.offers = new class_1916();
            this.addTrades();
        }
        return this.offers;
    }

    protected void addTrades() {
        if (this.getProfession() != null) {
            class_1916 merchantoffers = this.method_8264();
            this.addTrades(merchantoffers, this.getProfession().getTrades(this), 5);
        }
    }

    protected void addTrades(class_1916 original, class_3853.class_1652[] newTrades, int maxNumbers) {
        HashSet set = Sets.newHashSet((Object[])new Integer[0]);
        if (newTrades.length > maxNumbers) {
            while (set.size() < maxNumbers) {
                set.add(this.field_5974.method_43048(newTrades.length));
            }
        } else {
            for (int i = 0; i < newTrades.length; ++i) {
                set.add(i);
            }
        }
        for (Integer integer : set) {
            class_3853.class_1652 villagertrades$itrade = newTrades[integer];
            class_1914 merchantoffer = villagertrades$itrade.method_7246((class_1297)this, this.field_5974);
            if (merchantoffer == null) continue;
            original.add((Object)merchantoffer);
        }
    }

    protected void restockAll() {
        for (class_1914 merchantoffer : this.method_8264()) {
            merchantoffer.method_19275();
        }
    }

    public void method_8261(@Nullable class_1916 offers) {
    }

    public void method_8262(class_1914 offer) {
        offer.method_8244();
        this.field_6191 = -this.method_5970();
        if (offer.method_8256()) {
            int i = 3 + this.field_5974.method_43048(4);
            this.method_37908().method_8649((class_1297)new class_1303(this.method_37908(), this.method_23317(), this.method_23318() + 0.5, this.method_23321(), i));
        }
    }

    public void method_8258(class_1799 stack) {
        if (!this.method_37908().field_9236 && this.field_6191 > -this.method_5970() + 20) {
            this.field_6191 = -this.method_5970();
            this.method_5783(this.getYesOrNoSound(!stack.method_7960()), this.method_6107(), this.method_6017());
        }
    }

    public int method_19269() {
        return 0;
    }

    public void method_19271(int xp) {
    }

    public boolean method_19270() {
        return false;
    }

    public class_3414 method_18010() {
        return ESSoundEvents.BOARWARF_YES.get();
    }

    public boolean method_38069() {
        return this.method_37908().field_9236;
    }

    public static boolean checkBoarwarfSpawnRules(class_1299<? extends Boarwarf> type, class_1936 level, class_3730 spawnType, class_2338 pos, class_5819 random) {
        return Boarwarf.method_20636(type, (class_1936)level, (class_3730)spawnType, (class_2338)pos, (class_5819)random) && ESConfig.INSTANCE.mobsConfig.boarwarf.canSpawn();
    }
}

