/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.handler;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.block.fluid.EtherFluid;
import cn.leolezury.eternalstarlight.common.client.helper.ClientHelper;
import cn.leolezury.eternalstarlight.common.crest.Crest;
import cn.leolezury.eternalstarlight.common.data.ESDamageTypes;
import cn.leolezury.eternalstarlight.common.data.ESDimensions;
import cn.leolezury.eternalstarlight.common.entity.projectile.AethersentMeteor;
import cn.leolezury.eternalstarlight.common.entity.projectile.WiltedPetal;
import cn.leolezury.eternalstarlight.common.item.armor.AethersentArmorItem;
import cn.leolezury.eternalstarlight.common.item.armor.GlaciteArmorItem;
import cn.leolezury.eternalstarlight.common.item.armor.ThermalSpringstoneArmorItem;
import cn.leolezury.eternalstarlight.common.item.component.CurrentCrestComponent;
import cn.leolezury.eternalstarlight.common.item.interfaces.TickableArmor;
import cn.leolezury.eternalstarlight.common.item.misc.ManaCrystalItem;
import cn.leolezury.eternalstarlight.common.network.NoParametersPacket;
import cn.leolezury.eternalstarlight.common.network.UpdateWeatherPacket;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESAttributes;
import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.registry.ESCriteriaTriggers;
import cn.leolezury.eternalstarlight.common.registry.ESDataComponents;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.registry.ESMobEffects;
import cn.leolezury.eternalstarlight.common.registry.ESParticles;
import cn.leolezury.eternalstarlight.common.resource.gatekeeper.TheGatekeeperNameManager;
import cn.leolezury.eternalstarlight.common.spell.ManaType;
import cn.leolezury.eternalstarlight.common.util.ConventionalTags;
import cn.leolezury.eternalstarlight.common.util.ESBlockUtil;
import cn.leolezury.eternalstarlight.common.util.ESBookUtil;
import cn.leolezury.eternalstarlight.common.util.ESCrestUtil;
import cn.leolezury.eternalstarlight.common.util.ESEntityUtil;
import cn.leolezury.eternalstarlight.common.util.ESSpellUtil;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import cn.leolezury.eternalstarlight.common.util.ESWeatherUtil;
import cn.leolezury.eternalstarlight.common.weather.AbstractWeather;
import cn.leolezury.eternalstarlight.common.weather.WeatherInstance;
import cn.leolezury.eternalstarlight.common.weather.Weathers;
import cn.leolezury.eternalstarlight.common.world.gen.biomesource.ESBiomeSource;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1966;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3302;
import net.minecraft.class_3481;
import net.minecraft.class_3966;
import net.minecraft.class_5134;
import net.minecraft.class_5253;
import net.minecraft.class_8103;
import net.minecraft.class_8779;
import net.minecraft.class_9326;
import net.minecraft.class_9381;
import net.minecraft.server.MinecraftServer;

public class CommonHandlers {
    private static final String TAG_IN_ETHER_TICKS = "in_ether_ticks";
    public static final String TAG_CLIENT_IN_ETHER_TICKS = "client_in_ether_ticks";
    private static final String TAG_OBTAINED_BLOSSOM_OF_STARS = "obtained_blossom_of_stars";
    public static final String TAG_CRYSTAL_ARROW = "eternal_starlight:crystal";
    public static final String TAG_STARFALL_ARROW = "eternal_starlight:starfall";
    public static final String TAG_WILTED_ARROW = "eternal_starlight:wilted";
    public static final String TAG_IN_ABYSSAL_FIRE_TICKS = "in_abyssal_fire_ticks";
    private static TheGatekeeperNameManager gatekeeperNames;
    private static Weathers starlightWeathers;
    private static AbstractWeather lastWeather;
    private static int ticksSinceLastUpdate;
    private static final class_1322 AMARAMBER_BONUS;

    public static String getGatekeeperName() {
        return gatekeeperNames.getTheGatekeeperName();
    }

    public static Optional<WeatherInstance> getActiveWeather() {
        if (starlightWeathers == null) {
            return Optional.empty();
        }
        return starlightWeathers.getActiveWeather();
    }

    public static void onServerTick(MinecraftServer server) {
        if (++ticksSinceLastUpdate >= 20) {
            for (class_3218 level : server.method_3738()) {
                class_1966 class_19662 = level.method_14178().method_12129().method_12098();
                if (!(class_19662 instanceof ESBiomeSource)) continue;
                ESBiomeSource source = (ESBiomeSource)class_19662;
                source.setCacheSize(level.method_18456().size() * 8);
            }
            ticksSinceLastUpdate = 0;
        }
    }

    public static void onLevelLoad(class_3218 serverLevel) {
        if (serverLevel.method_27983() == ESDimensions.STARLIGHT_KEY) {
            starlightWeathers = ESWeatherUtil.getOrCreateWeathers(serverLevel);
        }
    }

    public static void onLevelTick(class_3218 serverLevel) {
        if (serverLevel.method_27983() == ESDimensions.STARLIGHT_KEY && starlightWeathers != null) {
            starlightWeathers.tick();
            long gameTime = serverLevel.method_8510();
            starlightWeathers.getActiveWeather().ifPresentOrElse(weatherInstance -> {
                if (weatherInstance.getWeather() != lastWeather || gameTime % 200L == 0L) {
                    ESPlatform.INSTANCE.sendToAllClients(serverLevel, new UpdateWeatherPacket(weatherInstance.getWeather()));
                    lastWeather = weatherInstance.getWeather();
                }
                if (gameTime % 80L == 0L) {
                    for (class_3222 player : serverLevel.method_18456()) {
                        if (!serverLevel.method_8311(class_2338.method_49638((class_2374)player.method_33571()))) continue;
                        ESCriteriaTriggers.WITNESS_WEATHER.get().trigger(player);
                    }
                }
            }, () -> {
                if (lastWeather != null || gameTime % 200L == 0L) {
                    ESPlatform.INSTANCE.sendToAllClients(serverLevel, new NoParametersPacket("cancel_weather"));
                    lastWeather = null;
                }
            });
        }
    }

    public static float onModifyLivingHurtDamage(class_1309 entity, class_1282 source, float amount) {
        float modified = amount;
        if (source.method_48789(class_8103.field_42246)) {
            class_1293 instance;
            if (entity.method_6059(ESMobEffects.FLAMMABLE.asHolder()) && (instance = entity.method_6112(ESMobEffects.FLAMMABLE.asHolder())) != null) {
                modified *= (float)(instance.method_5578() + 2);
            }
            if (entity.method_6118(class_1304.field_6169).method_7909() instanceof ThermalSpringstoneArmorItem || entity.method_6118(class_1304.field_6174).method_7909() instanceof ThermalSpringstoneArmorItem || entity.method_6118(class_1304.field_6172).method_7909() instanceof ThermalSpringstoneArmorItem || entity.method_6118(class_1304.field_6166).method_7909() instanceof ThermalSpringstoneArmorItem) {
                modified /= 2.0f;
            }
        }
        return modified;
    }

    public static void onPostLivingHurt(class_1309 entity, class_1282 source, float amount) {
        if (amount > 0.0f) {
            class_1657 player;
            class_1297 serverLevel;
            class_1297 class_12972;
            class_1309 attacker;
            class_1309 livingEntity;
            class_1297 class_12973;
            if ((entity.method_6118(class_1304.field_6169).method_7909() instanceof ThermalSpringstoneArmorItem || entity.method_6118(class_1304.field_6174).method_7909() instanceof ThermalSpringstoneArmorItem || entity.method_6118(class_1304.field_6172).method_7909() instanceof ThermalSpringstoneArmorItem || entity.method_6118(class_1304.field_6166).method_7909() instanceof ThermalSpringstoneArmorItem) && (class_12973 = source.method_5526()) instanceof class_1309) {
                livingEntity = (class_1309)class_12973;
                livingEntity.method_20803(livingEntity.method_20802() + 200);
            }
            if ((class_12973 = source.method_5526()) instanceof class_1309 && (attacker = (class_1309)class_12973).method_5998(class_1268.field_5808).method_31573(ESTags.Items.THERMAL_SPRINGSTONE_WEAPONS)) {
                entity.method_20803(entity.method_20802() + 200);
            }
            if ((entity.method_6118(class_1304.field_6169).method_7909() instanceof GlaciteArmorItem || entity.method_6118(class_1304.field_6174).method_7909() instanceof GlaciteArmorItem || entity.method_6118(class_1304.field_6172).method_7909() instanceof GlaciteArmorItem || entity.method_6118(class_1304.field_6166).method_7909() instanceof GlaciteArmorItem) && (class_12973 = source.method_5526()) instanceof class_1309) {
                livingEntity = (class_1309)class_12973;
                livingEntity.method_32317(livingEntity.method_32312() + 80);
            }
            if ((class_12973 = source.method_5526()) instanceof class_1309 && (attacker = (class_1309)class_12973).method_5998(class_1268.field_5808).method_31573(ESTags.Items.GLACITE_WEAPONS) && entity.method_32316()) {
                entity.method_32317(entity.method_32312() + 80);
            }
            if (entity.method_6118(class_1304.field_6169).method_7909() instanceof AethersentArmorItem && entity.method_6118(class_1304.field_6174).method_7909() instanceof AethersentArmorItem && entity.method_6118(class_1304.field_6172).method_7909() instanceof AethersentArmorItem && entity.method_6118(class_1304.field_6166).method_7909() instanceof AethersentArmorItem && (class_12972 = source.method_5529()) instanceof class_1309 && (class_12972 = (livingEntity = (class_1309)class_12972).method_37908()) instanceof class_3218) {
                serverLevel = (class_3218)class_12972;
                class_243 location = livingEntity.method_19538();
                AethersentMeteor.createMeteorShower((class_1937)serverLevel, entity, livingEntity, location.field_1352, location.field_1351, location.field_1350, 200.0, true);
            }
            if ((serverLevel = source.method_5526()) instanceof class_1657 && (player = (class_1657)serverLevel).method_59922().method_43048(15) == 0) {
                class_1661 inventory = player.method_31548();
                boolean hasCrystals = false;
                for (int i = 0; i < inventory.method_5439(); ++i) {
                    if (!inventory.method_5438(i).method_31573(ESTags.Items.MANA_CRYSTALS)) continue;
                    hasCrystals = true;
                }
                if (hasCrystals) {
                    class_1542 itemEntity = new class_1542(player.method_37908(), entity.method_23317(), entity.method_23318(), entity.method_23321(), ESItems.MANA_CRYSTAL_SHARD.get().method_7854());
                    player.method_37908().method_8649((class_1297)itemEntity);
                }
            }
        }
    }

    public static void onEntityTick(class_1297 entity) {
        class_1792 target;
        class_1937 level = entity.method_37908();
        if (entity instanceof class_1542) {
            class_1542 item = (class_1542)entity;
            if (!item.method_37908().field_9236) {
                if (item.field_6012 % 100 == 0 && item.method_6983().method_31573(ConventionalTags.Items.MUSIC_DISCS) && !item.method_6983().method_31574(ESItems.MUSIC_DISC_SPIRIT.get()) && ESBlockUtil.isEntityInBlock((class_1297)item, (class_2248)ESBlocks.ETHER.get())) {
                    item.method_6979(ESItems.MUSIC_DISC_SPIRIT.get().method_7854());
                    item.method_45319(new class_243(0.0, 0.25, 0.0));
                }
            } else if (item.method_6983().method_31573(ESTags.Items.MANA_CRYSTALS) || item.method_6983().method_7909() == ESItems.MANA_CRYSTAL_SHARD.get()) {
                ManaType manaType;
                ClientHelper clientHelper = EternalStarlight.getClientHelper();
                class_1792 class_17922 = item.method_6983().method_7909();
                if (class_17922 instanceof ManaCrystalItem) {
                    ManaCrystalItem crystalItem = (ManaCrystalItem)class_17922;
                    manaType = crystalItem.getManaType();
                } else {
                    manaType = ManaType.LUNAR;
                }
                clientHelper.spawnManaCrystalItemParticles(manaType, item.method_19538().method_1031(0.0, (double)(item.method_17682() / 2.0f), 0.0));
            }
        }
        class_2487 persistentData = ESEntityUtil.getPersistentData(entity);
        int inAbyssalFireTicks = persistentData.method_10550(TAG_IN_ABYSSAL_FIRE_TICKS);
        persistentData.method_10569(TAG_IN_ABYSSAL_FIRE_TICKS, Math.max(inAbyssalFireTicks - 1, 0));
        if (!level.field_9236 && entity instanceof class_1665) {
            class_1665 arrow = (class_1665)entity;
            if (persistentData.method_10577(TAG_WILTED_ARROW) && !arrow.field_7588) {
                List affected = level.method_18467(class_1309.class, entity.method_5829().method_1014(5.0));
                affected.removeIf(e -> arrow.method_24921() != null && e.method_5667().equals(arrow.method_24921().method_5667()));
                for (class_1309 living : affected) {
                    living.method_6092(new class_1293(class_1294.field_5909, 80));
                    living.method_6092(new class_1293(class_1294.field_5920, entity.method_5799() ? 300 : 160));
                }
                if (arrow.field_6012 % 4 == 0) {
                    for (int i = 0; i < 3; ++i) {
                        WiltedPetal wiltedPetal;
                        class_1297 class_12972 = arrow.method_24921();
                        if (class_12972 instanceof class_1309) {
                            class_1309 living = (class_1309)class_12972;
                            wiltedPetal = new WiltedPetal(level, living);
                        } else {
                            wiltedPetal = new WiltedPetal(ESEntities.WILTED_PETAL.get(), level);
                        }
                        WiltedPetal petal = wiltedPetal;
                        petal.method_33574(entity.method_19538());
                        class_243 movement = new class_243((double)entity.method_59922().method_43057() - 0.5, (double)entity.method_59922().method_43057() - 0.5, (double)entity.method_59922().method_43057() - 0.5);
                        if (affected.size() > i) {
                            target = (class_1309)affected.get(i);
                            movement = target.method_19538().method_1031(0.0, (double)(target.method_17682() / 2.0f), 0.0).method_1020(entity.method_19538());
                        }
                        petal.method_7485(movement.field_1352, movement.field_1351, movement.field_1350, 0.8f, 0.2f);
                        level.method_8649((class_1297)petal);
                    }
                }
                if (level instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)level;
                    serverLevel.method_14199((class_2394)class_9381.method_58256((class_2396)class_2398.field_11226, (int)class_5253.class_5254.method_58144((int)96, (int)9437243)), entity.method_23317(), entity.method_23318(), entity.method_23321(), 6, 2.0, 2.0, 2.0, 0.2);
                }
            }
        }
        if (entity instanceof class_1309) {
            int cooldown;
            class_1309 livingEntity = (class_1309)entity;
            ESSpellUtil.tickSpells(livingEntity);
            if (livingEntity instanceof class_1657) {
                class_1657 player = (class_1657)livingEntity;
                if (!livingEntity.method_37908().field_9236) {
                    ESCrestUtil.tickCrests(player);
                }
            }
            List<class_1799> armors = List.of(livingEntity.method_6118(class_1304.field_6169), livingEntity.method_6118(class_1304.field_6174), livingEntity.method_6118(class_1304.field_6172), livingEntity.method_6118(class_1304.field_6166));
            for (class_1799 armor : armors) {
                target = armor.method_7909();
                if (!(target instanceof TickableArmor)) continue;
                TickableArmor tickableArmor = (TickableArmor)target;
                tickableArmor.tick(livingEntity.method_37908(), livingEntity, armor);
            }
            class_1324 armorAttribute = livingEntity.method_6127().method_45329(class_5134.field_23724);
            if (armorAttribute != null) {
                if (livingEntity.method_6118(class_1304.field_6169).method_31574(ESItems.AMARAMBER_HELMET.get()) && livingEntity.method_6118(class_1304.field_6174).method_31574(ESItems.AMARAMBER_CHESTPLATE.get()) && livingEntity.method_6118(class_1304.field_6172).method_7960() && livingEntity.method_6118(class_1304.field_6166).method_7960()) {
                    if (!armorAttribute.method_6196(AMARAMBER_BONUS.comp_2447())) {
                        armorAttribute.method_26837(AMARAMBER_BONUS);
                    }
                } else if (armorAttribute.method_6196(AMARAMBER_BONUS.comp_2447())) {
                    armorAttribute.method_6200(AMARAMBER_BONUS.comp_2447());
                }
            }
            if (livingEntity.field_6012 % 20 == 0 && (cooldown = persistentData.method_10550("meteor_cooldown")) > 0) {
                persistentData.method_10569("meteor_cooldown", cooldown - 1);
            }
            int inEtherTicks = persistentData.method_10550(TAG_IN_ETHER_TICKS);
            class_1324 armorInstance = livingEntity.method_6127().method_45329(class_5134.field_23724);
            boolean inEther = ESBlockUtil.isEntityInBlock((class_1297)livingEntity, (class_2248)ESBlocks.ETHER.get());
            if (!livingEntity.method_37908().field_9236) {
                if (inEther) {
                    float factor = 0.0f;
                    class_1324 resistance = livingEntity.method_5996(ESAttributes.ETHER_RESISTANCE.asHolder());
                    if (resistance != null) {
                        factor = 1.0f - (float)resistance.method_6194();
                    }
                    if (armorInstance != null && armorInstance.method_6194() <= 0.0 && entity.method_5643(ESDamageTypes.getDamageSource(level, ESDamageTypes.ETHER), 0.3f + 0.6f * factor) && level instanceof class_3218) {
                        class_3218 serverLevel = (class_3218)level;
                        for (int i = 0; i < 5; ++i) {
                            serverLevel.method_14199((class_2394)ESParticles.STARLIGHT.get(), entity.method_23317() + (livingEntity.method_59922().method_43058() - 0.5) * (double)entity.method_17681(), entity.method_23318() + (double)entity.method_17682() / 2.0 + (livingEntity.method_59922().method_43058() - 0.5) * (double)entity.method_17682(), entity.method_23321() + (livingEntity.method_59922().method_43058() - 0.5) * (double)entity.method_17681(), 20, 0.1, 0.1, 0.1, 0.0);
                        }
                    }
                    if ((armorInstance == null || armorInstance.method_6194() > 0.0) && livingEntity.method_59922().method_43057() <= factor) {
                        persistentData.method_10569(TAG_IN_ETHER_TICKS, inEtherTicks + 1);
                    }
                }
                if (!inEther && inEtherTicks > 0) {
                    persistentData.method_10569(TAG_IN_ETHER_TICKS, inEtherTicks - 1);
                }
                if (inEtherTicks <= 0 && armorInstance != null) {
                    armorInstance.method_6200(EtherFluid.ARMOR_MODIFIER_ID);
                }
                if (livingEntity.field_6012 % 20 == 0 && inEtherTicks > 0 && armorInstance != null) {
                    armorInstance.method_6200(EtherFluid.ARMOR_MODIFIER_ID);
                    armorInstance.method_26837(EtherFluid.armorModifier((float)(-inEtherTicks) / 100.0f));
                }
            } else {
                int clientEtherTicks = persistentData.method_10550(TAG_CLIENT_IN_ETHER_TICKS);
                if (inEther && clientEtherTicks < 140) {
                    persistentData.method_10569(TAG_CLIENT_IN_ETHER_TICKS, clientEtherTicks + 1);
                }
                if (!inEther && clientEtherTicks > 0) {
                    persistentData.method_10569(TAG_CLIENT_IN_ETHER_TICKS, clientEtherTicks - 1);
                }
            }
        }
    }

    public static void onBlockBroken(class_1657 player, class_2338 pos, class_2680 state) {
        if (state.method_26164(class_3481.field_15503) && player.method_37908().method_27983() == ESDimensions.STARLIGHT_KEY) {
            float chance;
            float f = player.method_5477().getString().toLowerCase(Locale.ROOT).contains("nuttar") ? (ESEntityUtil.getPersistentData((class_1297)player).method_10577(TAG_OBTAINED_BLOSSOM_OF_STARS) ? 2.5f : 25.0f) : (chance = 0.0025f);
            if (player.method_59922().method_43057() < chance / 100.0f) {
                ESEntityUtil.getPersistentData((class_1297)player).method_10556(TAG_OBTAINED_BLOSSOM_OF_STARS, true);
                if (!player.method_31548().method_7394(ESItems.BLOSSOM_OF_STARS.get().method_7854())) {
                    player.method_5706((class_1935)ESItems.BLOSSOM_OF_STARS.get());
                }
            }
        }
    }

    public static void onShieldBlock(class_1309 blocker, class_1282 source) {
        class_1309 entity;
        class_1297 class_12972;
        if (blocker.method_6030().method_31574(ESItems.GLACITE_SHIELD.get()) && (class_12972 = source.method_5526()) instanceof class_1309 && (entity = (class_1309)class_12972).method_32316()) {
            entity.method_32317(entity.method_32312() + 100);
        }
    }

    public static void onArrowHit(class_1676 projectile, class_239 result) {
        class_1937 class_19372 = projectile.method_37908();
        if (class_19372 instanceof class_3218) {
            class_1297 living;
            class_3966 entityHitResult;
            class_1297 class_12972;
            class_3218 serverLevel = (class_3218)class_19372;
            if (ESEntityUtil.getPersistentData((class_1297)projectile).method_10545(TAG_CRYSTAL_ARROW) && result.method_17783() == class_239.class_240.field_1331 && result instanceof class_3966 && (class_12972 = (entityHitResult = (class_3966)result).method_17782()) instanceof class_1309) {
                class_1293 instance;
                living = (class_1309)class_12972;
                int level = 0;
                if (living.method_6059(ESMobEffects.CRYSTALLINE_INFECTION.asHolder()) && (instance = living.method_6112(ESMobEffects.CRYSTALLINE_INFECTION.asHolder())) != null) {
                    level += instance.method_5578();
                }
                living.method_6092(new class_1293(ESMobEffects.CRYSTALLINE_INFECTION.asHolder(), 200, level));
            }
            if (ESEntityUtil.getPersistentData((class_1297)projectile).method_10545(TAG_STARFALL_ARROW) && (living = projectile.method_24921()) instanceof class_1309) {
                class_1309 livingEntity;
                class_3966 entityHitResult2;
                class_1297 class_12973;
                class_1309 owner = (class_1309)living;
                class_243 location = result.method_17784();
                AethersentMeteor.createMeteorShower((class_1937)serverLevel, owner, result instanceof class_3966 && (class_12973 = (entityHitResult2 = (class_3966)result).method_17782()) instanceof class_1309 ? (livingEntity = (class_1309)class_12973) : null, location.field_1352, location.field_1351, location.field_1350, 200.0, false);
            }
        }
    }

    public static void onPlayerNaturalWake(class_3222 serverPlayer, class_2338 pos) {
    }

    public static void onCompleteAdvancement(class_1657 player, class_8779 advancement) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (advancement.comp_1919().equals((Object)EternalStarlight.id("enter_starlight"))) {
                ESBookUtil.unlockFor(serverPlayer, EternalStarlight.id("enter_starlight"));
            }
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static void onC2sNoParamPacket(class_3222 player, String id) {
        var2_2 = id;
        var3_3 = -1;
        switch (var2_2.hashCode()) {
            case 1570723308: {
                if (!var2_2.equals("switch_crest")) break;
                var3_3 = 0;
            }
        }
        switch (var3_3) {
            case 0: {
                set = ESCrestUtil.getOwnedCrests((class_1657)player);
                crests = set.crests();
                mainHand = player.method_6047();
                offHand = player.method_6079();
                component = null;
                nextCrest = null;
                if (mainHand.method_57826(ESDataComponents.CURRENT_CREST.get())) {
                    component = (CurrentCrestComponent)mainHand.method_57824(ESDataComponents.CURRENT_CREST.get());
                    spellItem /* !! */  = mainHand;
                } else if (offHand.method_57826(ESDataComponents.CURRENT_CREST.get())) {
                    component = (CurrentCrestComponent)offHand.method_57824(ESDataComponents.CURRENT_CREST.get());
                    spellItem /* !! */  = offHand;
                } else {
                    spellItem /* !! */  = mainHand.method_31574(ESItems.ORB_OF_PROPHECY.get()) != false ? mainHand : (offHand.method_31574(ESItems.ORB_OF_PROPHECY.get()) != false ? offHand : null);
                }
                if (component == null) ** GOTO lbl33
                for (i = 0; i < crests.size(); ++i) {
                    if (!crests.get(i).crest().method_55838(component.crest()) || i >= crests.size() - 1) continue;
                    for (j = i + 1; j < crests.size(); ++j) {
                        if (!((Crest)crests.get(j).crest().comp_349()).getSpell().isPresent()) continue;
                        nextCrest = crests.get(j).crest();
                        ** GOTO lbl37
                    }
                }
                ** GOTO lbl37
lbl33:
                // 2 sources

                for (Crest.Instance instance : crests) {
                    if (!((Crest)instance.crest().comp_349()).getSpell().isPresent()) continue;
                    nextCrest = instance.crest();
                    break;
                }
lbl37:
                // 4 sources

                if (spellItem /* !! */  == null) break;
                if (nextCrest != null && nextCrest.method_40227()) {
                    spellItem /* !! */ .method_59692(class_9326.method_57841().method_57854(ESDataComponents.CURRENT_CREST.get(), (Object)new CurrentCrestComponent(nextCrest)).method_57852());
                    break;
                }
                spellItem /* !! */ .method_57381(ESDataComponents.CURRENT_CREST.get());
            }
        }
    }

    public static void addReloadListeners(AddReloadListenerStrategy strategy) {
        gatekeeperNames = ESPlatform.INSTANCE.createGatekeeperNameManager();
        strategy.add((class_3302)gatekeeperNames);
    }

    static {
        ticksSinceLastUpdate = 0;
        AMARAMBER_BONUS = new class_1322(EternalStarlight.id("armor.amaramber_bonus"), 7.0, class_1322.class_1323.field_6328);
    }

    public static interface AddReloadListenerStrategy {
        public void add(class_3302 var1);
    }
}

