/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.util;

import cn.leolezury.eternalstarlight.common.crest.Crest;
import cn.leolezury.eternalstarlight.common.data.ESRegistries;
import cn.leolezury.eternalstarlight.common.item.component.CurrentCrestComponent;
import cn.leolezury.eternalstarlight.common.network.ParticlePacket;
import cn.leolezury.eternalstarlight.common.particle.OrbitalTrailParticleOptions;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESDataComponents;
import cn.leolezury.eternalstarlight.common.util.ESEntityUtil;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;

public class ESCrestUtil {
    public static final String TAG_CRESTS = "crests";
    public static final String TAG_OWNED_CRESTS = "owned_crests";

    public static Crest.Set getCrests(class_1657 player) {
        return ESCrestUtil.getCrests(player, TAG_CRESTS);
    }

    public static Crest.Set getOwnedCrests(class_1657 player) {
        return ESCrestUtil.getCrests(player, TAG_OWNED_CRESTS);
    }

    public static Crest.Set getCrests(class_1657 player, String tagId) {
        class_2487 tag = ESEntityUtil.getPersistentData((class_1297)player).method_10562(tagId);
        return ESCrestUtil.getCrests((class_7225.class_7874)player.method_56673(), tag);
    }

    public static Crest.Set getCrests(class_7225.class_7874 provider, class_2487 tag) {
        return Crest.Set.CODEC.parse((DynamicOps)provider.method_57093((DynamicOps)class_2509.field_11560), (Object)tag).resultOrPartial().orElse(new Crest.Set(new ArrayList<Crest.Instance>()));
    }

    public static boolean setCrests(class_1657 player, List<Crest.Instance> crests) {
        return ESCrestUtil.setCrests(player, crests, TAG_CRESTS);
    }

    public static boolean setCrests(class_1657 player, List<Crest.Instance> crests, String tagId) {
        Optional<class_2520> optionalTag = ESCrestUtil.setCrests((class_7225.class_7874)player.method_56673(), crests);
        if (optionalTag.isEmpty()) {
            return false;
        }
        ESEntityUtil.getPersistentData((class_1297)player).method_10566(tagId, optionalTag.get());
        return true;
    }

    public static Optional<class_2520> setCrests(class_7225.class_7874 provider, List<Crest.Instance> crests) {
        return Crest.Set.CODEC.encodeStart((DynamicOps)provider.method_57093((DynamicOps)class_2509.field_11560), (Object)new Crest.Set(crests)).resultOrPartial();
    }

    public static boolean giveCrest(class_1657 player, Crest.Instance crest) {
        Crest.Set set = ESCrestUtil.getCrests(player, TAG_OWNED_CRESTS);
        ArrayList<Crest.Instance> crests = new ArrayList<Crest.Instance>(set.crests());
        for (Crest.Instance instance : crests) {
            if (!instance.crest().method_55838(crest.crest()) || instance.level() < crest.level()) continue;
            return false;
        }
        crests.removeIf(c -> c.crest().method_55838(crest.crest()));
        crests.add(crest);
        ESCrestUtil.setCrests(player, crests, TAG_OWNED_CRESTS);
        return true;
    }

    public static boolean upgradeCrest(class_1657 player, class_5321<Crest> key) {
        Optional<Crest.Instance> instance = Crest.Instance.of(player.method_56673(), key, ESCrestUtil.getCrestLevel(player, key) + 1);
        return instance.isPresent() && ESCrestUtil.giveCrest(player, instance.get());
    }

    public static boolean removeCrest(class_1657 player, class_6880<Crest> crest) {
        return ESCrestUtil.removeCrest(player, crest, TAG_OWNED_CRESTS) || ESCrestUtil.removeCrest(player, crest, TAG_CRESTS);
    }

    public static boolean removeCrest(class_1657 player, class_6880<Crest> crest, String tagId) {
        Crest.Set set = ESCrestUtil.getCrests(player, tagId);
        ArrayList<Crest.Instance> crests = new ArrayList<Crest.Instance>(set.crests());
        if (crests.stream().noneMatch(c -> c.crest().method_55838(crest))) {
            return false;
        }
        crests.removeIf(c -> c.crest().method_55838(crest));
        ESCrestUtil.setCrests(player, crests, tagId);
        return true;
    }

    public static List<Crest.Instance> mergeCrests(List<Crest.Instance> first, List<Crest.Instance> second) {
        ArrayList<Crest.Instance> result = new ArrayList<Crest.Instance>(first);
        for (Crest.Instance instance : second) {
            boolean hasSame = false;
            int level = instance.level();
            for (int i = 0; i < result.size(); ++i) {
                if (!((Crest.Instance)result.get(i)).crest().method_55838(instance.crest())) continue;
                level = Math.max(level, ((Crest.Instance)result.get(i)).level());
                result.set(i, new Crest.Instance(instance.crest(), level));
                hasSame = true;
            }
            if (hasSame) continue;
            result.add(instance);
        }
        return result;
    }

    public static int getCrestLevel(class_1657 player, class_5321<Crest> key) {
        Optional crest = player.method_56673().method_30530(ESRegistries.CREST).method_40264(key);
        return crest.map(ref -> ESCrestUtil.getCrestLevel(player, (class_6880<Crest>)ref)).orElse(0);
    }

    public static int getCrestLevel(class_1657 player, class_6880<Crest> crest) {
        Crest.Set set = ESCrestUtil.getCrests(player, TAG_OWNED_CRESTS);
        for (Crest.Instance instance : set.crests()) {
            if (!instance.crest().method_55838(crest)) continue;
            return instance.level();
        }
        return 0;
    }

    public static void tickCrests(class_1657 player) {
        class_1937 class_19372;
        CurrentCrestComponent component;
        Crest.Set ownedSet = ESCrestUtil.getCrests(player, TAG_OWNED_CRESTS);
        Crest.Set set = ESCrestUtil.getCrests(player);
        List<Crest.Instance> ownedCrestInstances = ownedSet.crests();
        List<Crest.Instance> crestInstances = set.crests();
        class_1799 mainHand = player.method_6047();
        class_1799 offHand = player.method_6079();
        if (mainHand.method_57826(ESDataComponents.CURRENT_CREST.get())) {
            component = (CurrentCrestComponent)mainHand.method_57824(ESDataComponents.CURRENT_CREST.get());
            if (component != null && component.crest().method_40227() && ownedCrestInstances.stream().noneMatch(c -> c.crest().method_55838(component.crest()))) {
                mainHand.method_57381(ESDataComponents.CURRENT_CREST.get());
            }
        } else if (offHand.method_57826(ESDataComponents.CURRENT_CREST.get()) && (component = (CurrentCrestComponent)offHand.method_57824(ESDataComponents.CURRENT_CREST.get())) != null && component.crest().method_40227() && ownedCrestInstances.stream().noneMatch(c -> c.crest().method_55838(component.crest()))) {
            offHand.method_57381(ESDataComponents.CURRENT_CREST.get());
        }
        crestInstances.forEach(crest -> {
            if (player.method_56992()) {
                ESCrestUtil.applyCrestEffects(player, crest);
            } else {
                class_1661 inventory = player.method_31548();
                for (int i = 0; i < inventory.method_5439(); ++i) {
                    class_1799 stack = inventory.method_5438(i);
                    if (!stack.method_31573(((Crest)crest.crest().comp_349()).type().getCrystalsTag())) continue;
                    ESCrestUtil.applyCrestEffects(player, crest);
                    if (player.field_6012 % 60 != 0) break;
                    stack.method_7970(crest.level(), (class_1309)player, class_1304.field_6173);
                    break;
                }
            }
        });
        player.method_37908().method_30349().method_30530(ESRegistries.CREST).forEach(c -> c.attributeModifiers().ifPresent(modifiers -> modifiers.forEach(modifier -> {
            class_1324 instance = player.method_6127().method_45329(modifier.attribute());
            if (instance != null) {
                instance.method_6195().forEach(m -> {
                    if (m.comp_2447().toString().startsWith(modifier.id().toString()) && crestInstances.stream().noneMatch(c1 -> ((Crest)c1.crest().comp_349()).attributeModifiers().isPresent() && ((Crest)c1.crest().comp_349()).attributeModifiers().get().stream().anyMatch(mod -> mod.getModifierId(c1.level()).equals((Object)m.comp_2447())))) {
                        instance.method_6200(m.comp_2447());
                    }
                });
            }
        })));
        if (!crestInstances.isEmpty() && (class_19372 = player.method_37908()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (player.field_6012 % 100 == 0) {
                ESPlatform.INSTANCE.sendToAllClients(serverLevel, new ParticlePacket(OrbitalTrailParticleOptions.magic(player), player.method_23317(), player.method_23318() - 1.0, player.method_23321(), 0.0, 0.04, 0.0));
            }
        }
    }

    public static void applyCrestEffects(class_1657 player, Crest.Instance crest) {
        ((Crest)crest.crest().comp_349()).effects().ifPresent(effects -> effects.forEach(mobEffect -> player.method_6092(new class_1293(mobEffect.effect(), 20, mobEffect.level() + (crest.level() - 1) * mobEffect.levelAddition()))));
        ((Crest)crest.crest().comp_349()).attributeModifiers().ifPresent(modifiers -> modifiers.forEach(modifier -> {
            class_1324 instance = player.method_6127().method_45329(modifier.attribute());
            if (instance != null && !instance.method_6196(modifier.getModifierId(crest.level()))) {
                instance.method_26837(modifier.getModifier(crest.level()));
            }
        }));
    }
}

