/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_243;
import net.minecraft.class_3532;

public class ESMathUtil {
    public static float positionToPitch(class_243 start, class_243 end) {
        return ESMathUtil.positionToPitch(end.method_1020(start));
    }

    public static float positionToYaw(class_243 start, class_243 end) {
        return ESMathUtil.positionToYaw(end.method_1020(start));
    }

    public static float positionToPitch(class_243 vec3) {
        return ESMathUtil.positionToPitch(vec3.field_1352, vec3.field_1351, vec3.field_1350);
    }

    public static float positionToYaw(class_243 vec3) {
        return ESMathUtil.positionToYaw(vec3.field_1352, vec3.field_1350);
    }

    public static float positionToPitch(double diffX, double diffY, double diffZ) {
        double horizontalDist = Math.sqrt(diffX * diffX + diffZ * diffZ);
        return !(Math.abs(diffY) > (double)1.0E-5f) && !(Math.abs(horizontalDist) > (double)1.0E-5f) ? 0.0f : (float)(class_3532.method_15349((double)diffY, (double)horizontalDist) * 57.2957763671875);
    }

    public static float positionToYaw(double diffX, double diffZ) {
        return !(Math.abs(diffZ) > (double)1.0E-5f) && !(Math.abs(diffX) > (double)1.0E-5f) ? 0.0f : (float)(class_3532.method_15349((double)diffZ, (double)diffX) * 57.2957763671875);
    }

    public static class_243 rotationToPosition(float radius, float pitch, float yaw) {
        double endPosX = (double)radius * Math.cos(yaw * ((float)Math.PI / 180)) * Math.cos(pitch * ((float)Math.PI / 180));
        double endPosY = (double)radius * Math.sin(pitch * ((float)Math.PI / 180));
        double endPosZ = (double)radius * Math.sin(yaw * ((float)Math.PI / 180)) * Math.cos(pitch * ((float)Math.PI / 180));
        return new class_243(endPosX, endPosY, endPosZ);
    }

    public static class_243 rotationToPosition(class_243 startPos, float radius, float pitch, float yaw) {
        return startPos.method_1019(ESMathUtil.rotationToPosition(radius, pitch, yaw));
    }

    public static class_243 lerpVec(float progress, class_243 from, class_243 to) {
        return new class_243(class_3532.method_16436((double)progress, (double)from.field_1352, (double)to.field_1352), class_3532.method_16436((double)progress, (double)from.field_1351, (double)to.field_1351), class_3532.method_16436((double)progress, (double)from.field_1350, (double)to.field_1350));
    }

    public static class_243 approachVec(class_243 from, class_243 to, float speed) {
        return new class_243((double)class_3532.method_15348((float)((float)from.field_1352), (float)((float)to.field_1352), (float)speed), (double)class_3532.method_15348((float)((float)from.field_1351), (float)((float)to.field_1351), (float)speed), (double)class_3532.method_15348((float)((float)from.field_1350), (float)((float)to.field_1350), (float)speed));
    }

    public static boolean isPointInEllipsoid(double x, double y, double z, double a, double b, double c) {
        double value = x * x / (a * a) + y * y / (b * b) + z * z / (c * c);
        return value <= 1.0;
    }

    public static List<int[]> getBresenham3DPoints(int x1, int y1, int z1, int x2, int y2, int z2) {
        ArrayList<int[]> points = new ArrayList<int[]>();
        points.add(new int[]{x1, y1, z1});
        int dx = Math.abs(x2 - x1);
        int dy = Math.abs(y2 - y1);
        int dz = Math.abs(z2 - z1);
        int xs = x2 > x1 ? 1 : -1;
        int ys = y2 > y1 ? 1 : -1;
        int zs = z2 > z1 ? 1 : -1;
        if (dx >= dy && dx >= dz) {
            int p1 = 2 * dy - dx;
            int p2 = 2 * dz - dx;
            while (x1 != x2) {
                x1 += xs;
                if (p1 >= 0) {
                    y1 += ys;
                    p1 -= 2 * dx;
                }
                if (p2 >= 0) {
                    z1 += zs;
                    p2 -= 2 * dx;
                }
                p1 += 2 * dy;
                p2 += 2 * dz;
                points.add(new int[]{x1, y1, z1});
            }
        } else if (dy >= dx && dy >= dz) {
            int p1 = 2 * dx - dy;
            int p2 = 2 * dz - dy;
            while (y1 != y2) {
                y1 += ys;
                if (p1 >= 0) {
                    x1 += xs;
                    p1 -= 2 * dy;
                }
                if (p2 >= 0) {
                    z1 += zs;
                    p2 -= 2 * dy;
                }
                p1 += 2 * dx;
                p2 += 2 * dz;
                points.add(new int[]{x1, y1, z1});
            }
        } else {
            int p1 = 2 * dy - dz;
            int p2 = 2 * dx - dz;
            while (z1 != z2) {
                z1 += zs;
                if (p1 >= 0) {
                    y1 += ys;
                    p1 -= 2 * dz;
                }
                if (p2 >= 0) {
                    x1 += xs;
                    p2 -= 2 * dz;
                }
                p1 += 2 * dy;
                p2 += 2 * dx;
                points.add(new int[]{x1, y1, z1});
            }
        }
        return points;
    }

    public static double distBetweenLineAndDot(class_243 start, class_243 end, class_243 point) {
        return ESMathUtil.distBetweenLineAndDot(start.field_1352, start.field_1351, start.field_1350, end.field_1352, end.field_1351, end.field_1350, point.field_1352, point.field_1351, point.field_1350);
    }

    public static double distBetweenLineAndDot(double x1, double y1, double z1, double x2, double y2, double z2, double px, double py, double pz) {
        return Math.sqrt(ESMathUtil.distSqrBetweenLineAndDot(x1, y1, z1, x2, y2, z2, px, py, pz));
    }

    public static double distSqrBetweenLineAndDot(class_243 start, class_243 end, class_243 point) {
        return ESMathUtil.distSqrBetweenLineAndDot(start.field_1352, start.field_1351, start.field_1350, end.field_1352, end.field_1351, end.field_1350, point.field_1352, point.field_1351, point.field_1350);
    }

    public static double distSqrBetweenLineAndDot(double x1, double y1, double z1, double x2, double y2, double z2, double px, double py, double pz) {
        double closestZ;
        double closestY;
        double closestX;
        double a = px - x1;
        double d = x2 - x1;
        double b = py - y1;
        double e = y2 - y1;
        double c = pz - z1;
        double f = z2 - z1;
        double dot = a * d + b * e + c * f;
        double lenSq = d * d + e * e + f * f;
        double param = dot / lenSq;
        if (param < 0.0) {
            closestX = x1;
            closestY = y1;
            closestZ = z1;
        } else if (param > 1.0) {
            closestX = x2;
            closestY = y2;
            closestZ = z2;
        } else {
            closestX = x1 + param * d;
            closestY = y1 + param * e;
            closestZ = z1 + param * f;
        }
        double dx = px - closestX;
        double dy = py - closestY;
        double dz = pz - closestZ;
        return dx * dx + dy * dy + dz * dz;
    }

    public static double distBetweenLines(class_243 start1, class_243 end1, class_243 start2, class_243 end2) {
        return ESMathUtil.distBetweenLines(start1.field_1352, start1.field_1351, start1.field_1350, end1.field_1352, end1.field_1351, end1.field_1350, start2.field_1352, start2.field_1351, start2.field_1350, end2.field_1352, end2.field_1351, end2.field_1350);
    }

    public static double distBetweenLines(double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3, double x4, double y4, double z4) {
        return Math.sqrt(ESMathUtil.distSqrBetweenLines(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4));
    }

    public static double distSqrBetweenLines(class_243 start1, class_243 end1, class_243 start2, class_243 end2) {
        return ESMathUtil.distSqrBetweenLines(start1.field_1352, start1.field_1351, start1.field_1350, end1.field_1352, end1.field_1351, end1.field_1350, start2.field_1352, start2.field_1351, start2.field_1350, end2.field_1352, end2.field_1351, end2.field_1350);
    }

    public static double distSqrBetweenLines(double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3, double x4, double y4, double z4) {
        double tn;
        double sn;
        double dt;
        double ux = x2 - x1;
        double uy = y2 - y1;
        double uz = z2 - z1;
        double vx = x4 - x3;
        double vy = y4 - y3;
        double vz = z4 - z3;
        double wx = x1 - x3;
        double wy = y1 - y3;
        double wz = z1 - z3;
        double a = ux * ux + uy * uy + uz * uz;
        double b = ux * vx + uy * vy + uz * vz;
        double c = vx * vx + vy * vy + vz * vz;
        double d = ux * wx + uy * wy + uz * wz;
        double e = vx * wx + vy * wy + vz * wz;
        double sd = dt = a * c - b * b;
        double td = dt;
        if (Math.abs(dt) < 1.0E-7) {
            sn = 0.0;
            sd = 1.0;
            tn = e;
            td = c;
        } else {
            sn = b * e - c * d;
            tn = a * e - b * d;
            if (sn < 0.0) {
                sn = 0.0;
                tn = e;
                td = c;
            } else if (sn > sd) {
                sn = sd;
                tn = e + b;
                td = c;
            }
        }
        if (tn < 0.0) {
            tn = 0.0;
            if (-d < 0.0) {
                sn = 0.0;
            } else if (-d > a) {
                sn = sd;
            } else {
                sn = -d;
                sd = a;
            }
        } else if (tn > td) {
            tn = td;
            if (-d + b < 0.0) {
                sn = 0.0;
            } else if (-d + b > a) {
                sn = sd;
            } else {
                sn = -d + b;
                sd = a;
            }
        }
        double sc = Math.abs(sn) < 1.0E-7 ? 0.0 : sn / sd;
        double tc = Math.abs(tn) < 1.0E-7 ? 0.0 : tn / td;
        double dx = wx + sc * ux - tc * vx;
        double dy = wy + sc * uy - tc * vy;
        double dz = wz + sc * uz - tc * vz;
        return dx * dx + dy * dy + dz * dz;
    }
}

