/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.util;

import java.util.Arrays;
import java.util.List;
import net.minecraft.class_156;
import net.minecraft.class_5819;

public class MazeGenerator {
    private final int size;
    private final boolean[][] maze;
    private class_5819 random;

    public MazeGenerator(int size, class_5819 random) {
        this.size = size;
        this.maze = new boolean[size][size];
        this.random = random;
    }

    public void setRandom(class_5819 random) {
        this.random = random;
    }

    public boolean[][] generateMaze(int startX, int startY) {
        for (int i = 0; i < this.size; ++i) {
            Arrays.fill(this.maze[i], true);
        }
        this.generate(startX, startY);
        return this.maze;
    }

    private void generate(int x, int y) {
        this.maze[x][y] = false;
        List<Integer> directions = Arrays.asList(0, 1, 2, 3);
        class_156.method_43028(directions, (class_5819)this.random);
        for (int direction : directions) {
            int dy;
            int dx = x + 2 * this.getDX(direction);
            if (!this.isInRange(dx, dy = y + 2 * this.getDY(direction)) || !this.maze[dx][dy]) continue;
            this.maze[x + this.getDX((int)direction)][y + this.getDY((int)direction)] = false;
            this.generate(dx, dy);
        }
    }

    private boolean isInRange(int x, int y) {
        return x >= 0 && x < this.size && y >= 0 && y < this.size;
    }

    private int getDX(int direction) {
        if (direction == 1) {
            return -1;
        }
        if (direction == 3) {
            return 1;
        }
        return 0;
    }

    private int getDY(int direction) {
        if (direction == 0) {
            return -1;
        }
        if (direction == 2) {
            return 1;
        }
        return 0;
    }
}

