/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.misc.maptrades;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.misc.maptrades.StructureMapCollectionObj;
import com.telepathicgrunt.repurposedstructures.misc.maptrades.VillagerMapObj;
import com.telepathicgrunt.repurposedstructures.misc.maptrades.WanderingTraderMapObj;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;

public class StructureMapManager
extends class_4309 {
    public static final StructureMapManager STRUCTURE_MAP_MANAGER = new StructureMapManager();
    public Map<String, List<VillagerMapObj>> VILLAGER_MAP_TRADES = new HashMap<String, List<VillagerMapObj>>();
    public Map<WanderingTraderMapObj.TRADE_TYPE, List<WanderingTraderMapObj>> WANDERING_TRADER_MAP_TRADES = new HashMap<WanderingTraderMapObj.TRADE_TYPE, List<WanderingTraderMapObj>>();

    public StructureMapManager() {
        super(RepurposedStructures.GSON, "structure_map_trades");
    }

    protected void apply(Map<class_2960, JsonElement> loader, class_3300 manager, class_3695 profiler) {
        ImmutableMap.Builder builderVillager = ImmutableMap.builder();
        ImmutableMap.Builder builderWandering = ImmutableMap.builder();
        loader.forEach((fileIdentifier, jsonElement) -> {
            try {
                StructureMapCollectionObj spawnerMobEntries = (StructureMapCollectionObj)RepurposedStructures.GSON.fromJson(jsonElement, StructureMapCollectionObj.class);
                builderVillager.putAll(spawnerMobEntries.villagerMaps);
                builderWandering.putAll(spawnerMobEntries.wanderingTraderMap);
            }
            catch (Exception e) {
                RepurposedStructures.LOGGER.error("Repurposed Structures Error: Couldn't parse structure map file {}", fileIdentifier, (Object)e);
            }
        });
        this.VILLAGER_MAP_TRADES = builderVillager.build();
        this.WANDERING_TRADER_MAP_TRADES = builderWandering.build();
    }
}

