/*
 * Decompiled with CFR 0.152.
 */
package me.ryleu.armornerf;

import java.util.HashMap;
import me.ryleu.armornerf.ArmorFormula;
import me.ryleu.armornerf.ArmorNerfConfig;
import me.ryleu.armornerf.formula.CrumblingArmorFormula;
import me.ryleu.armornerf.formula.DebugFormula;
import me.ryleu.armornerf.formula.FlatToughnessFormula;
import me.ryleu.armornerf.formula.LargeToughnessFormula;
import me.ryleu.armornerf.formula.ToughnessDisabledFormula;
import me.ryleu.armornerf.formula.VanillaFormula;
import net.fabricmc.api.ModInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArmorNerf
implements ModInitializer {
    public static final String MOD_ID = "armor-nerf";
    public static final ArmorNerfConfig CONFIG = ArmorNerfConfig.createAndLoad();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"armor-nerf");
    private static ArmorFormula armorFormula = new VanillaFormula();
    private static HashMap<String, ArmorFormula> formulaRegistry;

    public static ArmorFormula getArmorFormula() {
        return armorFormula;
    }

    public static boolean isRegistered(String id) {
        return formulaRegistry == null || formulaRegistry.containsKey(id);
    }

    public static void registerFormula(String id, ArmorFormula formula) {
        formulaRegistry.put(id, formula);
    }

    public void onInitialize() {
        formulaRegistry = new HashMap();
        ArmorNerf.registerFormula("vanilla", new VanillaFormula());
        ArmorNerf.registerFormula("toughness_disabled", new ToughnessDisabledFormula());
        ArmorNerf.registerFormula("flat_toughness", new FlatToughnessFormula());
        ArmorNerf.registerFormula("large_toughness", new LargeToughnessFormula());
        ArmorNerf.registerFormula("crumbling_armor", new CrumblingArmorFormula());
        ArmorNerf.registerFormula("debug", new DebugFormula());
        this.setArmorFormula(CONFIG.armorFormula());
        CONFIG.subscribeToArmorFormula(this::setArmorFormula);
    }

    private void setArmorFormula(String newFormulaId) {
        ArmorFormula newFormula = formulaRegistry.get(newFormulaId);
        if (newFormula == null) {
            CONFIG.armorFormula("toughness_disabled");
        } else {
            LOGGER.info("Set formula to {}", (Object)newFormulaId);
            armorFormula = newFormula;
        }
    }
}

