/*
 * Decompiled with CFR 0.152.
 */
package draylar.inmis;

import draylar.inmis.api.TrinketCompat;
import draylar.inmis.config.BackpackInfo;
import draylar.inmis.config.InmisClothConfig;
import draylar.inmis.item.BackpackItem;
import draylar.inmis.item.EnderBackpackItem;
import draylar.inmis.item.component.BackpackComponent;
import draylar.inmis.mixin.trinkets.TrinketsMixinPlugin;
import draylar.inmis.network.ServerNetworking;
import draylar.inmis.network.packet.BackpackScreenPacket;
import draylar.inmis.ui.BackpackScreenHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.UnaryOperator;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1304;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9331;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class Inmis
implements ModInitializer {
    public static final boolean TRINKETS_LOADED = FabricLoader.getInstance().isModLoaded("trinkets");
    public static final Logger LOGGER = LogManager.getLogger();
    public static final class_2960 CONTAINER_ID = Inmis.id("backpack");
    public static final class_5321<class_1761> GROUP = class_5321.method_29179((class_5321)class_7924.field_44688, (class_2960)CONTAINER_ID);
    public static InmisClothConfig CONFIG = new InmisClothConfig();
    public static final class_3917<BackpackScreenHandler> BACKPACK_SCREEN_HANDLER = new ExtendedScreenHandlerType(BackpackScreenHandler::new, BackpackScreenPacket.PACKET_CODEC);
    public static final List<BackpackItem> BACKPACKS = new ArrayList<BackpackItem>();
    public static final class_1792 ENDER_POUCH = (class_1792)class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)Inmis.id("ender_pouch"), (Object)((Object)new EnderBackpackItem()));
    public static final class_9331<BackpackComponent> BACKPACK_COMPONENT = Inmis.registerComponent("backpack", builder -> builder.method_57881(BackpackComponent.CODEC).method_57882(BackpackComponent.PACKET_CODEC));

    public void onInitialize() {
        this.registerBackpacks();
        ServerNetworking.init();
        this.setupTrinkets();
    }

    private void registerBackpacks() {
        class_2378.method_39197((class_2378)class_7923.field_44687, GROUP, (Object)FabricItemGroup.builder().method_47320(() -> new class_1799((class_1935)class_7923.field_41178.method_10223(Inmis.id("frayed_backpack")))).method_47321((class_2561)class_2561.method_43471((String)"itemGroup.inmis.backpack")).method_47324());
        AutoConfig.register(InmisClothConfig.class, JanksonConfigSerializer::new);
        CONFIG = (InmisClothConfig)AutoConfig.getConfigHolder(InmisClothConfig.class).getConfig();
        for (BackpackInfo backpack : Inmis.CONFIG.backpacks) {
            class_1792.class_1793 settings = new class_1792.class_1793().method_7889(1);
            if (Inmis.CONFIG.allowBackpacksInChestplate) {
                settings.equipmentSlot((entity, stack) -> class_1304.field_6174);
            }
            if (backpack.isFireImmune()) {
                settings.method_24359();
            }
            if (backpack.getOpenSound() == null) {
                Optional<BackpackInfo> any = Inmis.CONFIG.backpacks.stream().filter(info -> info.getName().equals(backpack.getName())).findAny();
                any.ifPresent(backpackInfo -> backpack.setOpenSound(backpackInfo.getOpenSound()));
                if (backpack.getOpenSound() == null) {
                    LOGGER.info(String.format("Could not find a sound event for %s in inmis.json config.", backpack.getName()));
                    LOGGER.info("Consider regenerating your config, or assigning the openSound value. Rolling with defaults for now.");
                    backpack.setOpenSound("minecraft:item.armor.equip_leather");
                }
            }
            BackpackItem item = TRINKETS_LOADED && Inmis.CONFIG.enableTrinketCompatibility ? TrinketCompat.createTrinketBackpack(backpack, settings) : new BackpackItem(backpack, settings);
            BackpackItem registered = (BackpackItem)((Object)class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)class_2960.method_60655((String)"inmis", (String)(backpack.getName().toLowerCase() + "_backpack")), (Object)((Object)item)));
            BACKPACKS.add(registered);
            ItemGroupEvents.modifyEntriesEvent(GROUP).register(entries -> entries.method_45421((class_1935)registered));
            if (!TRINKETS_LOADED || !Inmis.CONFIG.enableTrinketCompatibility) continue;
            TrinketCompat.registerTrinketBackpack(item);
        }
        ItemGroupEvents.modifyEntriesEvent(GROUP).register(entries -> entries.method_45421((class_1935)ENDER_POUCH));
        class_2378.method_10226((class_2378)class_7923.field_41187, (String)"inmis:backpack", BACKPACK_SCREEN_HANDLER);
    }

    private void setupTrinkets() {
        if (TrinketsMixinPlugin.isTrinketsLoaded && Inmis.CONFIG.enableTrinketCompatibility) {
            TrinketCompat.registerTrinketPredicate();
        }
    }

    private static <T> class_9331<T> registerComponent(String id, UnaryOperator<class_9331.class_9332<T>> builderOperator) {
        return (class_9331)class_2378.method_10226((class_2378)class_7923.field_49658, (String)id, (Object)((class_9331.class_9332)builderOperator.apply(class_9331.method_57873())).method_57880());
    }

    public static boolean isBackpackEmpty(class_1799 stack) {
        return stack.method_57824(BACKPACK_COMPONENT) == null || ((BackpackComponent)stack.method_57824(BACKPACK_COMPONENT)).getSimpleInventory().method_5442();
    }

    @Nullable
    public static List<class_1799> getBackpackContents(class_1799 stack) {
        if (stack.method_57824(BACKPACK_COMPONENT) != null) {
            return ((BackpackComponent)stack.method_57824(BACKPACK_COMPONENT)).getSimpleInventory().method_54454();
        }
        return null;
    }

    public static void wipeBackpack(class_1799 stack) {
        if (stack.method_57824(BACKPACK_COMPONENT) != null) {
            ((BackpackComponent)stack.method_57824(BACKPACK_COMPONENT)).getSimpleInventory().method_5448();
        }
    }

    public static class_2960 id(String name) {
        return class_2960.method_60655((String)"inmis", (String)name);
    }
}

