/*
 * Decompiled with CFR 0.152.
 */
package com.axalotl.async;

import com.axalotl.async.Async;
import com.axalotl.async.config.AsyncConfig;
import com.axalotl.async.parallelised.ConcurrentCollections;
import java.util.ArrayList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1540;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1688;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ParallelProcessor {
    private static final Logger LOGGER = LogManager.getLogger(ParallelProcessor.class);
    private static MinecraftServer server;
    public static final AtomicInteger currentEntities;
    private static final AtomicInteger threadPoolID;
    private static ExecutorService tickPool;
    private static final Queue<CompletableFuture<Void>> taskQueue;
    private static final Set<UUID> blacklistedEntity;
    private static final Map<String, Set<Thread>> mcThreadTracker;
    private static final Set<Class<?>> specialEntities;

    public static void setupThreadPool(int parallelism) {
        ForkJoinPool.ForkJoinWorkerThreadFactory threadFactory = pool -> {
            ForkJoinWorkerThread worker = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
            worker.setName("Async-Tick-Pool-Thread-" + threadPoolID.getAndIncrement());
            ParallelProcessor.registerThread("Async-Tick", worker);
            worker.setDaemon(true);
            worker.setPriority(5);
            worker.setContextClassLoader(Async.class.getClassLoader());
            return worker;
        };
        tickPool = new ForkJoinPool(parallelism, threadFactory, (t, e) -> LOGGER.error("Uncaught exception in thread {}: {}", (Object)t.getName(), (Object)e), true);
        LOGGER.info("Initialized Pool with {} threads", (Object)parallelism);
    }

    public static void registerThread(String poolName, Thread thread) {
        mcThreadTracker.computeIfAbsent(poolName, key -> ConcurrentHashMap.newKeySet()).add(thread);
    }

    private static boolean isThreadInPool(Thread thread) {
        return mcThreadTracker.getOrDefault("Async-Tick", Set.of()).contains(thread);
    }

    public static boolean isServerExecutionThread() {
        return ParallelProcessor.isThreadInPool(Thread.currentThread());
    }

    public static void callEntityTick(Consumer<class_1297> tickConsumer, class_1297 entity) {
        if (ParallelProcessor.shouldTickSynchronously(entity)) {
            ParallelProcessor.tickSynchronously(tickConsumer, entity);
        } else if (!tickPool.isShutdown() && !tickPool.isTerminated()) {
            CompletionStage future = CompletableFuture.runAsync(() -> ParallelProcessor.performAsyncEntityTick(tickConsumer, entity), tickPool).exceptionally(e -> {
                ParallelProcessor.logEntityError("Error in async tick, switching to synchronous", entity, e);
                ParallelProcessor.tickSynchronously(tickConsumer, entity);
                blacklistedEntity.add(entity.method_5667());
                return null;
            });
            taskQueue.add((CompletableFuture<Void>)future);
        } else {
            ParallelProcessor.logEntityError("Rejected task due to ExecutorService shutdown", entity, null);
            ParallelProcessor.tickSynchronously(tickConsumer, entity);
        }
    }

    public static boolean shouldTickSynchronously(class_1297 entity) {
        return AsyncConfig.disabled || entity instanceof class_1676 || entity instanceof class_1688 || specialEntities.contains(entity.getClass()) || blacklistedEntity.contains(entity.method_5667()) || AsyncConfig.synchronizedEntities.contains(class_1299.method_5890((class_1299)entity.method_5864())) || ParallelProcessor.isPortalTickRequired(entity) || entity.method_5817();
    }

    private static boolean isPortalTickRequired(class_1297 entity) {
        return entity.field_51994 != null && entity.field_51994.method_60709();
    }

    private static void tickSynchronously(Consumer<class_1297> tickConsumer, class_1297 entity) {
        try {
            tickConsumer.accept(entity);
        }
        catch (Exception e) {
            ParallelProcessor.logEntityError("Error during synchronous tick", entity, e);
        }
    }

    private static void performAsyncEntityTick(Consumer<class_1297> tickConsumer, class_1297 entity) {
        currentEntities.incrementAndGet();
        try {
            tickConsumer.accept(entity);
        }
        finally {
            currentEntities.decrementAndGet();
        }
    }

    public static void postEntityTick() {
        if (!AsyncConfig.disabled) {
            try {
                ArrayList<CompletableFuture<Void>> futuresList = new ArrayList<CompletableFuture<Void>>(taskQueue);
                taskQueue.clear();
                if (futuresList.isEmpty()) {
                    return;
                }
                CompletableFuture<Void> allTasks = CompletableFuture.allOf(futuresList.toArray(new CompletableFuture[0]));
                allTasks.orTimeout(120L, TimeUnit.SECONDS).exceptionally(ex -> {
                    LOGGER.error("Timeout during entity tick processing", ex);
                    server.method_3782();
                    return null;
                });
                server.method_3738().forEach(world -> {
                    world.method_14178().method_19492();
                    world.method_14178().field_18809.method_18857(allTasks::isDone);
                });
            }
            catch (CompletionException e) {
                LOGGER.error("Critical error during entity tick processing", (Throwable)e);
                server.method_3782();
            }
        }
    }

    public static void stop() {
        if (tickPool != null && !tickPool.isShutdown()) {
            tickPool.shutdown();
            try {
                if (!tickPool.awaitTermination(10L, TimeUnit.SECONDS)) {
                    tickPool.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                tickPool.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    private static void logEntityError(String message, class_1297 entity, Throwable e) {
        LOGGER.error("{} Entity Type: {}, UUID: {}", (Object)message, (Object)entity.method_5864().method_5897(), (Object)entity.method_5667(), (Object)e);
    }

    public static MinecraftServer getServer() {
        return server;
    }

    public static void setServer(MinecraftServer server) {
        ParallelProcessor.server = server;
    }

    static {
        currentEntities = new AtomicInteger();
        threadPoolID = new AtomicInteger();
        taskQueue = new ConcurrentLinkedQueue<CompletableFuture<Void>>();
        blacklistedEntity = ConcurrentHashMap.newKeySet();
        mcThreadTracker = ConcurrentCollections.newHashMap();
        specialEntities = Set.of(class_1540.class, class_1657.class, class_3222.class);
    }
}

