/*
 * Decompiled with CFR 0.152.
 */
package com.axalotl.async.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncConfig {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Async Config");
    private static final Supplier<CommentedFileConfig> configSupplier = () -> (CommentedFileConfig)CommentedFileConfig.builder((Path)FabricLoader.getInstance().getConfigDir().resolve("async.toml")).preserveInsertionOrder().sync().build();
    private static CommentedFileConfig CONFIG;
    public static boolean disabled;
    public static int paraMax;
    public static boolean enableEntityMoveSync;
    public static Set<class_2960> synchronizedEntities;

    public static void init() {
        LOGGER.info("Initializing Async Config...");
        CONFIG = configSupplier.get();
        try {
            if (!CONFIG.getFile().exists()) {
                LOGGER.warn("Configuration file not found, creating default configuration.");
                AsyncConfig.setDefaultValues();
                AsyncConfig.saveConfig();
            } else {
                CONFIG.load();
                AsyncConfig.loadConfigValues();
                AsyncConfig.saveConfig();
                LOGGER.info("Configuration successfully loaded.");
            }
        }
        catch (Throwable t) {
            LOGGER.error("Error loading configuration, resetting to default values.", t);
            AsyncConfig.setDefaultValues();
            AsyncConfig.saveConfig();
        }
    }

    public static void saveConfig() {
        CONFIG.set("disabled", (Object)disabled);
        CONFIG.setComment("disabled", "Globally disable all toggleable functionality within the async system. Set to true to stop all asynchronous operations.");
        CONFIG.set("paraMax", (Object)paraMax);
        CONFIG.setComment("paraMax", "Maximum number of threads to use for parallel processing. Set to -1 to use default value. Note: If 'virtualThreads' is enabled, this setting will be ignored.");
        CONFIG.set("enableEntityMoveSync", (Object)enableEntityMoveSync);
        CONFIG.setComment("enableEntityMoveSync", "Modifies entity movement processing: true for synchronous movement (vanilla mechanics intact, less performance), false for asynchronous movement (better performance, may break mechanics).");
        CONFIG.set("synchronizedEntities", synchronizedEntities.stream().map(class_2960::toString).toList());
        CONFIG.setComment("synchronizedEntities", "List of entity class for sync processing.");
        CONFIG.save();
        LOGGER.info("Configuration saved successfully.");
    }

    private static void loadConfigValues() {
        HashSet<String> processedKeys = new HashSet<String>(List.of("disabled", "paraMax", "enableEntityMoveSync", "synchronizedEntities"));
        disabled = (Boolean)CONFIG.getOrElse("disabled", (Object)false);
        paraMax = (Integer)CONFIG.getOrElse("paraMax", (Object)-1);
        enableEntityMoveSync = (Boolean)CONFIG.getOrElse("enableEntityMoveSync", (Object)false);
        synchronizedEntities = new HashSet<class_2960>();
        CONFIG.getOptional("synchronizedEntities").ifPresentOrElse(ids -> {
            for (String id : ids) {
                class_2960 identifier = class_2960.method_12829((String)id);
                if (identifier == null) continue;
                synchronizedEntities.add(identifier);
            }
        }, () -> {
            synchronizedEntities = new HashSet<class_2960>(Set.of(class_2960.method_60656((String)"tnt"), class_2960.method_60656((String)"item"), class_2960.method_60656((String)"experience_orb")));
        });
        HashSet<String> keysToRemove = new HashSet<String>();
        for (CommentedConfig.Entry entry : CONFIG.entrySet()) {
            String key = entry.getKey();
            if (processedKeys.contains(key)) continue;
            keysToRemove.add(key);
        }
        for (String key : keysToRemove) {
            LOGGER.warn("Removing unused configuration key: {}", (Object)key);
            CONFIG.remove(key);
        }
        CONFIG.save();
    }

    private static void setDefaultValues() {
        disabled = false;
        paraMax = -1;
        enableEntityMoveSync = false;
        synchronizedEntities = new HashSet<class_2960>(Set.of(class_2960.method_60656((String)"tnt"), class_2960.method_60656((String)"item"), class_2960.method_60656((String)"experience_orb")));
    }

    public static int getParallelism() {
        if (paraMax <= 0) {
            return Runtime.getRuntime().availableProcessors();
        }
        return Math.max(1, Math.min(Runtime.getRuntime().availableProcessors(), paraMax));
    }

    public static void syncEntity(class_2960 entityId) {
        if (synchronizedEntities.add(entityId)) {
            AsyncConfig.saveConfig();
            LOGGER.info("Sync entity class: {}", (Object)entityId);
        } else {
            LOGGER.warn("Entity class already synchronized: {}", (Object)entityId);
        }
    }

    public static void asyncEntity(class_2960 entityId) {
        if (synchronizedEntities.remove(entityId)) {
            AsyncConfig.saveConfig();
            LOGGER.info("Enable async process entity class: {}", (Object)entityId);
        } else {
            LOGGER.warn("Entity class not found: {}", (Object)entityId);
        }
    }

    static {
        disabled = false;
        paraMax = -1;
        enableEntityMoveSync = false;
        synchronizedEntities = new HashSet<class_2960>(Set.of(class_2960.method_60656((String)"tnt"), class_2960.method_60656((String)"item"), class_2960.method_60656((String)"experience_orb")));
    }
}

