/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.utils;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.teamresourceful.resourcefulconfig.api.types.ResourcefulConfig;
import com.teamresourceful.resourcefulconfig.api.types.ResourcefulConfigButton;
import com.teamresourceful.resourcefulconfig.api.types.entries.ResourcefulConfigEntry;
import com.teamresourceful.resourcefulconfig.api.types.options.Option;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import net.minecraft.class_2561;

public class ConfigSearching {
    private static final BiMap<String, String> ALIASES = HashBiMap.create();
    private static final Cache<String, List<String>> CACHE = CacheBuilder.newBuilder().maximumSize(300L).build();
    private static String search = "";

    public static boolean setSearch(String search) {
        if ((search = search.trim().toLowerCase(Locale.ROOT)).equals(ConfigSearching.search)) {
            return false;
        }
        ConfigSearching.search = search;
        return true;
    }

    public static String getSearch() {
        return search;
    }

    private static List<String> getAdditionalTerms(String text) {
        List cached = (List)CACHE.getIfPresent((Object)text);
        if (cached != null) {
            return cached;
        }
        ArrayList<String> terms = new ArrayList<String>();
        for (String s : text.split(" ")) {
            if (ALIASES.containsKey((Object)s)) {
                terms.add((String)ALIASES.get((Object)s));
            }
            if (!ALIASES.containsValue((Object)s)) continue;
            terms.add((String)ALIASES.inverse().get((Object)s));
        }
        CACHE.put((Object)text, terms);
        return terms;
    }

    private static boolean fulfillsSearch(String text, Function<String, List<String>> termCollector) {
        if ((text = text.trim().toLowerCase(Locale.ROOT)).contains(search)) {
            return true;
        }
        for (String term : termCollector.apply(text)) {
            if (!term.contains(search)) continue;
            return true;
        }
        for (String term : ConfigSearching.getAdditionalTerms(text)) {
            if (!term.contains(search)) continue;
            return true;
        }
        return false;
    }

    public static boolean fulfillsSearch(ResourcefulConfig config, Function<String, List<String>> termCollector) {
        if (search.isBlank()) {
            return true;
        }
        for (ResourcefulConfigButton button : config.buttons()) {
            if (!ConfigSearching.fulfillsSearch(button, termCollector)) continue;
            return true;
        }
        for (ResourcefulConfigEntry entry : config.entries().values()) {
            if (!ConfigSearching.fulfillsSearch(entry, termCollector)) continue;
            return true;
        }
        for (ResourcefulConfig category : config.categories().values()) {
            if (!ConfigSearching.fulfillsSearch(category, termCollector)) continue;
            return true;
        }
        String title = config.info().title().toLocalizedString();
        String description = config.info().description().toLocalizedString();
        return ConfigSearching.fulfillsSearch(title, termCollector) || ConfigSearching.fulfillsSearch(description, termCollector);
    }

    public static boolean fulfillsSearch(ResourcefulConfigButton button, Function<String, List<String>> termCollector) {
        if (search.isBlank()) {
            return true;
        }
        String title = class_2561.method_43471((String)button.title()).getString();
        String description = class_2561.method_43471((String)button.description()).getString();
        String text = class_2561.method_43471((String)button.text()).getString();
        return ConfigSearching.fulfillsSearch(title, termCollector) || ConfigSearching.fulfillsSearch(description, termCollector) || ConfigSearching.fulfillsSearch(text, termCollector);
    }

    public static boolean fulfillsSearch(ResourcefulConfigEntry entry, Function<String, List<String>> termCollector) {
        if (search.isBlank()) {
            return true;
        }
        String title = entry.options().title().toLocalizedString();
        String description = entry.options().comment().toLocalizedString();
        for (String term : entry.options().getOrDefaultOption(Option.SEARCH_TERM, List.of())) {
            if (!ConfigSearching.fulfillsSearch(term, termCollector)) continue;
            return true;
        }
        return ConfigSearching.fulfillsSearch(title, termCollector) || ConfigSearching.fulfillsSearch(description, termCollector);
    }

    static {
        ALIASES.put((Object)"color", (Object)"colour");
        ALIASES.put((Object)"gray", (Object)"grey");
        ALIASES.put((Object)"center", (Object)"centre");
        ALIASES.put((Object)"favorite", (Object)"favourite");
        ALIASES.put((Object)"armor", (Object)"armour");
    }
}

