/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum;

import dev.toma.configuration.Configuration;
import dev.toma.configuration.config.format.ConfigFormats;
import dev.toma.configuration.config.format.IConfigFormatHandler;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import team.tnt.collectorsalbum.common.Album;
import team.tnt.collectorsalbum.common.AlbumLocatorResult;
import team.tnt.collectorsalbum.common.PlayerAlbumTracker;
import team.tnt.collectorsalbum.config.CollectorsAlbumConfig;
import team.tnt.collectorsalbum.integrations.PlatformIntegrations;
import team.tnt.collectorsalbum.network.NetworkManager;
import team.tnt.collectorsalbum.network.S2C_SendDatapackResources;
import team.tnt.collectorsalbum.platform.network.PlatformNetworkManager;

public class CollectorsAlbum {
    public static final String MOD_ID = "collectorsalbum";
    public static final Logger LOGGER = LogManager.getLogger((String)"CollectorsAlbum");
    public static final PlatformNetworkManager NETWORK_MANAGER = PlatformNetworkManager.create("collectorsalbum");
    private static CollectorsAlbumConfig config;

    public static void init() {
        config = (CollectorsAlbumConfig)Configuration.registerConfig(CollectorsAlbumConfig.class, (IConfigFormatHandler)ConfigFormats.YAML).getConfigInstance();
        CollectorsAlbum.registerPackets();
        PlatformIntegrations.registerAlbumFinders();
    }

    public static CollectorsAlbumConfig getConfig() {
        return config;
    }

    public static void tickPlayer(class_1657 player) {
        class_1937 level = player.method_37908();
        long time = level.method_8510();
        if (level.method_8608() || time % 100L != 0L) {
            return;
        }
        CollectorsAlbum.actuallyTickPlayer(player);
    }

    public static void forceAlbumReload(class_1657 player) {
        if (!player.method_37908().method_8608()) {
            CollectorsAlbum.actuallyTickPlayer(player);
        }
    }

    private static void actuallyTickPlayer(class_1657 player) {
        PlayerAlbumTracker tracker = PlayerAlbumTracker.get();
        Album album = tracker.getAlbum(player).orElse(null);
        if (album == null) {
            AlbumLocatorResult result = tracker.findAlbum(player, null);
            if (!result.exists()) {
                return;
            }
            album = result.getAlbum();
            tracker.cacheAlbum(player, album);
        } else {
            AlbumLocatorResult result = tracker.findAlbum(player, album);
            if (!result.exists() || !result.getAlbum().test(album)) {
                tracker.deleteCachedAlbum(player.method_5667());
                album.removed(player);
                if (result.getAlbum() != null) {
                    tracker.cacheAlbum(player, result.getAlbum());
                    result.getAlbum().tick(player);
                }
                return;
            }
        }
        album.tick(player);
    }

    public static void sendPlayerDatapacks(class_3222 player) {
        if (player != null) {
            LOGGER.debug("Sending server resources to client {}", (Object)player.method_5667());
            PlatformNetworkManager.NETWORK.sendClientMessage(player, new S2C_SendDatapackResources());
            CollectorsAlbum.forceAlbumReload((class_1657)player);
        }
    }

    public static void playerLoggedOut(class_1657 player) {
        PlayerAlbumTracker tracker = PlayerAlbumTracker.get();
        tracker.deleteCachedAlbum(player.method_5667());
    }

    public static void serverStopped() {
        PlayerAlbumTracker tracker = PlayerAlbumTracker.get();
        tracker.clearCache();
    }

    private static void registerPackets() {
        NetworkManager.init();
    }
}

