/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.client.screen;

import com.mojang.datafixers.util.Pair;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_474;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7919;
import net.minecraft.class_9331;
import team.tnt.collectorsalbum.client.screen.AlbumMainPageScreen;
import team.tnt.collectorsalbum.client.screen.AlbumNavigationHelper;
import team.tnt.collectorsalbum.client.screen.BookmarkWidget;
import team.tnt.collectorsalbum.client.screen.LabelRenderable;
import team.tnt.collectorsalbum.client.screen.LabelWidget;
import team.tnt.collectorsalbum.client.screen.TextureRenderable;
import team.tnt.collectorsalbum.common.Album;
import team.tnt.collectorsalbum.common.AlbumBonusDescriptionOutput;
import team.tnt.collectorsalbum.common.init.ItemDataComponentRegistry;
import team.tnt.collectorsalbum.common.resource.AlbumBonusManager;
import team.tnt.collectorsalbum.common.resource.bonus.AlbumBonus;
import team.tnt.collectorsalbum.common.resource.util.ActionContext;

public class AlbumBonusesScreen
extends class_437 {
    public static final class_2561 TITLE = class_2561.method_43471((String)"screen.collectorsalbum.album.bonuses").method_27692(class_124.field_1067);
    private static final int LINE_COUNT = 14;
    private final class_1799 itemStack;
    private int left;
    private int top;
    private int scrollingOffset;
    private int pageSize;
    private int currentBonusIndex;

    public AlbumBonusesScreen(class_1799 itemStack) {
        super(TITLE);
        this.itemStack = itemStack;
    }

    public void method_25432() {
        AlbumNavigationHelper.captureCurrentMousePositionSnapshot();
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25420(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.method_52752(graphics);
    }

    protected void method_25426() {
        this.left = (this.field_22789 - 256) / 2;
        this.top = (this.field_22790 - 256) / 2;
        AlbumMainPageScreen.getBookmarks(this.field_22789, this.field_22790, 256, 256, 180).forEach(x$0 -> {
            BookmarkWidget cfr_ignored_0 = (BookmarkWidget)this.method_37063((class_364)x$0);
        });
        this.method_37060(new TextureRenderable(AlbumMainPageScreen.BACKGROUND, this.left, this.top, 256, 256));
        Album album = (Album)this.itemStack.method_57824((class_9331)ItemDataComponentRegistry.ALBUM.get());
        if (album == null) {
            class_5250 error = class_2561.method_43470((String)"Failed to load album!").method_27692(class_124.field_1061);
            int n = this.left + (256 - this.field_22793.method_27525((class_5348)error)) / 2;
            Objects.requireNonNull(this.field_22793);
            this.method_37060(new LabelRenderable((class_2561)error, n, this.top + (180 - 9) / 2));
            return;
        }
        AlbumBonusManager manager = AlbumBonusManager.getInstance();
        Pair<AlbumBonus, AlbumBonus> bonusPair = manager.getBonusesForPage(this.currentBonusIndex);
        ActionContext context = ActionContext.of("player", this.field_22787.field_1724, "album", album);
        List<AlbumBonusDescriptionOutput.ComponentWithTooltip> first = this.getBonusDescription((AlbumBonus)bonusPair.getFirst(), context);
        List<AlbumBonusDescriptionOutput.ComponentWithTooltip> second = this.getBonusDescription((AlbumBonus)bonusPair.getSecond(), context);
        this.pageSize = Math.max(first.size(), second.size());
        this.createWidgets(first, this.left + 14, this.top + 14, this.scrollingOffset);
        this.createWidgets(second, this.left + 142, this.top + 14, this.scrollingOffset);
        if (this.currentBonusIndex > 0) {
            class_474 prevPage = (class_474)this.method_37063((class_364)new class_474(this.left + 22, this.top + 156, false, btn -> this.addPage(-1), true));
            prevPage.method_47400(class_7919.method_47407((class_2561)AlbumNavigationHelper.getPreviousCategoryTitle()));
            prevPage.method_47402(Duration.ofSeconds(1L));
        }
        if (manager.hasNextPage(this.currentBonusIndex)) {
            class_474 nextPage = (class_474)this.method_37063((class_364)new class_474(this.left + 210, this.top + 156, true, btn -> this.addPage(1), true));
            nextPage.method_47400(class_7919.method_47407((class_2561)AlbumNavigationHelper.getNextCategoryTitle()));
            nextPage.method_47402(Duration.ofSeconds(1L));
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        int scale = (int)(-scrollY);
        int next = this.scrollingOffset + scale;
        if (next >= 0 && next + 14 <= this.pageSize) {
            this.scrollingOffset = next;
            this.method_25423(this.field_22787, this.field_22789, this.field_22790);
            return true;
        }
        return false;
    }

    private void createWidgets(List<AlbumBonusDescriptionOutput.ComponentWithTooltip> components, int x, int y, int scroll) {
        int offsetStep = 2;
        for (int i = scroll; i < Math.min(scroll + 14, components.size()); ++i) {
            int index = i - scroll;
            AlbumBonusDescriptionOutput.ComponentWithTooltip component = components.get(i);
            int offset = offsetStep * component.level();
            class_2561 label = component.label();
            LabelWidget widget = (LabelWidget)this.method_37063((class_364)new LabelWidget(x + offset, y + index * 10, 100 - offset, 10, label, this.field_22793, 8084556, true));
            if (!component.hasTooltip()) continue;
            widget.method_47400(class_7919.method_47407((class_2561)component.tooltip()));
            widget.method_47402(Duration.ofMillis(400L));
        }
    }

    private List<AlbumBonusDescriptionOutput.ComponentWithTooltip> getBonusDescription(AlbumBonus bonus, ActionContext context) {
        AlbumBonusDescriptionOutput description = AlbumBonusDescriptionOutput.createEmpty(context);
        bonus.addDescription(description);
        return description.toComponentList();
    }

    private void addPage(int direction) {
        this.setPage(this.currentBonusIndex + direction);
    }

    private void setPage(int page) {
        this.currentBonusIndex = page;
        this.scrollingOffset = 0;
        this.method_25423(this.field_22787, this.field_22789, this.field_22790);
    }
}

