/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.client.screen;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_474;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7919;
import net.minecraft.class_9331;
import team.tnt.collectorsalbum.client.screen.AlbumBonusesScreen;
import team.tnt.collectorsalbum.client.screen.AlbumCategoryScreen;
import team.tnt.collectorsalbum.client.screen.AlbumNavigationHelper;
import team.tnt.collectorsalbum.client.screen.BookmarkWidget;
import team.tnt.collectorsalbum.client.screen.LabelRenderable;
import team.tnt.collectorsalbum.client.screen.LabelWidget;
import team.tnt.collectorsalbum.client.screen.TextureRenderable;
import team.tnt.collectorsalbum.common.Album;
import team.tnt.collectorsalbum.common.AlbumCategory;
import team.tnt.collectorsalbum.common.card.CardRarity;
import team.tnt.collectorsalbum.common.init.ItemDataComponentRegistry;
import team.tnt.collectorsalbum.common.init.ItemRegistry;
import team.tnt.collectorsalbum.common.item.AlbumItem;
import team.tnt.collectorsalbum.common.resource.AlbumCategoryManager;

public class AlbumMainPageScreen
extends class_437 {
    public static final class_2561 TITLE = class_2561.method_43471((String)"screen.collectorsalbum.album.main").method_27692(class_124.field_1067);
    public static final class_2960 BACKGROUND = class_2960.method_60655((String)"collectorsalbum", (String)"textures/ui/album.png");
    public static final int TEXT_COLOR = 8084556;
    private static final class_2561 LABEL_RARITIES = class_2561.method_43471((String)"collectorsalbum.text.statistics.rarities_label").method_27692(class_124.field_1073);
    private static final class_2561 LABEL_CATEGORIES = class_2561.method_43471((String)"collectorsalbum.text.statistics.categories_label").method_27692(class_124.field_1073);
    private static final String LANG_KEY_COLLECTED = "collectorsalbum.text.statistics.collected";
    private static final String LANG_KEY_POINTS = "collectorsalbum.text.statistics.points";
    private final class_1799 itemStack;
    protected int textureWidth = 256;
    protected int textureHeight = 256;
    protected int left;
    protected int top;

    AlbumMainPageScreen(class_1799 itemStack) {
        super(TITLE);
        this.itemStack = itemStack;
    }

    public static List<BookmarkWidget> getBookmarks(int guiWidth, int guiHeight, int albumWidth, int albumHeight, int bookImageHeight) {
        int left = (guiWidth - albumWidth) / 2;
        int top = (guiHeight - albumHeight) / 2 + 10;
        int right = left + albumWidth;
        Duration tooltipDelay = Duration.ofSeconds(1L);
        ArrayList<BookmarkWidget> bookmarks = new ArrayList<BookmarkWidget>();
        BookmarkWidget home = new BookmarkWidget(left - 32, top, 32, 18, true, ((AlbumItem)((Object)ItemRegistry.ALBUM.get())).method_7854(), () -> class_310.method_1551().field_1755 instanceof AlbumMainPageScreen);
        home.method_47400(class_7919.method_47407((class_2561)TITLE));
        home.method_47402(tooltipDelay);
        home.setAction(AlbumNavigationHelper::navigateHomepage);
        BookmarkWidget bonuses = new BookmarkWidget(left - 32, top + 20, 32, 18, true, class_1802.field_8687.method_7854(), () -> class_310.method_1551().field_1755 instanceof AlbumBonusesScreen);
        bonuses.method_47400(class_7919.method_47407((class_2561)AlbumBonusesScreen.TITLE));
        bonuses.method_47402(tooltipDelay);
        bonuses.setAction(AlbumNavigationHelper::navigateBonusesPage);
        bookmarks.add(home);
        bookmarks.add(bonuses);
        List<AlbumCategory> categories = AlbumNavigationHelper.listCategoriesForBookmarks(bookImageHeight - 20);
        int index = 0;
        for (AlbumCategory category : categories) {
            BookmarkWidget categoryBookmark = new BookmarkWidget(right, top + index++ * 20, 32, 18, false, category.visualTemplate().bookmarkIcon, () -> {
                AlbumCategoryScreen catScreen;
                class_437 patt0$temp = class_310.method_1551().field_1755;
                return patt0$temp instanceof AlbumCategoryScreen && (catScreen = (AlbumCategoryScreen)patt0$temp).getCategory().identifier().equals((Object)category.identifier());
            });
            categoryBookmark.method_47400(class_7919.method_47407((class_2561)category.getDisplayText()));
            categoryBookmark.method_47402(tooltipDelay);
            categoryBookmark.setAction(() -> AlbumNavigationHelper.navigateCategory(category));
            bookmarks.add(categoryBookmark);
        }
        return bookmarks;
    }

    public void method_25432() {
        AlbumNavigationHelper.captureCurrentMousePositionSnapshot();
    }

    public boolean method_25421() {
        return false;
    }

    protected void method_25426() {
        this.left = (this.field_22789 - this.textureWidth) / 2;
        this.top = (this.field_22790 - this.textureHeight) / 2;
        this.addDefaultWidgets();
    }

    public void method_25420(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.method_52752(graphics);
    }

    protected void addDefaultWidgets() {
        List<BookmarkWidget> bookmarks = AlbumMainPageScreen.getBookmarks(this.field_22789, this.field_22790, this.textureWidth, this.textureHeight, 180);
        for (BookmarkWidget bookmark : bookmarks) {
            this.method_37063((class_364)bookmark);
        }
        this.method_37060(new TextureRenderable(BACKGROUND, this.left, this.top, this.textureWidth, this.textureHeight));
        int titleWidth = this.field_22793.method_27525((class_5348)TITLE);
        this.method_37060(new LabelRenderable(TITLE, this.left + (128 - titleWidth) / 2, this.top + 14, 8084556));
        Album album = (Album)this.itemStack.method_57824((class_9331)ItemDataComponentRegistry.ALBUM.get());
        if (album == null) {
            return;
        }
        AlbumCategoryManager categoryManager = AlbumCategoryManager.getInstance();
        int collected = album.countCards();
        int available = categoryManager.getCollectibleCardCount();
        class_5250 percent = class_2561.method_43470((String)String.format(Locale.ROOT, "(%.1f%%)", Float.valueOf((float)collected / (float)available * 100.0f)));
        class_5250 collectedCards = class_2561.method_43469((String)LANG_KEY_COLLECTED, (Object[])new Object[]{collected, available});
        this.method_37060(new LabelRenderable((class_2561)collectedCards, this.left + 17, this.top + 30, 8084556));
        this.method_37060(new LabelRenderable((class_2561)percent, this.left + 17 + this.field_22793.method_27525((class_5348)collectedCards) - this.field_22793.method_27525((class_5348)percent), this.top + 40, 8084556));
        Map<CardRarity, Album.CardRarityStatistics> ratios = album.calculateRarityRatios();
        this.method_37060(new LabelRenderable(LABEL_RARITIES, this.left + 17, this.top + 55, 8084556));
        int rarityIndex = 0;
        for (CardRarity rarity : CardRarity.values()) {
            Album.CardRarityStatistics statistics = ratios.get((Object)rarity);
            class_5250 rarityText = class_2561.method_43470((String)rarity.getDisplayText().getString());
            rarityText.method_10866().method_27705(new class_124[]{class_124.field_1070});
            String ratio = String.format(Locale.ROOT, "%.1f%%", Float.valueOf(statistics.getRatio() * 100.0f));
            class_5250 label = class_2561.method_43470((String)(rarityText.getString() + ": " + ratio));
            LabelWidget labelWidget = (LabelWidget)this.method_37063((class_364)new LabelWidget(this.left + 20, this.top + 65 + rarityIndex++ * 10, this.field_22793.method_27525((class_5348)label), 10, (class_2561)label, this.field_22793, 8084556));
            labelWidget.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)(statistics.collected() + "/" + statistics.total())).method_27692(class_124.field_1060)));
        }
        class_5250 points = class_2561.method_43470((String)String.valueOf(album.getPoints())).method_54663(-1069568).method_27692(class_124.field_1067);
        class_5250 pointsLabel = class_2561.method_43469((String)LANG_KEY_POINTS, (Object[])new Object[]{points}).method_54663(8084556);
        this.method_37060(new LabelRenderable((class_2561)pointsLabel, this.left + 145, this.top + 14, false, 0xFFFFFF));
        this.method_37060(new LabelRenderable(LABEL_CATEGORIES, this.left + 145, this.top + 30, false, 8084556));
        List<Album.AlbumCategoryStatistics> statistics = album.calculateStatistics();
        for (int i = 0; i < Math.min(12, statistics.size()); ++i) {
            Album.AlbumCategoryStatistics stat = statistics.get(i);
            class_5250 categoryLabelNoStyle = class_2561.method_43470((String)stat.category().getDisplayText().getString());
            categoryLabelNoStyle.method_10866().method_27705(new class_124[]{class_124.field_1070});
            class_5250 displayLabel = class_2561.method_43470((String)(categoryLabelNoStyle.getString() + ": " + stat.collectedCards() + "/" + stat.allCards()));
            LabelWidget labelWidget = (LabelWidget)this.method_37063((class_364)new LabelWidget(this.left + 148, this.top + 40 + i * 10, 95, 10, (class_2561)displayLabel, this.field_22793, 8084556));
            labelWidget.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)String.format(Locale.ROOT, "%.1f%%", Float.valueOf(stat.getCollectedProgress() * 100.0f))).method_27692(class_124.field_1060)));
        }
        AlbumCategoryManager manager = AlbumCategoryManager.getInstance();
        AlbumCategory category = manager.getCategoryForPage(0);
        if (category != null) {
            class_474 button = (class_474)this.method_37063((class_364)new class_474(this.left + 210, this.top + 156, true, btn -> AlbumNavigationHelper.navigateNextCategory(), true));
            button.method_47400(class_7919.method_47407((class_2561)AlbumNavigationHelper.getNextCategoryTitle()));
            button.method_47402(Duration.ofSeconds(1L));
        }
    }
}

