/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_6382;
import net.minecraft.class_757;
import net.minecraft.class_7923;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Vector2d;
import team.tnt.collectorsalbum.common.card.AlbumCard;
import team.tnt.collectorsalbum.common.card.CardRarity;
import team.tnt.collectorsalbum.common.card.CardUiTemplate;
import team.tnt.collectorsalbum.common.card.RarityHolder;
import team.tnt.collectorsalbum.common.init.SoundRegistry;
import team.tnt.collectorsalbum.common.resource.AlbumCardManager;
import team.tnt.collectorsalbum.network.C2S_CompleteOpeningCardPack;
import team.tnt.collectorsalbum.platform.network.PlatformNetworkManager;

public class CardPackOpeningScreen
extends class_437 {
    private static final class_2561 TITLE = class_2561.method_43471((String)"screen.collectorsalbum.card_pack_opening_screen");
    private static final class_2960 CARD_BG = class_2960.method_60655((String)"collectorsalbum", (String)"textures/ui/card_back.png");
    private static final int CARD_SIZE = 32;
    private static final int CARD_MARGIN = 8;
    private final FxEmitter emitter;
    private final List<class_1799> drops;
    private final List<CardWidget> cardWidgets = new ArrayList<CardWidget>();

    public CardPackOpeningScreen(List<class_1799> drops) {
        super(TITLE);
        this.emitter = new FxEmitter();
        this.drops = drops;
    }

    protected void method_25426() {
        super.method_25426();
        this.cardWidgets.clear();
        int rows = class_3532.method_15386((float)((float)this.drops.size() / 6.0f));
        int containerHeight = rows * 40 - 8;
        int containerTop = (this.field_22790 - containerHeight) / 2;
        for (int y = 0; y < rows; ++y) {
            int rowCols = Math.min(6, this.drops.size() - y * 6);
            int rowWidth = rowCols * 40 - 8;
            int rowLeft = (this.field_22789 - rowWidth) / 2;
            int rowTop = containerTop + y * 40;
            for (int x = 0; x < rowCols; ++x) {
                int index = x + y * 6;
                class_1799 drop = this.drops.get(index);
                CardWidget widget = this.addCardWidget(rowLeft + x * 40, rowTop, drop);
                widget.setOnIconFlipped(this::onCardFlipped);
                widget.setPositionAnimationDelay(index * 3);
            }
        }
    }

    public void method_25420(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.method_52752(graphics);
        this.emitter.draw(graphics, delta);
    }

    public void method_25432() {
        PlatformNetworkManager.NETWORK.sendServerMessage(new C2S_CompleteOpeningCardPack());
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25393() {
        this.emitter.update();
        this.cardWidgets.forEach(CardWidget::tick);
    }

    private void onCardFlipped(CardWidget widget) {
        AlbumCard card = widget.card;
        CardUiTemplate template = card.template();
        Integer[] effects = template.effectColors();
        Integer[] durations = template.effectDurations();
        double speed = 4.0;
        int count = Math.min(20 + card.getPoints() * 5, 100) / Math.max(effects.length, 1);
        for (int i = 0; i < effects.length; ++i) {
            float centerX = (float)widget.method_46426() + (float)widget.method_25368() / 2.0f;
            float centerY = (float)widget.method_46427() + (float)widget.method_25364() / 2.0f;
            this.emitter.emit(centerX, centerY, effects[i], durations[i], count, speed);
        }
    }

    private CardWidget addCardWidget(int x, int y, class_1799 itemStack) {
        int left = (this.field_22789 - 32) / 2;
        int top = this.field_22790 - 16;
        CardWidget widget = new CardWidget(left, top, 32, 32, x, y, itemStack);
        this.cardWidgets.add(widget);
        return (CardWidget)this.method_37063((class_364)widget);
    }

    static void renderFullTexture(class_2960 path, Matrix4f pose, float x, float y, float z, float width, float height) {
        RenderSystem.setShaderTexture((int)0, (class_2960)path);
        RenderSystem.setShader(class_757::method_34542);
        class_287 builder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        builder.method_22918(pose, x, y, z).method_22913(0.0f, 0.0f);
        builder.method_22918(pose, x, y + height, z).method_22913(0.0f, 1.0f);
        builder.method_22918(pose, x + width, y + height, z).method_22913(1.0f, 1.0f);
        builder.method_22918(pose, x + width, y, z).method_22913(1.0f, 0.0f);
        class_286.method_43433((class_9801)builder.method_60800());
    }

    static void renderFullColoredTexture(class_2960 path, Matrix4f pose, float x, float y, float z, float width, float height, int color) {
        RenderSystem.setShaderTexture((int)0, (class_2960)path);
        RenderSystem.setShader(class_757::method_34543);
        class_287 builder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        builder.method_22918(pose, x, y, z).method_22913(0.0f, 0.0f).method_39415(color);
        builder.method_22918(pose, x, y + height, z).method_22913(0.0f, 1.0f).method_39415(color);
        builder.method_22918(pose, x + width, y + height, z).method_22913(1.0f, 1.0f).method_39415(color);
        builder.method_22918(pose, x + width, y, z).method_22913(1.0f, 0.0f).method_39415(color);
        class_286.method_43433((class_9801)builder.method_60800());
    }

    private static class FxEmitter {
        private final List<FxElement> liveElements = new ArrayList<FxElement>();

        private FxEmitter() {
        }

        void emit(float x, float y, int color, int lifetime, int count, double dirMul) {
            for (int i = 0; i < count; ++i) {
                FxElement element = new FxElement(x, y, color, lifetime);
                double xRand = Math.random() - Math.random();
                double yRand = Math.random() - Math.random();
                element.setDir(new Vector2d(xRand * dirMul, yRand * dirMul));
                this.liveElements.add(element);
            }
        }

        void update() {
            Iterator<FxElement> it = this.liveElements.iterator();
            while (it.hasNext()) {
                FxElement element = it.next();
                element.update();
                if (!element.shouldRemove()) continue;
                it.remove();
            }
        }

        void draw(class_332 graphics, float delta) {
            this.liveElements.forEach(fx -> fx.draw(graphics, delta));
        }
    }

    private static final class CardWidget
    extends class_339 {
        private static final int TOTAL_MOVE_TIME = 10;
        private static final int TOTAL_FLIP_TIME = 20;
        private final int originalX;
        private final int originalY;
        private final int targetX;
        private final int targetY;
        private final AlbumCard card;
        private final class_2960 itemTexture;
        private Consumer<CardWidget> onIconFlipped;
        private Consumer<CardWidget> onFlipFinish;
        private boolean flipped;
        private boolean flipping;
        private int flipCurrent;
        private int flipOld;
        private int positionCurrent;
        private int positionOld;
        private int positionAnimationDelay;

        public CardWidget(int x, int y, int width, int height, int targetX, int targetY, class_1799 itemStack) {
            super(x, y, width, height, class_5244.field_39003);
            this.originalX = x;
            this.originalY = y;
            this.targetX = targetX;
            this.targetY = targetY;
            this.card = AlbumCardManager.getInstance().getCardInfo(itemStack.method_7909()).orElse(null);
            this.itemTexture = CardWidget.getCardTexture(this.card, itemStack);
        }

        public void setOnIconFlipped(Consumer<CardWidget> onIconFlipped) {
            this.onIconFlipped = onIconFlipped;
        }

        public void setOnFlipFinish(Consumer<CardWidget> onFlipFinish) {
            this.onFlipFinish = onFlipFinish;
        }

        public void setPositionAnimationDelay(int positionAnimationDelay) {
            this.positionAnimationDelay = positionAnimationDelay;
        }

        public void tick() {
            this.tickPosition();
            this.tickFlipping();
        }

        public void method_25354(class_1144 manager) {
            class_3414 event;
            AlbumCard albumCard = this.card;
            if (albumCard instanceof RarityHolder) {
                RarityHolder holder = (RarityHolder)albumCard;
                CardRarity rarity = holder.rarity();
                event = rarity.getFlipSoundRef().get();
            } else {
                event = (class_3414)SoundRegistry.FLIP_COMMON.get();
            }
            manager.method_4873((class_1113)class_1109.method_4758((class_3414)event, (float)1.0f));
        }

        public void method_25348(double $$0, double $$1) {
            if (this.flipping || this.flipped) {
                return;
            }
            this.flipping = true;
        }

        protected void method_48579(class_332 graphics, int mouseX, int mouseY, float deltaTicks) {
            this.updatePosition(deltaTicks);
            this.renderCardWithFlipAnimation(graphics, deltaTicks);
        }

        private void updatePosition(float delta) {
            if (this.positionOld == this.positionCurrent && this.positionCurrent > 0) {
                this.method_46421(this.targetX);
                this.method_46419(this.targetY);
                return;
            }
            float positionAnimProgress = class_3532.method_16439((float)delta, (float)this.positionOld, (float)this.positionCurrent) / 10.0f;
            float positionAnimEased = 1.0f - (float)Math.pow(1.0f - positionAnimProgress, 3.0);
            int xDelta = this.targetX - this.originalX;
            int yDelta = this.targetY - this.originalY;
            this.method_46421((int)((float)this.originalX + (float)xDelta * positionAnimEased));
            this.method_46419((int)((float)this.originalY + (float)yDelta * positionAnimEased));
        }

        private void renderCardWithFlipAnimation(class_332 graphics, float delta) {
            float px = this.method_46426();
            int py = this.method_46427();
            float pWidth = this.method_25368();
            int pHeight = this.method_25364();
            if (this.flipping) {
                float flipProgress;
                boolean wasFlipped = this.flipped;
                float flipOld = (float)this.flipOld / 20.0f;
                float flipActual = (float)this.flipCurrent / 20.0f;
                float flipProgressRaw = class_3532.method_16439((float)delta, (float)flipOld, (float)flipActual);
                float f = flipProgress = (double)flipProgressRaw < 0.5 ? 4.0f * flipProgressRaw * flipProgressRaw * flipProgressRaw : 1.0f - (float)Math.pow(-2.0f * flipProgressRaw + 2.0f, 3.0) / 2.0f;
                if ((double)flipProgress >= 0.5) {
                    this.flipped = true;
                }
                float amount = this.flipped ? (flipProgress - 0.5f) / 0.5f : 1.0f - flipProgress / 0.5f;
                float halfWidth = (float)this.method_25368() / 2.0f;
                px = (float)this.method_46426() + halfWidth * (1.0f - amount);
                pWidth = (float)this.method_25368() * amount;
                if (this.flipped && !wasFlipped && this.onIconFlipped != null && this.card != null) {
                    this.onIconFlipped.accept(this);
                }
            }
            class_2960 texture = this.flipped ? this.itemTexture : CARD_BG;
            Matrix4f poseMat = graphics.method_51448().method_23760().method_23761();
            CardPackOpeningScreen.renderFullTexture(texture, poseMat, px, py, 400.0f, pWidth, pHeight);
        }

        protected void method_47399(class_6382 narrationElementOutput) {
        }

        protected boolean method_25361(double mouseX, double mouseY) {
            return !this.flipped && !this.flipping && super.method_25361(mouseX, mouseY);
        }

        private void tickPosition() {
            if (this.positionAnimationDelay > 0) {
                --this.positionAnimationDelay;
                return;
            }
            this.positionOld = this.positionCurrent;
            if (this.positionCurrent < 10 && this.positionCurrent++ == 0) {
                class_1144 manager = class_310.method_1551().method_1483();
                manager.method_4873((class_1113)class_1109.method_4757((class_3414)((class_3414)SoundRegistry.FLIP_COMMON.get()), (float)1.5f, (float)0.25f));
            }
        }

        private void tickFlipping() {
            if (!this.flipping) {
                return;
            }
            this.flipOld = this.flipCurrent;
            if (this.flipCurrent >= 20) {
                this.flipping = false;
                if (this.onFlipFinish != null && this.card != null) {
                    this.onFlipFinish.accept(this);
                }
                return;
            }
            ++this.flipCurrent;
        }

        private static class_2960 getCardTexture(AlbumCard card, class_1799 itemStack) {
            if (card == null) {
                return CardWidget.getDefaultItemTexture(itemStack);
            }
            CardUiTemplate template = card.template();
            return template.cardTexture() != null ? template.cardTexture() : CardWidget.getDefaultItemTexture(itemStack);
        }

        private static class_2960 getDefaultItemTexture(class_1799 itemStack) {
            class_2960 itemId = class_7923.field_41178.method_10221((Object)itemStack.method_7909());
            return class_2960.method_60655((String)itemId.method_12836(), (String)("textures/item/" + itemId.method_12832() + ".png"));
        }
    }

    private static class FxElement {
        private static final class_2960[] PATHS = new class_2960[]{FxElement.spark(0), FxElement.spark(1), FxElement.spark(2), FxElement.spark(3), FxElement.spark(4), FxElement.spark(5), FxElement.spark(6), FxElement.spark(7)};
        private float x;
        private float y;
        private float xOld;
        private float yOld;
        private final int color;
        private final int stageLife;
        private int stage;
        private int stageLifeLeft;
        private Vector2d direction;

        public FxElement(float x, float y, int color, int stageLife) {
            this.x = x;
            this.y = y;
            this.xOld = x;
            this.yOld = y;
            this.color = color;
            this.stageLife = stageLife;
            this.stageLifeLeft = stageLife;
            this.stage = PATHS.length - 1;
        }

        void draw(class_332 graphics, float delta) {
            class_2960 path = PATHS[this.stage];
            Matrix4f pose = graphics.method_51448().method_23760().method_23761();
            float scale = 8.0f;
            float halfScale = scale / 2.0f;
            float xPos = class_3532.method_16439((float)delta, (float)this.xOld, (float)this.x);
            float yPos = class_3532.method_16439((float)delta, (float)this.yOld, (float)this.y);
            CardPackOpeningScreen.renderFullColoredTexture(path, pose, xPos - halfScale, yPos - halfScale, 0.0f, scale, scale, 0xFF000000 | this.color);
        }

        void update() {
            this.xOld = this.x;
            this.yOld = this.y;
            if (--this.stageLifeLeft < 0) {
                --this.stage;
                this.stageLifeLeft = this.stageLife;
            }
            if (this.direction != null) {
                this.x += (float)this.direction.x;
                this.y += (float)this.direction.y;
                this.direction.mul((double)0.95f);
            }
        }

        void setDir(Vector2d dir) {
            this.direction = dir;
        }

        boolean shouldRemove() {
            return this.stage == 0 && this.stageLifeLeft <= 0;
        }

        private static class_2960 spark(int index) {
            return class_2960.method_60656((String)String.format("textures/particle/spark_%d.png", index));
        }
    }
}

