/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.common;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_4844;
import net.minecraft.class_7923;
import net.minecraft.class_9326;
import team.tnt.collectorsalbum.common.AlbumCategory;
import team.tnt.collectorsalbum.common.card.AlbumCard;
import team.tnt.collectorsalbum.common.card.CardRarity;
import team.tnt.collectorsalbum.common.card.RarityHolder;
import team.tnt.collectorsalbum.common.resource.AlbumBonusManager;
import team.tnt.collectorsalbum.common.resource.AlbumCardManager;
import team.tnt.collectorsalbum.common.resource.AlbumCategoryManager;
import team.tnt.collectorsalbum.common.resource.util.ActionContext;
import team.tnt.collectorsalbum.platform.Codecs;

public final class Album
implements Predicate<Album> {
    public static final Codec<class_1799> NULLABLE_ITEMSTACK_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_7923.field_41178.method_40294().fieldOf("id").forGetter(class_1799::method_41409), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(class_1799::method_7947), (App)class_9326.field_49589.optionalFieldOf("components", (Object)class_9326.field_49588).forGetter(class_1799::method_57380)).apply((Applicative)instance, class_1799::new));
    public static final Codec<Album> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_4844.field_25122.fieldOf("albumId").forGetter(t -> t.albumId), (App)Codec.unboundedMap((Codec)class_2960.field_25139, Codecs.setCodec(AlbumCardManager.BY_NAME_CODEC)).xmap(HashMap::new, map -> map).fieldOf("cardsByCategory").forGetter(t -> (HashMap)t.cardsByCategory), (App)Codec.unboundedMap((Codec)class_2960.field_25139, Codecs.nonNullListCodec(NULLABLE_ITEMSTACK_CODEC, class_1799.field_8037)).fieldOf("categoryInventories").forGetter(t -> t.categoryInventories)).apply((Applicative)instance, Album::new));
    private final UUID albumId;
    private final Map<class_2960, Set<AlbumCard>> cardsByCategory;
    private final Map<class_2960, class_2371<class_1799>> categoryInventories;
    private final int points;

    private Album(Mutable mutable) {
        this.albumId = UUID.randomUUID();
        this.cardsByCategory = new HashMap<class_2960, Set<AlbumCard>>();
        this.categoryInventories = new HashMap<class_2960, class_2371<class_1799>>();
        int pointCounter = 0;
        AlbumCardManager manager = AlbumCardManager.getInstance();
        for (Map.Entry<class_2960, class_2371<class_1799>> entry : mutable.inventories.entrySet()) {
            class_2960 key = entry.getKey();
            class_2371<class_1799> inventory = entry.getValue();
            for (int i = 0; i < inventory.size(); ++i) {
                class_1799 itemStack = (class_1799)inventory.get(i);
                if (itemStack.method_7960()) continue;
                AlbumCard card = manager.getCardInfo(itemStack.method_7909()).orElseThrow(() -> new IllegalArgumentException(String.format("Attempting to save undefined card for item %s into album", itemStack)));
                this.cardsByCategory.computeIfAbsent(key, t -> new HashSet()).add(card);
                this.categoryInventories.computeIfAbsent(key, t -> class_2371.method_10213((int)inventory.size(), (Object)class_1799.field_8037)).set(i, (Object)itemStack.method_7972());
                pointCounter += card.getPoints();
            }
        }
        this.points = pointCounter;
    }

    private Album(UUID albumId) {
        this(albumId, new HashMap<class_2960, Set<AlbumCard>>(), new HashMap<class_2960, class_2371<class_1799>>());
    }

    private Album(UUID albumId, Map<class_2960, Set<AlbumCard>> cardsByCategory, Map<class_2960, class_2371<class_1799>> categoryInventories) {
        this.albumId = albumId;
        this.cardsByCategory = cardsByCategory;
        this.categoryInventories = categoryInventories;
        this.points = cardsByCategory.values().stream().flatMap(Collection::stream).mapToInt(AlbumCard::getPoints).sum();
    }

    public static Album emptyAlbum() {
        return new Album(UUID.randomUUID());
    }

    @Override
    public boolean test(Album album) {
        return album != null && this.albumId.equals(album.albumId);
    }

    public int getPoints() {
        return this.points;
    }

    public class_2371<class_1799> getInventory(class_2960 category) {
        return this.categoryInventories.getOrDefault(category, (class_2371<class_1799>)class_2371.method_10213((int)1, (Object)class_1799.field_8037));
    }

    public Collection<AlbumCard> getCardsForCategory(class_2960 category) {
        Set<AlbumCard> cards = this.cardsByCategory.get(category);
        return cards == null ? Collections.emptyList() : cards;
    }

    public int countCards() {
        return this.cardsByCategory.values().stream().mapToInt(Set::size).sum();
    }

    public Map<CardRarity, CardRarityStatistics> calculateRarityRatios() {
        List<RarityHolder> rarityCards = this.cardsByCategory.values().stream().flatMap(Collection::stream).filter(card -> card instanceof RarityHolder).map(card -> (RarityHolder)card).toList();
        EnumMap<CardRarity, CardRarityStatistics> map = new EnumMap<CardRarity, CardRarityStatistics>(CardRarity.class);
        Map<CardRarity, List<RarityHolder>> byRarity = rarityCards.stream().collect(Collectors.groupingBy(RarityHolder::rarity));
        int totalCards = Math.max(rarityCards.size(), 1);
        for (CardRarity rarity : CardRarity.values()) {
            List list = byRarity.getOrDefault((Object)rarity, Collections.emptyList());
            CardRarityStatistics statistics = new CardRarityStatistics(list.size(), totalCards);
            map.put(rarity, statistics);
        }
        return map;
    }

    public List<AlbumCategoryStatistics> calculateStatistics() {
        AlbumCategoryManager manager = AlbumCategoryManager.getInstance();
        Collection<AlbumCategory> categories = manager.listCategories();
        return categories.stream().map(cat -> {
            Set cardsInCategory = this.cardsByCategory.getOrDefault(cat.identifier(), Collections.emptySet());
            int categoryTotal = cat.getCardNumbers().length;
            int categoryCollected = cardsInCategory.size();
            return new AlbumCategoryStatistics((AlbumCategory)cat, categoryCollected, categoryTotal);
        }).filter(stat -> stat.allCards() > 0).sorted(Comparator.comparingDouble(AlbumCategoryStatistics::getCollectedProgress).reversed()).toList();
    }

    public void tick(class_1657 player) {
        ActionContext context = ActionContext.of("player", player, "album", this);
        AlbumBonusManager manager = AlbumBonusManager.getInstance();
        manager.applyBonuses(context);
    }

    public void removed(class_1657 player) {
        ActionContext context = ActionContext.of("player", player, "album", this);
        AlbumBonusManager manager = AlbumBonusManager.getInstance();
        manager.removeBonuses(context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Album album = (Album)o;
        return Objects.equals(this.albumId, album.albumId);
    }

    public int hashCode() {
        return Objects.hashCode(this.albumId);
    }

    public static final class Mutable {
        private final Map<class_2960, class_2371<class_1799>> inventories;

        public Mutable(Album album) {
            HashMap<class_2960, class_2371<class_1799>> inventories = new HashMap<class_2960, class_2371<class_1799>>();
            for (Map.Entry<class_2960, class_2371<class_1799>> entry : album.categoryInventories.entrySet()) {
                class_2960 key = entry.getKey();
                class_2371<class_1799> categoryInventory = entry.getValue();
                AlbumCategoryManager.getInstance().findById(key).ifPresent(category -> {
                    class_2371 inventory = class_2371.method_10213((int)category.getCardNumbers().length, (Object)class_1799.field_8037);
                    for (int i = 0; i < categoryInventory.size(); ++i) {
                        class_1799 itemStack = (class_1799)categoryInventory.get(i);
                        if (itemStack.method_7960()) continue;
                        inventory.set(i, (Object)itemStack.method_7972());
                    }
                    inventories.put(key, inventory);
                });
            }
            this.inventories = inventories;
        }

        public void set(class_2960 category, int index, class_1799 itemStack) {
            class_2371 inventory = this.inventories.get(category);
            if (inventory == null) {
                AlbumCategoryManager manager = AlbumCategoryManager.getInstance();
                AlbumCategory albumCategory = manager.findById(category).orElseThrow(() -> new IllegalArgumentException(String.format("Attempting to insert item %s into unknown category %s", itemStack, category)));
                inventory = class_2371.method_10213((int)albumCategory.getCardNumbers().length, (Object)class_1799.field_8037);
                this.inventories.put(category, (class_2371<class_1799>)inventory);
            }
            inventory.set(index, (Object)itemStack.method_7972());
        }

        public Album toImmutable() {
            return new Album(this);
        }

        public String toString() {
            return "MutableAlbum{inventories=" + String.valueOf(this.inventories) + "}";
        }
    }

    public record CardRarityStatistics(int collected, int total) {
        public float getRatio() {
            return this.total > 0 ? (float)this.collected / (float)this.total : 0.0f;
        }
    }

    public record AlbumCategoryStatistics(AlbumCategory category, int collectedCards, int allCards) {
        public float getCollectedProgress() {
            return this.allCards > 0 ? (float)this.collectedCards / (float)this.allCards : 0.0f;
        }
    }
}

