/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.common.card;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import team.tnt.collectorsalbum.common.AlbumCategory;
import team.tnt.collectorsalbum.common.card.AlbumCard;
import team.tnt.collectorsalbum.common.card.CardRarity;
import team.tnt.collectorsalbum.common.init.SoundRegistry;
import team.tnt.collectorsalbum.platform.Codecs;

public record CardUiTemplate(Integer[] effectColors, Integer[] effectDurations, Supplier<class_3414> flipSoundRef, class_2960 cardTexture) {
    public static final CardUiTemplate TEMPLATE = new CardUiTemplate(new Integer[]{65280}, new Integer[]{5}, SoundRegistry.FLIP_COMMON, null);
    public static final Codec<CardUiTemplate> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codecs.array(Codec.INT, Integer[]::new).optionalFieldOf("effectColors", (Object)TEMPLATE.effectColors()).forGetter(t -> t.effectColors), (App)Codecs.array(Codec.INT, Integer[]::new).optionalFieldOf("effectDurations", (Object)TEMPLATE.effectDurations()).forGetter(t -> t.effectDurations), (App)Codecs.supplier(class_7923.field_41172.method_39673()).optionalFieldOf("flipSound", TEMPLATE.flipSoundRef()).forGetter(t -> t.flipSoundRef), (App)class_2960.field_25139.optionalFieldOf("cardTexture").forGetter(t -> Optional.ofNullable(t.cardTexture))).apply((Applicative)instance, (colors, durations, sound, textureOpt) -> new CardUiTemplate((Integer[])colors, (Integer[])durations, (Supplier<class_3414>)sound, textureOpt.orElse(null)))).validate(template -> template.effectColors().length == template.effectDurations().length ? DataResult.success((Object)template) : DataResult.error(() -> "Effect duration count has to be the same as effect colors"));
    public static final class_2561 DEFAULT_CARD_INFO_HEADER = class_2561.method_43471((String)"collectorsalbum.tooltip.card.header").method_27692(class_124.field_1080);
    public static final String ITEM_TOOLTIP_NUMBER_KEY = "collectorsalbum.tooltip.card.number";
    public static final String ITEM_TOOLTIP_CATEGORY_KEY = "collectorsalbum.tooltip.card.category";
    public static final String ITEM_TOOLTIP_RARITY_KEY = "collectorsalbum.tooltip.card.rarity";
    public static final String ITEM_TOOLTIP_VALUE_KEY = "collectorsalbum.tooltip.card.value";

    public static class_5250 getCardNumberTooltip(class_2561 numberLabel) {
        return class_2561.method_43469((String)ITEM_TOOLTIP_NUMBER_KEY, (Object[])new Object[]{numberLabel}).method_27692(class_124.field_1080);
    }

    public static class_5250 getCardNumberTooltip(int number) {
        class_5250 label = class_2561.method_43470((String)("#" + number)).method_27692(class_124.field_1054);
        return CardUiTemplate.getCardNumberTooltip((class_2561)label);
    }

    public static class_5250 getCardCategoryTooltip(AlbumCard card) {
        return CardUiTemplate.getCardCategoryTooltip(card.getLinkedCategory());
    }

    public static class_5250 getCardCategoryTooltip(AlbumCategory category) {
        return CardUiTemplate.getCardCategoryTooltip(category.getDisplayText());
    }

    public static class_5250 getCardCategoryTooltip(class_2561 categoryLabel) {
        return class_2561.method_43469((String)ITEM_TOOLTIP_CATEGORY_KEY, (Object[])new Object[]{categoryLabel}).method_27692(class_124.field_1080);
    }

    public static class_5250 getCardRarityTooltip(CardRarity rarity) {
        return CardUiTemplate.getCardRarityTooltip(rarity.getDisplayText());
    }

    public static class_5250 getCardRarityTooltip(class_2561 rarityLabel) {
        return class_2561.method_43469((String)ITEM_TOOLTIP_RARITY_KEY, (Object[])new Object[]{rarityLabel}).method_27692(class_124.field_1080);
    }

    public static class_5250 getCardPointsTooltip(AlbumCard card) {
        return CardUiTemplate.getCardPointsTooltip(card.getPoints());
    }

    public static class_5250 getCardPointsTooltip(int points) {
        class_5250 label = class_2561.method_43469((String)"collectorsalbum.text.points.value", (Object[])new Object[]{points}).method_27692(class_124.field_1054);
        return CardUiTemplate.getCardPointsTooltip((class_2561)label);
    }

    public static class_5250 getCardPointsTooltip(class_2561 pointsLabel) {
        return class_2561.method_43469((String)ITEM_TOOLTIP_VALUE_KEY, (Object[])new Object[]{pointsLabel}).method_27692(class_124.field_1080);
    }
}

