/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.common.card;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5699;
import team.tnt.collectorsalbum.common.AlbumCategory;
import team.tnt.collectorsalbum.common.card.AlbumCardType;
import team.tnt.collectorsalbum.common.card.CardFilter;
import team.tnt.collectorsalbum.common.card.CardRarity;
import team.tnt.collectorsalbum.common.card.CardUiTemplate;
import team.tnt.collectorsalbum.common.card.RarityHolder;
import team.tnt.collectorsalbum.common.init.CardTypeRegistry;
import team.tnt.collectorsalbum.common.resource.AlbumCategoryManager;
import team.tnt.collectorsalbum.platform.Codecs;

public class RarityCard
implements RarityHolder {
    public static final MapCodec<RarityCard> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2960.field_25139.fieldOf("id").forGetter(RarityCard::identifier), (App)Codecs.simpleEnumCodec(CardRarity.class, text -> text.toUpperCase(Locale.ROOT)).fieldOf("rarity").forGetter(t -> t.rarity), (App)class_1799.field_49267.fieldOf("item").forGetter(RarityCard::asItem), (App)class_2960.field_25139.fieldOf("category").forGetter(RarityCard::category), (App)class_5699.field_33442.fieldOf("number").forGetter(RarityCard::cardNumber), (App)class_2960.field_25139.optionalFieldOf("cardTexture").forGetter(t -> Optional.ofNullable(t.template.cardTexture()))).apply((Applicative)instance, RarityCard::new));
    private final class_2960 cardIdentifier;
    private final CardRarity rarity;
    private final class_1799 itemStack;
    private final class_2960 categoryIdentifier;
    private final int cardNumber;
    private final CardUiTemplate template;
    private AlbumCategory cachedCategory;

    public RarityCard(class_2960 cardIdentifier, CardRarity rarity, class_1799 itemStack, class_2960 categoryIdentifier, int cardNumber, Optional<class_2960> cardTexture) {
        this.cardIdentifier = cardIdentifier;
        this.rarity = rarity;
        this.itemStack = itemStack;
        this.categoryIdentifier = categoryIdentifier;
        this.cardNumber = cardNumber;
        this.template = new CardUiTemplate(rarity.getColors(), rarity.getDurations(), rarity.getFlipSoundRef(), cardTexture.orElse(null));
    }

    @Override
    public class_2960 identifier() {
        return this.cardIdentifier;
    }

    @Override
    public CardUiTemplate template() {
        return this.template;
    }

    @Override
    public CardRarity rarity() {
        return this.rarity;
    }

    @Override
    public class_1799 asItem() {
        return this.itemStack;
    }

    @Override
    public class_2960 category() {
        return this.categoryIdentifier;
    }

    @Override
    public int getPoints() {
        return this.rarity.getValue();
    }

    @Override
    public int cardNumber() {
        return this.cardNumber;
    }

    @Override
    public AlbumCardType<?> getType() {
        return (AlbumCardType)CardTypeRegistry.RARITY_CARD.get();
    }

    @Override
    public boolean test(CardFilter filter) {
        Set<CardRarity> rarities = filter.rarities();
        if (rarities != null && !rarities.isEmpty() && !rarities.contains((Object)this.rarity)) {
            return false;
        }
        if (!filter.numberFilter().test(this.cardNumber)) {
            return false;
        }
        return filter.pointFilter().test(this.rarity.getValue());
    }

    @Override
    public void appendItemStackHoverTooltip(class_1799 itemStack, class_1792.class_9635 context, List<class_2561> tooltips, class_1836 flag) {
        tooltips.add(CardUiTemplate.DEFAULT_CARD_INFO_HEADER);
        tooltips.add((class_2561)CardUiTemplate.getCardNumberTooltip(this.cardNumber));
        tooltips.add((class_2561)CardUiTemplate.getCardCategoryTooltip(this));
        tooltips.add((class_2561)CardUiTemplate.getCardRarityTooltip(this.rarity));
        tooltips.add((class_2561)CardUiTemplate.getCardPointsTooltip(this));
    }

    @Override
    public AlbumCategory getLinkedCategory() {
        if (this.cachedCategory == null) {
            this.cachedCategory = AlbumCategoryManager.getInstance().findById(this.categoryIdentifier).orElseThrow();
        }
        return this.cachedCategory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RarityCard that = (RarityCard)o;
        return Objects.equals(this.cardIdentifier, that.cardIdentifier);
    }

    public int hashCode() {
        return Objects.hashCode(this.cardIdentifier);
    }
}

