/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.common.card;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5699;
import team.tnt.collectorsalbum.common.AlbumCategory;
import team.tnt.collectorsalbum.common.card.AlbumCard;
import team.tnt.collectorsalbum.common.card.AlbumCardType;
import team.tnt.collectorsalbum.common.card.CardFilter;
import team.tnt.collectorsalbum.common.card.CardUiTemplate;
import team.tnt.collectorsalbum.common.init.CardTypeRegistry;
import team.tnt.collectorsalbum.common.resource.AlbumCategoryManager;

public class SimpleCard
implements AlbumCard {
    public static final MapCodec<SimpleCard> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2960.field_25139.fieldOf("id").forGetter(SimpleCard::identifier), (App)class_1799.field_49267.fieldOf("item").forGetter(SimpleCard::asItem), (App)class_2960.field_25139.fieldOf("category").forGetter(SimpleCard::category), (App)CardUiTemplate.CODEC.optionalFieldOf("template", (Object)CardUiTemplate.TEMPLATE).forGetter(SimpleCard::template), (App)Codec.INT.optionalFieldOf("points", (Object)0).forGetter(SimpleCard::getPoints), (App)class_5699.field_33442.fieldOf("number").forGetter(SimpleCard::cardNumber)).apply((Applicative)instance, SimpleCard::new));
    private final class_2960 cardId;
    private final class_1799 item;
    private final class_2960 category;
    private final CardUiTemplate template;
    private final int points;
    private final int number;
    private AlbumCategory cachedCategory;

    public SimpleCard(class_2960 cardId, class_1799 item, class_2960 category, CardUiTemplate template, int points, int number) {
        this.cardId = cardId;
        this.item = item;
        this.category = category;
        this.template = template;
        this.points = points;
        this.number = number;
    }

    @Override
    public int cardNumber() {
        return this.number;
    }

    @Override
    public int getPoints() {
        return this.points;
    }

    @Override
    public class_2960 category() {
        return this.category;
    }

    @Override
    public CardUiTemplate template() {
        return this.template;
    }

    @Override
    public class_1799 asItem() {
        return this.item;
    }

    @Override
    public class_2960 identifier() {
        return this.cardId;
    }

    @Override
    public boolean test(CardFilter filter) {
        if (!filter.numberFilter().test(this.number)) {
            return false;
        }
        return filter.pointFilter().test(this.points);
    }

    @Override
    public void appendItemStackHoverTooltip(class_1799 itemStack, class_1792.class_9635 context, List<class_2561> tooltips, class_1836 flag) {
        tooltips.add(CardUiTemplate.DEFAULT_CARD_INFO_HEADER);
        tooltips.add((class_2561)CardUiTemplate.getCardNumberTooltip(this.number));
        tooltips.add((class_2561)CardUiTemplate.getCardCategoryTooltip(this));
        int points = this.getPoints();
        if (points > 0) {
            tooltips.add((class_2561)CardUiTemplate.getCardPointsTooltip(points));
        }
    }

    @Override
    public AlbumCardType<?> getType() {
        return (AlbumCardType)CardTypeRegistry.CARD.get();
    }

    @Override
    public AlbumCategory getLinkedCategory() {
        if (this.cachedCategory == null) {
            this.cachedCategory = AlbumCategoryManager.getInstance().findById(this.category).orElseThrow();
        }
        return this.cachedCategory;
    }
}

