/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.common.item;

import com.mojang.serialization.Codec;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_5250;
import net.minecraft.class_9331;
import team.tnt.collectorsalbum.CollectorsAlbum;
import team.tnt.collectorsalbum.common.init.ItemDataComponentRegistry;
import team.tnt.collectorsalbum.common.init.SoundRegistry;
import team.tnt.collectorsalbum.common.resource.AlbumCardManager;
import team.tnt.collectorsalbum.common.resource.CardPackDropManager;
import team.tnt.collectorsalbum.common.resource.drops.ItemDropProvider;
import team.tnt.collectorsalbum.common.resource.drops.NoItemDropProvider;
import team.tnt.collectorsalbum.common.resource.util.ActionContext;
import team.tnt.collectorsalbum.common.resource.util.ListBasedOutputBuilder;
import team.tnt.collectorsalbum.network.S2C_OpenCardPackScreen;
import team.tnt.collectorsalbum.platform.network.PlatformNetworkManager;

public class CardPackItem
extends class_1792 {
    public static final int MAX_PACK_CARDS = 18;
    public static final class_2561 USAGE = class_2561.method_43471((String)"collectorsalbum.label.use_open").method_27692(class_124.field_1080);
    public static final class_2561 LABEL_UNSET = class_2561.method_43471((String)"collectorsalbum.label.not_set").method_27692(class_124.field_1061);
    private static final class_2561 WARN_NO_DROPS = class_2561.method_43471((String)"collectorsalbum.label.pack_empty").method_27692(class_124.field_1065);
    private final class_2960 lootDataSourcePath;

    public CardPackItem(class_1792.class_1793 properties) {
        this(properties, null);
    }

    public CardPackItem(class_1792.class_1793 properties, class_2960 lootDataSourcePath) {
        super(properties);
        this.lootDataSourcePath = lootDataSourcePath;
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        player.method_6019(hand);
        player.method_5783((class_3414)SoundRegistry.PACK_OPEN.get(), 1.0f, 1.0f);
        return class_1271.method_22428((Object)itemStack);
    }

    public class_1839 method_7853(class_1799 itemStack) {
        return class_1839.field_8953;
    }

    public int method_7881(class_1799 itemStack, class_1309 entity) {
        return 20;
    }

    public class_1799 method_7861(class_1799 itemStack, class_1937 level, class_1309 entity) {
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            if (!level.method_8608()) {
                ListBasedOutputBuilder<class_1799> outputs = ListBasedOutputBuilder.createArrayListBased();
                ItemDropProvider provider = this.getDropTable(itemStack);
                ActionContext context = ActionContext.of("player", player, "itemstack", itemStack, "random", player.method_59922());
                provider.generateDrops(context, outputs);
                AlbumCardManager cardManager = AlbumCardManager.getInstance();
                List<class_1799> validDrops = outputs.getItems().stream().filter(stack -> cardManager.isCard(stack.method_7909())).map(class_1799::method_7972).collect(Collectors.toList());
                CollectorsAlbum.LOGGER.debug("{} is opening card pack {} with generated content: {}", (Object)entity, (Object)this, validDrops);
                if (!validDrops.isEmpty()) {
                    Collections.shuffle(validDrops);
                    PackContents contents = new PackContents(validDrops);
                    itemStack.method_57379((class_9331)ItemDataComponentRegistry.PACK_CONTENTS.get(), (Object)contents);
                    PlatformNetworkManager.NETWORK.sendClientMessage(player, new S2C_OpenCardPackScreen(validDrops));
                } else {
                    player.method_7353(WARN_NO_DROPS, true);
                }
                player.method_7357().method_7906((class_1792)this, 20);
            }
        }
        return itemStack;
    }

    protected ItemDropProvider getDropTable(class_1799 itemStack) {
        CardPackDropManager manager = CardPackDropManager.getInstance();
        class_2960 customPath = (class_2960)itemStack.method_57824((class_9331)ItemDataComponentRegistry.PACK_DROPS_TABLE.get());
        if (customPath != null) {
            return manager.getEitherProvider(customPath, this.lootDataSourcePath);
        }
        if (this.lootDataSourcePath != null) {
            return manager.getProvider(this.lootDataSourcePath);
        }
        return NoItemDropProvider.INSTANCE;
    }

    public void method_7851(class_1799 itemStack, class_1792.class_9635 context, List<class_2561> components, class_1836 flag) {
        components.add(USAGE);
        class_2960 customTable = (class_2960)itemStack.method_57824((class_9331)ItemDataComponentRegistry.PACK_DROPS_TABLE.get());
        if (customTable != null) {
            class_5250 customTableLabel = class_2561.method_43470((String)customTable.toString()).method_27692(class_124.field_1060);
            components.add((class_2561)class_2561.method_43469((String)"collectorsalbum.label.custom_drop_table", (Object[])new Object[]{customTableLabel}).method_27692(class_124.field_1080));
        } else if (this.lootDataSourcePath == null) {
            components.add((class_2561)class_2561.method_43469((String)"collectorsalbum.label.custom_drop_table", (Object[])new Object[]{LABEL_UNSET}).method_27692(class_124.field_1080));
        }
    }

    public record PackContents(List<class_1799> contents) {
        public static final Codec<PackContents> CODEC = class_1799.field_24671.listOf().xmap(PackContents::new, contents -> contents.contents);

        public boolean isEmpty() {
            return this.contents.isEmpty();
        }
    }
}

