/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.common.resource;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import team.tnt.collectorsalbum.common.resource.bonus.AlbumBonus;
import team.tnt.collectorsalbum.common.resource.bonus.AlbumBonusType;
import team.tnt.collectorsalbum.common.resource.bonus.NoBonus;
import team.tnt.collectorsalbum.common.resource.util.ActionContext;
import team.tnt.collectorsalbum.platform.resource.PlatformGsonCodecReloadListener;

public final class AlbumBonusManager
extends PlatformGsonCodecReloadListener<AlbumBonus> {
    private static final class_2960 IDENTIFIER = class_2960.method_60655((String)"collectorsalbum", (String)"album_bonus_manager");
    private static final AlbumBonusManager INSTANCE = new AlbumBonusManager();
    private final Map<class_2960, AlbumBonus> registeredBonuses = new HashMap<class_2960, AlbumBonus>();
    private final List<AlbumBonus> bonusList = new ArrayList<AlbumBonus>();

    private AlbumBonusManager() {
        super("album/bonus", AlbumBonusType.INSTANCE_CODEC);
    }

    public static AlbumBonusManager getInstance() {
        return INSTANCE;
    }

    public void applyBonuses(ActionContext context) {
        this.bonusList.forEach(bonus -> bonus.apply(context));
    }

    public void removeBonuses(ActionContext context) {
        this.bonusList.forEach(bonus -> bonus.removed(context));
    }

    public Pair<AlbumBonus, AlbumBonus> getBonusesForPage(int page) {
        int leftIdx = page * 2;
        int rightIdx = leftIdx + 1;
        AlbumBonus left = this.getBonusAtIndex(leftIdx);
        AlbumBonus right = this.getBonusAtIndex(rightIdx);
        return Pair.of((Object)left, (Object)right);
    }

    public boolean hasNextPage(int currentPage) {
        int lastDisplayed = currentPage * 2 + 1;
        return lastDisplayed >= 0 && lastDisplayed < this.bonusList.size() - 1;
    }

    @Override
    public class_2960 identifier() {
        return IDENTIFIER;
    }

    @Override
    public List<AlbumBonus> getNetworkData() {
        return new ArrayList<AlbumBonus>(this.registeredBonuses.values());
    }

    @Override
    public synchronized void onNetworkDataReceived(List<AlbumBonus> collection) {
        this.bonusList.clear();
        this.bonusList.addAll(collection);
    }

    @Override
    protected void preApply(Map<class_2960, JsonElement> resources, class_3300 manager, class_3695 profiler) {
        this.registeredBonuses.clear();
        this.bonusList.clear();
    }

    @Override
    protected void resolve(class_2960 path, AlbumBonus element) {
        this.registeredBonuses.put(path, element);
        this.bonusList.add(element);
    }

    private AlbumBonus getBonusAtIndex(int index) {
        if (index < 0 || index >= this.bonusList.size()) {
            return NoBonus.INSTANCE;
        }
        return this.bonusList.get(index);
    }
}

