/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.common.resource;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import team.tnt.collectorsalbum.common.AlbumCategory;
import team.tnt.collectorsalbum.common.AlbumCategoryType;
import team.tnt.collectorsalbum.platform.resource.PlatformGsonCodecReloadListener;

public final class AlbumCategoryManager
extends PlatformGsonCodecReloadListener<AlbumCategory> {
    private static final class_2960 IDENTIFIER = class_2960.method_60655((String)"collectorsalbum", (String)"album_category_manager");
    private static final AlbumCategoryManager INSTANCE = new AlbumCategoryManager();
    private final Map<class_2960, AlbumCategory> registeredCategories = new HashMap<class_2960, AlbumCategory>();
    private final List<AlbumCategory> pagedCategories = new ArrayList<AlbumCategory>();

    private AlbumCategoryManager() {
        super("album/categories", AlbumCategoryType.INSTANCE_CODEC);
    }

    public static AlbumCategoryManager getInstance() {
        return INSTANCE;
    }

    public AlbumCategory getCategoryForPage(int page) {
        return page >= 0 && page < this.pagedCategories.size() ? this.pagedCategories.get(page) : null;
    }

    public int getPageForCategory(AlbumCategory category) {
        return this.pagedCategories.indexOf(category);
    }

    public List<AlbumCategory> listBookmarkableCategories() {
        return this.pagedCategories.stream().filter(cat -> !cat.visualTemplate().bookmarkIcon.method_7960()).toList();
    }

    public int getCollectibleCardCount() {
        return this.pagedCategories.stream().mapToInt(category -> category.getCardNumbers().length).sum();
    }

    public Collection<AlbumCategory> listCategories() {
        return this.registeredCategories.values();
    }

    @Override
    public class_2960 identifier() {
        return IDENTIFIER;
    }

    public Optional<AlbumCategory> findById(class_2960 id) {
        return Optional.ofNullable(this.registeredCategories.get(id));
    }

    @Override
    protected void preApply(Map<class_2960, JsonElement> resources, class_3300 manager, class_3695 profiler) {
        this.registeredCategories.clear();
        this.pagedCategories.clear();
    }

    @Override
    protected void resolve(class_2960 path, AlbumCategory element) {
        if (this.registeredCategories.putIfAbsent(path, element) != null) {
            throw new IllegalArgumentException("Duplicate card category: " + String.valueOf(element.identifier()));
        }
    }

    @Override
    protected void onReloadComplete(class_3300 manager, class_3695 profiler) {
        super.onReloadComplete(manager, profiler);
        this.registeredCategories.values().stream().sorted(Comparator.comparingInt(AlbumCategory::getPageOrder)).forEach(this.pagedCategories::add);
    }

    @Override
    public List<AlbumCategory> getNetworkData() {
        return new ArrayList<AlbumCategory>(this.registeredCategories.values());
    }

    @Override
    public synchronized void onNetworkDataReceived(List<AlbumCategory> collection) {
        this.registeredCategories.clear();
        this.pagedCategories.clear();
        collection.forEach(category -> this.registeredCategories.put(category.identifier(), (AlbumCategory)category));
        this.pagedCategories.addAll(collection.stream().sorted(Comparator.comparingInt(AlbumCategory::getPageOrder)).toList());
    }
}

