/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.common.resource.function;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.toma.configuration.Configuration;
import java.util.Optional;
import java.util.function.Function;
import team.tnt.collectorsalbum.common.init.NumberProviderRegistry;
import team.tnt.collectorsalbum.common.resource.function.NumberProvider;
import team.tnt.collectorsalbum.common.resource.function.NumberProviderType;

public class ConfigValueIntProvider
implements NumberProvider {
    public static final MapCodec<ConfigValueIntProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("config").forGetter(t -> t.config), (App)Codec.STRING.fieldOf("path").forGetter(t -> t.path), (App)Codec.DOUBLE.optionalFieldOf("defaultValue", (Object)0.0).forGetter(t -> t.defaultValue)).apply((Applicative)instance, ConfigValueIntProvider::new));
    private final String config;
    private final String path;
    private final double defaultValue;

    public ConfigValueIntProvider(String configId, String path, double defaultValue) {
        this.config = configId;
        this.path = path;
        this.defaultValue = defaultValue;
    }

    @Override
    public <N extends Number> N getNumber(Function<Number, N> mapper) {
        Optional holder = Configuration.getConfig((String)this.config);
        Number number = holder.flatMap(cfg -> cfg.getValue(this.path, Number.class)).orElse(this.defaultValue);
        return (N)((Number)mapper.apply(number));
    }

    @Override
    public NumberProviderType<?> getType() {
        return (NumberProviderType)NumberProviderRegistry.CONFIG_INT.get();
    }
}

