/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.platform.network;

import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import team.tnt.collectorsalbum.platform.Platform;
import team.tnt.collectorsalbum.platform.Side;
import team.tnt.collectorsalbum.platform.network.Network;
import team.tnt.collectorsalbum.platform.network.PacketDirection;
import team.tnt.collectorsalbum.platform.network.PacketHandler;
import team.tnt.collectorsalbum.platform.network.PacketHolder;

public class FabricNetwork
implements Network {
    @Override
    public void initialize(class_2960 identifier, List<PacketHolder<?, ?>> c2s, List<PacketHolder<?, ?>> s2c) {
        PayloadTypeRegistry c2sRegistrar = PayloadTypeRegistry.playC2S();
        PayloadTypeRegistry s2cRegistrar = PayloadTypeRegistry.playS2C();
        c2s.forEach(holder -> this.registerInternal((PayloadTypeRegistry<?>)c2sRegistrar, (PacketHolder)holder, PacketDirection.CLIENT_TO_SERVER));
        s2c.forEach(holder -> this.registerInternal((PayloadTypeRegistry<?>)s2cRegistrar, (PacketHolder)holder, PacketDirection.SERVER_TO_CLIENT));
    }

    @Override
    public void sendClientMessage(class_3222 player, class_8710 payload) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
    }

    @Override
    public void sendServerMessage(class_8710 payload) {
        ClientPlayNetworking.send((class_8710)payload);
    }

    private <P extends class_8710> void registerInternal(PayloadTypeRegistry<?> registrar, PacketHolder<P, ?> holder, PacketDirection direction) {
        registrar.register(holder.type(), holder.codec());
        PacketHandler handler = holder.handler();
        if (handler != null) {
            Side side = Platform.INSTANCE.getSide();
            if (direction == PacketDirection.CLIENT_TO_SERVER) {
                ServerPlayNetworking.registerGlobalReceiver(holder.type(), (payload, context) -> handler.handle(payload, (class_1657)context.player()));
            } else if (direction == PacketDirection.SERVER_TO_CLIENT && side == Side.CLIENT) {
                this.registerInternalClientReceiver(holder.type(), handler);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private <P extends class_8710> void registerInternalClientReceiver(class_8710.class_9154<P> type, PacketHandler<P> handler) {
        ClientPlayNetworking.registerGlobalReceiver(type, (payload, context) -> this.handleClientBoundPayload(payload, context, handler));
    }

    @Environment(value=EnvType.CLIENT)
    private <P extends class_8710> void handleClientBoundPayload(P payload, ClientPlayNetworking.Context context, PacketHandler<P> handler) {
        handler.handle(payload, (class_1657)context.player());
    }
}

