/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.platform.registration;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import team.tnt.collectorsalbum.platform.registration.PlatformRegistry;

public final class PlatformRegistryFactory {
    private static List<BindableRegistryReference<?>> PREPARED_REGISTRIES = new ArrayList();

    public static <T> PlatformRegistry.RegistryReference<T> createSimple(class_5321<class_2378<T>> key, boolean sync) {
        RegistryAttributes<T> attributes = new RegistryAttributes<T>(key, null, sync);
        BindableRegistryReference<T> reference = new BindableRegistryReference<T>(attributes);
        PREPARED_REGISTRIES.add(reference);
        return reference;
    }

    public static <T> PlatformRegistry.RegistryReference<T> createSimple(class_5321<class_2378<T>> key) {
        return PlatformRegistryFactory.createSimple(key, true);
    }

    public static <T> PlatformRegistry.RegistryReference<T> createDefaulted(class_5321<class_2378<T>> key, boolean sync, class_2960 defaultKey) {
        RegistryAttributes<T> attributes = new RegistryAttributes<T>(key, defaultKey, sync);
        BindableRegistryReference<T> reference = new BindableRegistryReference<T>(attributes);
        PREPARED_REGISTRIES.add(reference);
        return reference;
    }

    public static <T> PlatformRegistry.RegistryReference<T> createDefaulted(class_5321<class_2378<T>> key, class_2960 defaultKey) {
        return PlatformRegistryFactory.createDefaulted(key, true, defaultKey);
    }

    public static <T> void bindRefs(BiConsumer<RegistryAttributes<T>, RegistryBinder<T>> builder) {
        for (BindableRegistryReference<?> reference : PREPARED_REGISTRIES) {
            PlatformRegistryFactory.bindRef(reference, builder);
        }
        PREPARED_REGISTRIES = null;
    }

    public static <T> void bindRef(PlatformRegistry.RegistryReference<T> reference, BiConsumer<RegistryAttributes<T>, RegistryBinder<T>> builder) {
        BindableRegistryReference bindable = (BindableRegistryReference)reference;
        RegistryAttributes attributes = bindable.attributes;
        builder.accept(attributes, bindable::bind);
    }

    public record RegistryAttributes<T>(class_5321<class_2378<T>> key, class_2960 defaultKey, boolean sync) {
    }

    private static final class BindableRegistryReference<T>
    implements PlatformRegistry.RegistryReference<T> {
        private final RegistryAttributes<T> attributes;
        private class_2378<T> instance;

        public BindableRegistryReference(RegistryAttributes<T> attributes) {
            this.attributes = attributes;
        }

        @Override
        public class_2378<T> get() {
            if (this.instance == null) {
                throw new IllegalStateException("Cannot obtain registry instance before registration");
            }
            return this.instance;
        }

        public void bind(class_2378<T> instance) {
            this.instance = instance;
        }
    }

    @FunctionalInterface
    public static interface RegistryBinder<T> {
        public void bind(class_2378<T> var1);
    }
}

