/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.platform.resource;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.Message;
import team.tnt.collectorsalbum.platform.resource.PlatformGsonReloadListener;

public abstract class PlatformGsonCodecReloadListener<T>
extends PlatformGsonReloadListener {
    public static final Gson GSON = new Gson();
    private final Codec<T> codec;

    public PlatformGsonCodecReloadListener(String dir, Codec<T> codec) {
        super(GSON, dir);
        this.codec = codec;
    }

    public Codec<T> codec() {
        return this.codec;
    }

    public List<T> getNetworkData() {
        return null;
    }

    public synchronized void onNetworkDataReceived(List<T> collection) {
    }

    protected abstract void preApply(Map<class_2960, JsonElement> var1, class_3300 var2, class_3695 var3);

    protected abstract void resolve(class_2960 var1, T var2);

    protected boolean filterEntry(class_2960 identifier) {
        return true;
    }

    @Override
    public final void apply(Map<class_2960, JsonElement> resource, class_3300 manager, class_3695 profiler) {
        this.preApply(resource, manager, profiler);
        for (Map.Entry<class_2960, JsonElement> entry : resource.entrySet()) {
            class_2960 identifier = entry.getKey();
            if (!this.filterEntry(identifier)) continue;
            JsonElement element = entry.getValue();
            try {
                DataResult dataResult = this.codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)element);
                T data = this.readData(identifier, dataResult);
                this.resolve(identifier, data);
            }
            catch (Exception e) {
                this.handleParsingError(e, identifier);
            }
        }
        this.onReloadComplete(manager, profiler);
    }

    protected void onReloadComplete(class_3300 manager, class_3695 profiler) {
    }

    protected void handleParsingError(Exception e, class_2960 currentPath) {
        LOGGER.error((Message)new FormattedMessage("Failed to parse {} element due to error", (Object)currentPath), (Throwable)e);
    }

    protected T readData(class_2960 path, DataResult<T> dataResult) {
        return (T)dataResult.getOrThrow();
    }
}

