/*
 * Decompiled with CFR 0.152.
 */
package me.fzzyhmstrs.fzzy_config.util;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import me.fzzyhmstrs.fzzy_config.registry.ClientConfigRegistry;
import me.fzzyhmstrs.fzzy_config.registry.SyncedConfigRegistry;
import me.fzzyhmstrs.fzzy_config.util.FcText;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_437;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\tJ\u0015\u0010\r\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001d\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0013\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001d\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0019\u0010\u001aJ/\u0010\u001f\u001a\"\u0012\u0004\u0012\u00020\u000b\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u001c0\u001bH\u0007\u00a2\u0006\u0004\b\u001f\u0010 J\r\u0010\"\u001a\u00020!\u00a2\u0006\u0004\b\"\u0010\u0003J\u001d\u0010\"\u001a\u00020!2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020$0#H\u0002\u00a2\u0006\u0004\b\"\u0010&\u00a8\u0006'"}, d2={"Lme/fzzyhmstrs/fzzy_config/util/PlatformUtils;", "", "<init>", "()V", "", "isClient", "()Z", "Ljava/io/File;", "configDir", "()Ljava/io/File;", "gameDir", "", "mod", "isModLoaded", "(Ljava/lang/String;)Z", "scope", "fallback", "configName", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "", "customScopes", "()Ljava/util/List;", "Lnet/minecraft/class_1657;", "player", "permission", "hasPermission", "(Lnet/minecraft/class_1657;Ljava/lang/String;)Z", "", "Ljava/util/function/BiFunction;", "Lnet/minecraft/class_437;", "Lnet/fabricmc/loader/api/ModContainer;", "createConfigFactoryProvider", "()Ljava/util/Map;", "", "registerCommands", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/class_2168;", "dispatcher", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "fzzy_config"})
@SourceDebugExtension(value={"SMAP\nPlatformUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlatformUtils.kt\nme/fzzyhmstrs/fzzy_config/util/PlatformUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,135:1\n1279#2,2:136\n1293#2,4:138\n*S KotlinDebug\n*F\n+ 1 PlatformUtils.kt\nme/fzzyhmstrs/fzzy_config/util/PlatformUtils\n*L\n73#1:136,2\n73#1:138,4\n*E\n"})
public final class PlatformUtils {
    @NotNull
    public static final PlatformUtils INSTANCE = new PlatformUtils();

    private PlatformUtils() {
    }

    public final boolean isClient() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }

    @NotNull
    public final File configDir() {
        File file = FabricLoader.getInstance().getConfigDir().toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return file;
    }

    @NotNull
    public final File gameDir() {
        File file = FabricLoader.getInstance().getGameDir().toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return file;
    }

    public final boolean isModLoaded(@NotNull String mod) {
        Intrinsics.checkNotNullParameter((Object)mod, (String)"mod");
        return FabricLoader.getInstance().isModLoaded(mod);
    }

    @NotNull
    public final String configName(@NotNull String scope, @NotNull String fallback) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)fallback, (String)"fallback");
        Object object = FabricLoader.getInstance().getModContainer(scope);
        if (object == null || (object = (ModContainer)((Optional)object).get()) == null || (object = object.getMetadata()) == null || (object = object.getName()) == null) {
            object = fallback;
        }
        return object;
    }

    @NotNull
    public final List<String> customScopes() {
        List list = new ArrayList();
        for (ModContainer container : FabricLoader.getInstance().getAllMods()) {
            CustomValue customValue;
            if (container.getMetadata().getCustomValue("fzzy_config") == null || customValue.getType() != CustomValue.CvType.ARRAY) continue;
            CustomValue.CvArray arrayValue = customValue.getAsArray();
            for (CustomValue thing : arrayValue) {
                if (thing.getType() != CustomValue.CvType.STRING) continue;
                String string = thing.getAsString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
                list.add(string);
            }
        }
        return list;
    }

    public final boolean hasPermission(@NotNull class_1657 player, @NotNull String permission) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        return Permissions.check((class_1297)((class_1297)player), (String)permission);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Map<String, BiFunction<class_437, ModContainer, class_437>> createConfigFactoryProvider() {
        Iterable $this$associateWith$iv = ClientConfigRegistry.INSTANCE.getScreenScopes$fzzy_config();
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void scope;
            String string = (String)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            BiFunction<class_437, ModContainer, class_437> biFunction = (arg_0, arg_1) -> PlatformUtils.createConfigFactoryProvider$lambda$1$lambda$0((String)scope, arg_0, arg_1);
            map.put(t, biFunction);
        }
        return result$iv;
    }

    public final void registerCommands() {
        CommandRegistrationCallback.EVENT.register(PlatformUtils::registerCommands$lambda$2);
    }

    private final void registerCommands(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"configure_update").requires(PlatformUtils::registerCommands$lambda$3)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"id", (ArgumentType)((ArgumentType)StringArgumentType.string())).then(class_2170.method_9247((String)"inspect").executes(PlatformUtils::registerCommands$lambda$6))).then(class_2170.method_9247((String)"accept").executes(PlatformUtils::registerCommands$lambda$8))).then(class_2170.method_9247((String)"reject").executes(PlatformUtils::registerCommands$lambda$10))));
    }

    private static final class_437 createConfigFactoryProvider$lambda$1$lambda$0(String $scope, class_437 class_4372, ModContainer modContainer) {
        Intrinsics.checkNotNullParameter((Object)class_4372, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)modContainer, (String)"<unused var>");
        return ClientConfigRegistry.INSTANCE.provideScreen$fzzy_config($scope);
    }

    private static final void registerCommands$lambda$2(CommandDispatcher dispatcher, class_7157 class_71572, class_2170.class_5364 class_53642) {
        Intrinsics.checkNotNull((Object)dispatcher);
        INSTANCE.registerCommands((CommandDispatcher<class_2168>)dispatcher);
    }

    private static final boolean registerCommands$lambda$3(class_2168 source) {
        return source.method_9259(3);
    }

    private static final class_2561 registerCommands$lambda$6$lambda$4(CommandContext $context, UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        class_3222 class_32222 = ((class_2168)$context.getSource()).method_9211().method_3760().method_14602(uuid);
        return class_32222 != null ? class_32222.method_5477() : null;
    }

    private static final void registerCommands$lambda$6$lambda$5(CommandContext $context, class_2561 message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        ((class_2168)$context.getSource()).method_45068(message);
    }

    private static final int registerCommands$lambda$6(CommandContext context) {
        String id = StringArgumentType.getString((CommandContext)context, (String)"id");
        if (id == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)FcText.INSTANCE.translate("fc.command.error.no_id", new Object[0]));
            return 0;
        }
        SyncedConfigRegistry.INSTANCE.inspectQuarantine$fzzy_config(id, arg_0 -> PlatformUtils.registerCommands$lambda$6$lambda$4(context, arg_0), arg_0 -> PlatformUtils.registerCommands$lambda$6$lambda$5(context, arg_0));
        return 1;
    }

    private static final class_2561 registerCommands$lambda$8$lambda$7(String $id) {
        Object[] objectArray = new Object[]{$id};
        return (class_2561)FcText.INSTANCE.translate("fc.command.accepted", objectArray);
    }

    private static final int registerCommands$lambda$8(CommandContext context) {
        String id = StringArgumentType.getString((CommandContext)context, (String)"id");
        if (id == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)FcText.INSTANCE.translate("fc.command.error.no_id", new Object[0]));
            return 0;
        }
        MinecraftServer minecraftServer = ((class_2168)context.getSource()).method_9211();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        SyncedConfigRegistry.INSTANCE.acceptQuarantine$fzzy_config(id, minecraftServer);
        ((class_2168)context.getSource()).method_9226(() -> PlatformUtils.registerCommands$lambda$8$lambda$7(id), true);
        return 1;
    }

    private static final class_2561 registerCommands$lambda$10$lambda$9(String $id) {
        Object[] objectArray = new Object[]{$id};
        return (class_2561)FcText.INSTANCE.translate("fc.command.rejected", objectArray);
    }

    private static final int registerCommands$lambda$10(CommandContext context) {
        String id = StringArgumentType.getString((CommandContext)context, (String)"id");
        if (id == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)FcText.INSTANCE.translate("fc.command.error.no_id", new Object[0]));
            return 0;
        }
        MinecraftServer minecraftServer = ((class_2168)context.getSource()).method_9211();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        SyncedConfigRegistry.INSTANCE.rejectQuarantine$fzzy_config(id, minecraftServer);
        ((class_2168)context.getSource()).method_9226(() -> PlatformUtils.registerCommands$lambda$10$lambda$9(id), true);
        return 1;
    }
}

