/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.coroutil.command;

import com.corosus.coroutil.util.CULog;
import com.corosus.modconfig.ConfigMod;
import com.corosus.modconfig.CoroConfigRegistry;
import com.corosus.modconfig.ModConfigData;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;

public class CommandCoroConfig {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)CommandCoroConfig.getCommandName()).requires(s -> s.method_9259(2))).then(class_2170.method_9247((String)"config").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"common").then(CommandCoroConfig.argumentReload(ModConfig.Type.COMMON))).then(CommandCoroConfig.argumentSave())).then(CommandCoroConfig.argumentGet())).then(CommandCoroConfig.argumentSet()))));
    }

    public static ArgumentBuilder<class_2168, ?> argumentReload(ModConfig.Type type) {
        return class_2170.method_9247((String)"reload").executes(c -> {
            CULog.log("reloading all mods common configurations from disk");
            ConfigTracker.INSTANCE.loadConfigs(type, ConfigMod.instance().getConfigPath());
            ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)"Reloading all common configs from disk"), true);
            return 1;
        });
    }

    public static ArgumentBuilder<class_2168, ?> argumentSave() {
        return class_2170.method_9247((String)"save").executes(c -> {
            CULog.log("saving all coro mods runtime configs to disk");
            CoroConfigRegistry.instance().forceSaveAllFilesFromRuntimeSettings();
            ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)"Saving all common coro configs to disk"), true);
            return 1;
        });
    }

    public static ArgumentBuilder<class_2168, ?> argumentGet() {
        return class_2170.method_9247((String)"get").then(class_2170.method_9244((String)"file_name", (ArgumentType)StringArgumentType.word()).suggests((p_136339_, p_136340_) -> class_2172.method_9265(CommandCoroConfig.getConfigs(), (SuggestionsBuilder)p_136340_)).then(class_2170.method_9244((String)"setting_name", (ArgumentType)StringArgumentType.word()).suggests((p_136339_, p_136340_) -> class_2172.method_9265(CommandCoroConfig.getConfigSettings(StringArgumentType.getString((CommandContext)p_136339_, (String)"file_name")), (SuggestionsBuilder)p_136340_)).executes(c -> {
            String fileName = CommandCoroConfig.fileToConfig(StringArgumentType.getString((CommandContext)c, (String)"file_name"));
            String configName = CoroConfigRegistry.instance().lookupFilePathToConfig.get((Object)fileName).configID;
            String settingName = StringArgumentType.getString((CommandContext)c, (String)"setting_name");
            Object obj = CoroConfigRegistry.instance().getField(configName, settingName);
            ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)(settingName + " = " + String.valueOf(obj) + " in " + fileName)), true);
            return 1;
        })));
    }

    public static ArgumentBuilder<class_2168, ?> argumentSet() {
        return class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"file_name", (ArgumentType)StringArgumentType.word()).suggests((p_136339_, p_136340_) -> class_2172.method_9265(CommandCoroConfig.getConfigs(), (SuggestionsBuilder)p_136340_)).then(class_2170.method_9244((String)"setting_name", (ArgumentType)StringArgumentType.word()).suggests((p_136339_, p_136340_) -> class_2172.method_9265(CommandCoroConfig.getConfigSettings(StringArgumentType.getString((CommandContext)p_136339_, (String)"file_name")), (SuggestionsBuilder)p_136340_)).then(class_2170.method_9244((String)"value", (ArgumentType)StringArgumentType.string()).executes(c -> {
            String fileName = CommandCoroConfig.fileToConfig(StringArgumentType.getString((CommandContext)c, (String)"file_name"));
            String configName = CoroConfigRegistry.instance().lookupFilePathToConfig.get((Object)fileName).configID;
            String settingName = StringArgumentType.getString((CommandContext)c, (String)"setting_name");
            String value = StringArgumentType.getString((CommandContext)c, (String)"value");
            boolean result = CoroConfigRegistry.instance().updateField(configName, settingName, value);
            if (result) {
                Object obj = CoroConfigRegistry.instance().getField(configName, settingName);
                CoroConfigRegistry.instance().forceSaveAllFilesFromRuntimeSettings();
                ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)("Set " + settingName + " to " + String.valueOf(obj) + " in " + fileName)), true);
            } else {
                ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)("Invalid setting to use for " + settingName)), true);
            }
            return 1;
        }))));
    }

    public static String getCommandName() {
        return "coro";
    }

    public static Iterable<String> getConfigs() {
        return CoroConfigRegistry.instance().lookupFilePathToConfig.keySet().stream().map(e -> e.replace("\\", "--")).toList();
    }

    public static Iterable<String> getConfigSettings(String config_name) {
        ModConfigData modConfigData = CoroConfigRegistry.instance().lookupFilePathToConfig.get(CommandCoroConfig.fileToConfig(config_name));
        if (modConfigData != null) {
            ArrayList<String> joinedList = new ArrayList<String>();
            joinedList.addAll(modConfigData.valsString.keySet());
            joinedList.addAll(modConfigData.valsInteger.keySet());
            joinedList.addAll(modConfigData.valsDouble.keySet());
            joinedList.addAll(modConfigData.valsBoolean.keySet());
            Collections.sort(joinedList);
            return joinedList;
        }
        return List.of("<-- invalid config name");
    }

    public static String fileToConfig(String str) {
        return str.replace("--", "\\");
    }
}

