/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resourceconfigapi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_8710;
import net.xstopho.resourceconfigapi.ResourceConfigConstants;
import net.xstopho.resourceconfigapi.api.ConfigRegistry;
import net.xstopho.resourceconfigapi.config.ResourceModConfig;
import net.xstopho.resourceconfigapi.config.entry.ConfigEntry;
import net.xstopho.resourceconfigapi.network.ConfigNetwork;
import net.xstopho.resourceconfigapi.network.packet.SyncBooleanConfigEntryPacket;
import net.xstopho.resourceconfigapi.network.packet.SyncDoubleConfigEntryPacket;
import net.xstopho.resourceconfigapi.network.packet.SyncIntegerConfigEntryPacket;
import net.xstopho.resourceconfigapi.network.packet.SyncStringConfigEntryPacket;

public class ResourceConfig
implements ModInitializer {
    public static List<String> CONFIGS = new ArrayList<String>();

    public void onInitialize() {
        ConfigNetwork.initServer();
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            ResourceConfigConstants.LOG.info("Syncing Config Values with Client");
            HashMap<String, ResourceModConfig> configs = ConfigRegistry.getConfigFiles();
            for (Map.Entry<String, ResourceModConfig> config : configs.entrySet()) {
                ResourceConfigConstants.LOG.info("Syncing Values for ModConfigFile: {}", (Object)config.getKey());
                ResourceModConfig modConfig = config.getValue();
                for (ConfigEntry<?> entry : modConfig.getBuilder().getEntries().values()) {
                    if (!entry.syncWithServer()) continue;
                    this.sendPacket(sender, entry, config.getKey());
                }
            }
        });
    }

    public void sendPacket(PacketSender sender, ConfigEntry<?> entry, String fileName) {
        if (entry.getValue() instanceof Integer) {
            sender.sendPacket((class_8710)new SyncIntegerConfigEntryPacket(fileName, entry.getPath(), (Integer)entry.value()));
        }
        if (entry.getValue() instanceof Double) {
            sender.sendPacket((class_8710)new SyncDoubleConfigEntryPacket(fileName, entry.getPath(), (Double)entry.value()));
        }
        if (entry.getValue() instanceof String) {
            sender.sendPacket((class_8710)new SyncStringConfigEntryPacket(fileName, entry.getPath(), (String)entry.value()));
        }
        if (entry.getValue() instanceof Boolean) {
            sender.sendPacket((class_8710)new SyncBooleanConfigEntryPacket(fileName, entry.getPath(), (Boolean)entry.value()));
        }
    }
}

